/** 

 @mainpage C++ Interface to Tauola 
 @brief Description of Tauola Interface in C++

 @authors Nadia Davidson, Gizo Nanava, Tomasz Przedzinski, Elzbieta Richter-Was, Zbigniew Was

 @section download Older release

 The source code and documentation for the release 1.0. The following files are provided for download:
 - <a href="http://arxiv.org/abs/1002.0543">arXiv:1002.0543</a> full software documentation.
 - <a href="../TAUOLA.1.0.tar.gz">TAUOLA source code </a> tarball.
 @section download1 New release

 The source code and documentation for the release 1.0.2
 - <a href="../Tauola_interface_design.1.0.2.pdf">Tauola_interface_design.1.0.2.pdf</a> full software documentation includes updates with respect to 
preprint version.
 - <a href="../TAUOLA.1.0.2.tar.gz">TAUOLA source code</a> tarball and its <a href="../svn_info_tauola.1.0.2.txt">revision info</a> SVN tag, tarball 
creation date/time, etc. For updates  with respect to release 1.0 see <a href="../changelog.1.0.2.txt">changelog.txt</a>.
 @section developement Developement version

 The source code and documentation are updated daily from the repository as well. The following files are provided for download of developement version:
 - <a href="../Tauola_interface_design.pdf">Tauola_interface_design.pdf</a> full software documentation.
 - <a href="../TAUOLA.daily_temp.tar.gz">TAUOLA source code</a> tarball and its <a href="../svn_info_tauola.txt">revision info</a> SVN tag, tarball creation date/time, etc. At present it is identical to version 1.0.2. For updates  with respect to release 1.0 see <a href="changelog.txt">changelog.txt</a>.
 @section intro Introduction/Status

 At prestent (since Feb 2 2010) the C++ interface functionality for TAUOLA is  complete.
 Longitudinal spin correlation are being checked using <a href="http://mc-tester.web.cern.ch/MC-TESTER/">
 MC-TESTER</a> now. Transverse spin correlations and full functionality of TAUOLA  Universal Interface 
 are coded. Genuine electrowek corrections for proceeses mediated by Z/gamma are implemented as well.

 The tar file contains the c++ interface along with the source code for tauola itself (as available from <a href="http://wasm.web.cern.ch/wasm/goodies.html">old web page</a>; version Oct 11 2005).
 The developement version contains the latest source code for the interface from our subversion repository. Note that 
 revision numbers, dates and other info for this development version can be found in revision information file listed above. 

 At present, the tar ball includes everything that is needed for installation. User is advised to use  HepMC 2.04+ libraries as described below.
 @section setup Requirements

 For compilation, and to run simple example, the interface requires:
 - <a href="http://lcgapp.cern.ch/project/simu/HepMC/">HepMC v2.04</a> or later.

 For further examples, one need to install also:
 - <a href="http://root.cern.ch/drupal/">ROOT v5.18</a> or later
 - <a href="http://home.thep.lu.se/~torbjorn/Pythia.html">PYTHIA 8.1</a> or later. PYTHIA must be compiled with HepMC 2 so that the PYTHIA library hepmcinterface exists.
 - <a href="http://mc-tester.web.cern.ch/MC-TESTER/">MC-TESTER v1.24</a> or later. Do not forget to compile the additional HepMC library libHepMCEvent as well.

 @section compile Configuration and Compilation

 In order to compile the TAUOLA C++ interface:
 - Execute './configure' with additional command line options:
   - '--with-HepMC=\<path\> ' provides the path to HepMC installation directory. One can set HEPMCLOCATION variable instead of using this directive. This path is required for interface to compile.
   - '--prefix=\<path\>' provides the installation path. The 'include' and 'lib' directories will be copied there if 'make install' is executed later. If none has been provided, the default directory for installation is '/usr/local'.
 - Execute 'make'
 - Optionally, execute 'make install' to copy files to the directory provided during configuration.

 After compiling the 'tauola-fortran' part, the TAUOLA C++ interface will be compiled and the '/lib' and '/include' directories will contain the appropriate library and include files.

 In order to compile the examples, enter 'examples' directory, and:
 - execute './configure' to determine which examples can be compiled. Additional paths can be provided as command line options:
   - '--with-Pythia8=\<path\>' provides the path to Pythia8 installation directory. One can set PYTHIALOCATION variable instead of using this directive. This path is required for all additional examples and tests.
   - '--with-MC-Tester=\<path\>' provides the path to MC-Tester installation directory (the libHepMCEvent must be compiled as well, check MC-Tester documentation for more details). One can set MCTESTERLOCATION variable instead of using this directive. This path is required for all additional examples and tests. It is assumed that using this option also implies that ROOT has already been installed (since it's required by MC-TESTER). The location of its binaries should be listed in PATH variable.
 - execute 'make'

 Note that for examples working with PYTHIA 8.1, PYTHIA8DATA global variable must be set (refer to instructions provided during configuration).
 Similar, for examples in examples/testing directory to work, MCTESTERLOCATION global variable must be set.
 If neither PYTHIA nor MC-TESTER are present, only the simple example will be provided. The '/examples' directory will contain the compiled example files.

 If you prefer not to use configuration scripts,
 you may find <a href="README-NO-CONFIG.txt">README-NO-CONFIG.txt</a> useful.

 @section testing Testing

 In order to run some more specific tests both PYTHIA and MC-TESTER must be installed.
 - Compile TAUOLA C++ interface as well as examples.
 -  Check that  appropriate system variables are set: normally set by script
 configure.paths.sh [.csh] (configuation step is mentioning this script).
 -  Enter /examples/testing directory. Modify test.inc if needed.
 - enter selected directory and execute 'make'.

 The appropriate .root files as well as .pdf files generated by MC-TESTER will be created inside the choosen directory. You can execute 'make clobber' to clean the directory. You can also execute 'make' inside 'TAUOLA/examples/testing' directory to run all aviable tests one after another.

 @section sanc SANC
 Electroweak corrections may affect spin correlations between tau+ and tau- in a significant way. This is the case at high energies, 
far above WW threshold. At present we use alpha scheme for electroweak calculations, this choice may be not optimal for the
cross section weight aiming at implementation of electroweak corrections. For this, end scheme schould be consistent with choice 
of host generator. On the other hand this is not the problem for spin correlations, our prime interest. In addition, if tables are used, transverse spin correlations for processes  mediated by Z and gamma are taken into account.

Changes to the tables generated by SANC module can be implemented by modifying interface located in '/SANC' directory. Details regarding the structure and initialization variables of the interface are described in the documentation. In order to generate new tables:
 - execute 'make' in '/SANC' directory to compile the library and tools.
 - Adjust initialization in SANC tables calculation if needed.
 - execute 'make tables' in '/SANC' directory to generate the tables.
 - move tables to the directory from which your main program is executed.

 <hr>
 @section description Description of the code

 @image html tauola_interface_design.png "Design of Interface. Components are described in more detail below."
 
 @subsection outline Algorithm Outline

 The simplified version of the main program structure including the tauola decay routines would consist of:
 - initialize Monte Carlo generator and all other generators / analysis tools.
 - set appropriate parameters for Tauola interface.
 - invoke Tauola::initialize() routine.
 - for each event to be generated:
   - generate event using any Monte Carlo generator
   - convert generated event to HepMC event record 
   - create TauolaHepMCEvent from HepMC event object
   - invoke decayTaus() for TauolaHepMCEvent object. If tau has already been decayed by MC generator, use undecayTaus() first.
   - the HepMC event is now prepared and can be used in analysis
 - finalize analysis
 - print any summary output if needed and exit

 @subsection flow Flow of Control

 The following is a more detailed example point by point of how a tau, or set of taus, are decayed using the interface with HepMC event record implementation.

 Starting from the main program:
 - at initialization step, appropriate configuration routines via 'Tauola' class methods can be executed.
 - Tauola::initialise() method must be invoked, which calls the Initialise() methods in f_Init, which in turn calls the initilisation routines of TAUOLA.

 In the main event loop, after the HepMC event is filled by Monte Carlo generator:
 - An appropriate implementation of abstract class TauolaEvent - TauolaHepMCEvent object must be created, taking HepMC::GenEvent object as its parameter.
 - The method decayTaus() for the created TauolaHepMCEvent object must be invoked. If the Monte Carlo generator has already performed the decays of tau, the undecayTaus() method can be executed just before the decayTaus() method.

 After executing decayTaus(), the following procedure takes place:
 - The HepMC event record is traversed and a list of stable taus in the event is created.
 - the taus from the list are paired with other decay products (e.g. tau neutrino or second tau). If the pair consists of two taus, the second tau is removed from the previous list.
 - TauolaParticlePairs are then created from these pairings.
 - For each pair, the spin density matrix is calculated using information about production process.
 - The decayTauPairs() method is called for each pair. Within this method:
    - For each tau in the pair decay() is called.
       - the decay method in TauolaParticle is responsible for adding itself
       (the tau) to the DecayList in the first positition. It then calls
       decay() in f_Decay which in turn calls the dekay_() routine of TAUOLA.
       - dekay_() in TAUOLA generates a sets of daughters particles with 
       momentum as though the tau has decayed in it's rest frame.
    - The dekay_() also provides a polarimetric vector, which is used in combination with spin density matrix to calculate the spin weight. It is used to determine whether the decay is accepted or not.
    - If rejected, the list of decay products is cleared and the pair is decayed anew. This way unweighting of spin effects is performed.
    - Once accepted, for each tau in pair the routine addDecayToEventRecord() is executed, which in turn calls TAUOLA dekay_() with option set to write to event record.
       - For each daughter TAUOLA calls filhep_() in the file f_FilHep.c.
       - filhep_() adds a new TauolaHepMCParticle to DecayList with all necessary information taken from TAUOLA.
       - The DecayList data structure translates the parent index given by TAUOLA to a pointer to the TauolaParticle(TauolaHepMCParticle) object.
       - The parents are set via the TauolaParticle methods (setMother, etc.) By setting the mothers it is automatically assigned a barcode and added to the HepMC event.
       - The particle is boosted by the tau's momentum.
       - The position of the vertex of the particle is modified accordingly to tau lifetime.
 - Control is then returned to TauolaHepMCEvent which proceeds onto the next pair.
 - When all pairs are decayed, the TauolaHepMCEvent converts the HepMC::GenEvent to the units selected by user (GeV/MeV mm/cm) and finalizes execution. The loop in main program proceeds to the next event.

 @section event_rec Notes About Event Record
 This section in future will  describe examples of events, particularly unsual ones,
 which TAUOLA Interface  will nonetheless need to be able to handle, but which were not discussed at the time
of writing documentation. At present this point is basically empty, except one example. Such type of events is already discussed in 
the documentation.
 - <a href="../pythia_event.pdf">example of a pythia event</a> with 
 non-conservation of momentum and tau->tau type vertices.

 @section to_do Things to do

See software documentation in pdf form. 


 <hr>
Last update Feb 24. 
Expect some information on future bug fixing etc. to be added here.
*/
