#include "TauolaHepMCEvent.h"
#include "Log.h"

using namespace std;

TauolaHepMCEvent::TauolaHepMCEvent(HepMC::GenEvent * event){
  m_event=event;
  momentum="GEV";
  length="MM";
  if(m_event->momentum_unit()!=HepMC::Units::GEV) momentum="MEV";
  if(m_event->length_unit()!=HepMC::Units::MM) length="CM";
  if(m_event->momentum_unit()!=HepMC::Units::GEV ||
     m_event->length_unit()!=HepMC::Units::MM)
     m_event->use_units(HepMC::Units::GEV,HepMC::Units::MM);
}

TauolaHepMCEvent::~TauolaHepMCEvent(){

  while(m_tau_list.size()!=0){
    TauolaParticle * temp = m_tau_list.back();
    m_tau_list.pop_back();
    delete temp;
  }

}

HepMC::GenEvent * TauolaHepMCEvent::getEvent(){
  return m_event;
}

std::vector<TauolaParticle*> TauolaHepMCEvent::findParticles(int pdg_id){
  
  if(m_tau_list.size()==0){

    HepMC::GenEvent::particle_const_iterator part_itr = m_event->particles_begin();
    //loop over all particle in the event looking for taus (or other)
    for( ; part_itr!=m_event->particles_end(); part_itr++){
      if(fabs((*part_itr)->pdg_id())==pdg_id)
	m_tau_list.push_back(new TauolaHepMCParticle(*part_itr));
    }
  }
  return m_tau_list;
}

std::vector<TauolaParticle*> TauolaHepMCEvent::findStableParticles(int pdg_id){

  /**  HepMC::GenEvent::particle_const_iterator part_itr = m_event->particles_begin();
  //loop over all particle in the event looking for taus (or other)
  for( ; part_itr!=m_event->particles_end(); part_itr++){
    if(fabs((*part_itr)->pdg_id())==pdg_id){
      if((*part_itr)->end_vertex()){
        cout << "WARNING: Particle with pdg code " << (*part_itr)->pdg_id()
             << " has end vertex" <<endl;
      }
      else
        list.push_back(new TauolaHepMCParticle(*part_itr));
    }
    }**/

  std::vector<TauolaParticle*> tau_list = findParticles(pdg_id);
  std::vector<TauolaParticle*> stable_tau_list;

  for(int i=0; i<(int) tau_list.size(); i++){
    
    if(!tau_list.at(i)->hasDaughters())
      stable_tau_list.push_back(tau_list.at(i)); 
    else
    {
	std::vector<TauolaParticle*> t = tau_list.at(i)->getDaughters();
	//Ignore taus that we won't be decaying anyway
	if(t.size()==1) continue;
	if(t.size()==2 && abs(t[0]->getPdgID())==15 || abs(t[1]->getPdgID())==15) continue;
	Log::Warning()<<"Particle with pdg code "<<tau_list.at(i)->getPdgID()
	              <<" already has daughters" <<endl;
    }
  }

  return stable_tau_list;

}

void TauolaHepMCEvent::eventEndgame()
{
	//Set output units for the event
	string m("GEV"),l("MM");
	switch(Tauola::momentumUnit)
	{
		case Tauola::GEV:
			m="GEV";
			break;
		case Tauola::MEV:
			m="MEV";
			break;
		default:
			m=momentum;
	}
	switch(Tauola::lengthUnit)
	{
		case Tauola::MM:
			l="MM";
			break;
		case Tauola::CM:
			l="CM";
			break;
		default:
			l=length;
	}
	m_event->use_units(m,l);
}
