#include <fstream>
#include <cstring>
#include <vector>
#include "Log.h"
#include "Tauola.h"
#include "TauolaEvent.h"

int Tauola::m_pdg_id = 15;
int Tauola::m_firstDecayMode = 0; 
int Tauola::m_secondDecayMode = 0;
bool Tauola::m_rad=true;
double Tauola::m_rad_cut_off=0.001;
double Tauola::m_iniphy=0.1;
double Tauola::m_higgs_scalar_pseudoscalar_mix=M_PI/4;
int Tauola::m_higgs_scalar_pseudoscalar_pdg=35;
int Tauola::helPlus=0;
int Tauola::helMinus=0;
double Tauola::wtEW=0.0;
double Tauola::wtEW0=0.0;
double Tauola::table11A[NS1][NCOS][4][4]={{{{0.0}}}};
double Tauola::table1A [NS1][NCOS][4][4]={{{{0.0}}}};
double Tauola::table2A [NS1][NCOS][4][4]={{{{0.0}}}};
double Tauola::wtable11A[NS1][NCOS]={{0.0}};
double Tauola::wtable1A [NS1][NCOS]={{0.0}};
double Tauola::wtable2A [NS1][NCOS]={{0.0}};
double Tauola::w0table11A[NS1][NCOS]={{0.0}};
double Tauola::w0table1A [NS1][NCOS]={{0.0}};
double Tauola::w0table2A [NS1][NCOS]={{0.0}};

double Tauola::table11B[NS2][NCOS][4][4]={{{{0.0}}}};
double Tauola::table1B [NS2][NCOS][4][4]={{{{0.0}}}};
double Tauola::table2B [NS2][NCOS][4][4]={{{{0.0}}}};
double Tauola::wtable11B[NS2][NCOS]={{0.0}};
double Tauola::wtable1B [NS2][NCOS]={{0.0}};
double Tauola::wtable2B [NS2][NCOS]={{0.0}};
double Tauola::w0table11B[NS2][NCOS]={{0.0}};
double Tauola::w0table1B [NS2][NCOS]={{0.0}};
double Tauola::w0table2B [NS2][NCOS]={{0.0}};

double Tauola::table11C[NS3][NCOS][4][4]={{{{0.0}}}};
double Tauola::table1C [NS3][NCOS][4][4]={{{{0.0}}}};
double Tauola::table2C [NS3][NCOS][4][4]={{{{0.0}}}};
double Tauola::wtable11C[NS3][NCOS]={{0.0}};
double Tauola::wtable1C [NS3][NCOS]={{0.0}};
double Tauola::wtable2C [NS3][NCOS]={{0.0}};
double Tauola::w0table11C[NS3][NCOS]={{0.0}};
double Tauola::w0table1C [NS3][NCOS]={{0.0}};
double Tauola::w0table2C [NS3][NCOS]={{0.0}};

double Tauola::sminA=0;
double Tauola::smaxA=0;

double Tauola::sminB=0;
double Tauola::smaxB=0;

double Tauola::sminC=0;
double Tauola::smaxC=0;

int    Tauola::ion[3]={0};
double Tauola::tau_lifetime=.08711;
Tauola::Particles Tauola::spin_correlation;

Tauola::MomentumUnits Tauola::momentumUnit=Tauola::DEF_MOMENTUM;
Tauola::LengthUnits   Tauola::lengthUnit=Tauola::DEF_LENGTH;

int     Tauola::m_gunMode=0;
double Tauola::m_gun_pol[3]={0};
void (*Tauola::m_boost)(TauolaParticle*,TauolaParticle*)=NULL;

int     Tauola::buf_incoming_pdg_id=0,  Tauola::buf_outgoing_pdg_id=0;
double  Tauola::buf_invariant_mass_squared=-1., Tauola::buf_cosTheta=0.;
double  Tauola::buf_R[4][4] = {{0.0}}; //density matrix

double (*Tauola::randomDouble)() = Tauola::defaultRandomGenerator;
void   (*Tauola::redefineTauPlusProperties)(TauolaParticle *) = defaultRedPlus;
void   (*Tauola::redefineTauMinusProperties)(TauolaParticle *) = defaultRedMinus;

/**************************************************************/
double Tauola::defaultRandomGenerator()
{
	return rand()*1./RAND_MAX;
}

void Tauola::setRandomGenerator(double (*gen)())
{
	if(gen==NULL) randomDouble=defaultRandomGenerator;
	else randomDouble=gen;
}

void Tauola::defaultRedPlus(TauolaParticle *tau)  {}
void Tauola::defaultRedMinus(TauolaParticle *tau) {}

void Tauola::setRedefineTauMinus( void (*fun)(TauolaParticle *) )
{
	redefineTauMinusProperties=fun;
}

void Tauola::setRedefineTauPlus ( void (*fun)(TauolaParticle *) )
{
	redefineTauPlusProperties=fun;
}

void Tauola::getBornKinematics(int *incoming_pdg_id, int *outgoing_pdg_id, double *invariant_mass_squared,double *cosTheta){
  *incoming_pdg_id=buf_incoming_pdg_id;
  *outgoing_pdg_id=buf_outgoing_pdg_id;
  *invariant_mass_squared=buf_invariant_mass_squared;
  *cosTheta=buf_cosTheta;
  //  m_R[0][0] to be added in next step;
}

void   Tauola::setUnits(MomentumUnits m,LengthUnits l)
{
	Tauola::momentumUnit=m;
	Tauola::lengthUnit=l;

}

void   Tauola::setTauLifetime(double t)
{
	tau_lifetime=t;
}

void Tauola::initialise(){
  spin_correlation.setAll(true);
  printf("\n");
  printf(" *************************************\n");
  printf(" *     TAUOLA C++ Interface v1.0.2   *\n");
  printf(" *-----------------------------------*\n");
  printf(" *                                   *\n");
  printf(" *   (c) Nadia    Davidson,   (1,2)  *\n");
  printf(" *       Gizo     Nanava,     (3)    *\n");
  printf(" *       Tomasz   Przedzinski,(4)    *\n");
  printf(" *       Elzbieta Richter-Was,(2,4)  *\n");
  printf(" *       Zbigniew Was         (2,5)  *\n");
  printf(" *                                   *\n");
  printf(" *  1) Unimelb, Melbourne, Australia *\n");
  printf(" *  2)     INP, Krakow, Poland       *\n");
  printf(" *  3) University Bonn, Germany      *\n");
  printf(" *  4)      UJ, Krakow, Poland       *\n");
  printf(" *  5)    CERN, Geneva, Switzerland  *\n");
  printf(" *************************************\n");

  f_interface_tauolaInitialise(m_pdg_id,m_firstDecayMode,
			       m_secondDecayMode,m_rad, 
			       m_rad_cut_off, m_iniphy);

  cout<<"Reading SANC input files."<<endl;
  ifstream f("table1-1.txt");
  if(f.is_open()){
    string buf;
    int dbuf1,dbuf2,dbuf3,dbufcos;
    cout<<"Reading file 'table1-1.txt'..."<<endl;
    f>>buf>>dbuf1>>dbuf2>>dbuf3>>dbufcos;
    if(dbuf1!=NS1 || dbuf2!=NS2 || dbuf3!=NS3 || dbufcos!=NCOS)  {
      cout<<"mismatched NS1=   "<<dbuf1<<" <--> "<<NS1<<endl; 
      cout<<"           NS2=   "<<dbuf2<<" <--> "<<NS2<<endl; 
      cout<<"           NS3=   "<<dbuf3<<" <--> "<<NS3<<endl; 
      cout<<"           NCOS=  "<<dbufcos<<" <--> "<<NCOS<<endl; 
      return; 
    }
    double buf1,buf2,buf3,buf4,buf5,buf6;
    f>>buf>>buf1>>buf2>>buf3>>buf4>>buf5>>buf6;
    if(sminA==0.0)
    {
      sminA=buf1;
      smaxA=buf2;
      sminB=buf3;
      smaxB=buf4;
      sminC=buf5;
      smaxC=buf6;
    }
    if(buf1!=sminA || buf2!=smaxA || buf3!=sminB || buf4!=smaxB || buf5!=sminC || buf6!=smaxC) {
      cout<<"mismatched sminA=   "<<buf1<<" <--> "<<sminA<<endl; 
      cout<<"           smaxA=   "<<buf2<<" <--> "<<smaxA<<endl; 
      cout<<"           sminB=   "<<buf3<<" <--> "<<sminB<<endl; 
      cout<<"           smaxB=   "<<buf4<<" <--> "<<smaxB<<endl; 
      cout<<"           sminC=   "<<buf5<<" <--> "<<sminC<<endl; 
      cout<<"           smaxC=   "<<buf6<<" <--> "<<smaxC<<endl; 
      return; 
    }
    while(!f.eof())
    {
      char head[255];
      f.getline(head,255);
      if(strcmp(head,"BeginRange1")==0) break;
      cout<<head<<endl;
    }
    for (int i=0;i<NS1;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table1A[i][j][k][l];
	f>>wtable1A[i][j];
	f>>w0table1A[i][j];
      }
    while(!f.eof())
    {
      f>>buf;
      if(strcmp(buf.c_str(),"BeginRange2")==0) break;
    }
    for (int i=0;i<NS2;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table1B[i][j][k][l];
	f>>wtable1B[i][j];
	f>>w0table1B[i][j];
      }

    while(!f.eof())
    {
      f>>buf;
      if(strcmp(buf.c_str(),"BeginRange3")==0) break;
    }
    for (int i=0;i<NS3;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table1C[i][j][k][l];
	f>>wtable1C[i][j];
	f>>w0table1C[i][j];
      }
    f>>buf;
    if(buf.size()==0 || strcmp(buf.c_str(),"End")!=0)
    {
      cout<<"...incorrect file version or file incomplete/damaged!"<<endl;
      table1A[0][0][0][0]=table1B[0][0][0][0]=table1C[0][0][0][0]=0.0;
    }
  }
  else cout<<"File 'table1-1.txt'  missing... skipped."<<endl;
  f.close();

  f.open("table2-2.txt");
  if(f.is_open()){
    string buf;
    int dbuf1,dbuf2,dbuf3,dbufcos;
    cout<<"Reading file 'table2-2.txt'..."<<endl;
    f>>buf>>dbuf1>>dbuf2>>dbuf3>>dbufcos;
    if(dbuf1!=NS1 || dbuf2!=NS2 || dbuf3!=NS3 || dbufcos!=NCOS)  {
      cout<<"mismatched NS1=   "<<dbuf1<<" <--> "<<NS1<<endl; 
      cout<<"           NS2=   "<<dbuf2<<" <--> "<<NS2<<endl; 
      cout<<"           NS3=   "<<dbuf3<<" <--> "<<NS3<<endl; 
      cout<<"           NCOS=  "<<dbufcos<<" <--> "<<NCOS<<endl; 
      return; 
    }
    double buf1,buf2,buf3,buf4,buf5,buf6;
    f>>buf>>buf1>>buf2>>buf3>>buf4>>buf5>>buf6;
    if(sminA==0.0)
    {
      sminA=buf1;
      smaxA=buf2;
      sminB=buf3;
      smaxB=buf4;
      sminC=buf5;
      smaxC=buf6;
    }
    if(buf1!=sminA || buf2!=smaxA || buf3!=sminB || buf4!=smaxB || buf5!=sminC || buf6!=smaxC) {
      cout<<"mismatched sminA=   "<<buf1<<" <--> "<<sminA<<endl; 
      cout<<"           smaxA=   "<<buf2<<" <--> "<<smaxA<<endl; 
      cout<<"           sminB=   "<<buf3<<" <--> "<<sminB<<endl; 
      cout<<"           smaxB=   "<<buf4<<" <--> "<<smaxB<<endl; 
      cout<<"           sminC=   "<<buf5<<" <--> "<<sminC<<endl; 
      cout<<"           smaxC=   "<<buf6<<" <--> "<<smaxC<<endl; 
      return; 
    }
    while(!f.eof())
    {
      char head[255];
      f.getline(head,255);
      if(strcmp(head,"BeginRange1")==0) break;
      cout<<head<<endl;
    }
    for (int i=0;i<NS1;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table2A[i][j][k][l];
	f>>wtable2A[i][j];
	f>>w0table2A[i][j];
      }
    while(!f.eof())
    {
      f>>buf;
      if(strcmp(buf.c_str(),"BeginRange2")==0) break;
    }
    for (int i=0;i<NS2;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table2B[i][j][k][l];
	f>>wtable2B[i][j];
	f>>w0table2B[i][j];
      }

    while(!f.eof())
    {
      f>>buf;
      if(strcmp(buf.c_str(),"BeginRange3")==0) break;
    }
    for (int i=0;i<NS3;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table2C[i][j][k][l];
	f>>wtable2C[i][j];
	f>>w0table2C[i][j];
      }
    f>>buf;
    if(buf.size()==0 || strcmp(buf.c_str(),"End")!=0)
    {
      cout<<"...incorrect file version or file incomplete/damaged!"<<endl;
      table2A[0][0][0][0]=table2B[0][0][0][0]=table2C[0][0][0][0]=0.0;
    }
  }
  else cout<<"File 'table2-2.txt'  missing... skipped."<<endl;
  f.close();

  f.open("table11-11.txt");
  if(f.is_open()){
    string buf;
    int dbuf1,dbuf2,dbuf3,dbufcos;
    cout<<"Reading file 'table11-11.txt'..."<<endl;
    f>>buf>>dbuf1>>dbuf2>>dbuf3>>dbufcos;
    if(dbuf1!=NS1 || dbuf2!=NS2 || dbuf3!=NS3 || dbufcos!=NCOS)  {
      cout<<"mismatched NS1=   "<<dbuf1<<" <--> "<<NS1<<endl; 
      cout<<"           NS2=   "<<dbuf2<<" <--> "<<NS2<<endl; 
      cout<<"           NS3=   "<<dbuf3<<" <--> "<<NS3<<endl; 
      cout<<"           NCOS=  "<<dbufcos<<" <--> "<<NCOS<<endl; 
      return; 
    }
    double buf1,buf2,buf3,buf4,buf5,buf6;
    f>>buf>>buf1>>buf2>>buf3>>buf4>>buf5>>buf6;
    if(sminA==0.0)
    {
      sminA=buf1;
      smaxA=buf2;
      sminB=buf3;
      smaxB=buf4;
      sminC=buf5;
      smaxC=buf6;
    }
    if(buf1!=sminA || buf2!=smaxA || buf3!=sminB || buf4!=smaxB || buf5!=sminC || buf6!=smaxC) {
      cout<<"mismatched sminA=   "<<buf1<<" <--> "<<sminA<<endl; 
      cout<<"           smaxA=   "<<buf2<<" <--> "<<smaxA<<endl; 
      cout<<"           sminB=   "<<buf3<<" <--> "<<sminB<<endl; 
      cout<<"           smaxB=   "<<buf4<<" <--> "<<smaxB<<endl; 
      cout<<"           sminC=   "<<buf5<<" <--> "<<sminC<<endl; 
      cout<<"           smaxC=   "<<buf6<<" <--> "<<smaxC<<endl; 
      return; 
    }
    while(!f.eof())
    {
      char head[255];
      f.getline(head,255);
      if(strcmp(head,"BeginRange1")==0) break;
      cout<<head<<endl;
    }
    for (int i=0;i<NS1;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table11A[i][j][k][l];
	f>>wtable11A[i][j];
	f>>w0table11A[i][j];
      }
    while(!f.eof())
    {
      f>>buf;
      if(strcmp(buf.c_str(),"BeginRange2")==0) break;
    }
    for (int i=0;i<NS2;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table11B[i][j][k][l];
	f>>wtable11B[i][j];
	f>>w0table11B[i][j];
      }

    while(!f.eof())
    {
      f>>buf;
      if(strcmp(buf.c_str(),"BeginRange3")==0) break;
    }
    for (int i=0;i<NS3;i++)
      for (int j=0;j<NCOS;j++){
        for (int k=0;k<4;k++)
          for (int l=0;l<4;l++)
            f>>table11C[i][j][k][l];
	f>>wtable11C[i][j];
	f>>w0table11C[i][j];
      }
    f>>buf;
    if(buf.size()==0 || strcmp(buf.c_str(),"End")!=0)
    {
      cout<<"...incorrect file version or file incomplete/damaged!"<<endl;
      table11A[0][0][0][0]=table11B[0][0][0][0]=table11C[0][0][0][0]=0.0;
    }
  }
  else cout<<"File 'table11-11.txt' missing... skipped."<<endl;
  f.close();
  cout<<endl;
}

void Tauola::decayOne(TauolaParticle *tau, bool undecay, double polx, double poly, double polz)
{
	if(!tau) return;
	//Let the interface know that we work in the tauola gun mode

	if(polx*polx+poly*poly+polz*polz>1)
	{
		Log::Warning()<<"decayOne(): ignoring wrong polarization vector: "<<polx<<" "<<poly<<" "<<polz<<endl;
		polx=poly=polz=0;
	}
	m_gunMode=1;
	m_gun_pol[0]=polx;
	m_gun_pol[1]=poly;
	m_gun_pol[2]=polz;

	if(m_boost) m_gunMode|=4;

	//Undecay if needed
	if(tau->hasDaughters())
	{
		if(undecay) tau->undecay();
		else
		{
			m_gunMode=0;
			return;
		}
	}

	//Decay single tau
	std::vector<TauolaParticle *> list;
	list.push_back(tau);
	TauolaParticlePair t_pair(list);
	t_pair.decayTauPair();
	t_pair.checkMomentumConservation();
	m_gunMode=0;
}

int Tauola::getGunMode() { return m_gunMode; }

void Tauola::setBoostRoutine(void (*boost)(TauolaParticle *, TauolaParticle *))
{
	m_boost=boost;
}

void Tauola::setDecayingParticle(int pdg_id){
  m_pdg_id=pdg_id; 
}

int Tauola::getDecayingParticle(){
  return abs(m_pdg_id);
}

void Tauola::setSameParticleDecayMode(int firstDecayMode){
  m_firstDecayMode=firstDecayMode;
}

void Tauola::setOppositeParticleDecayMode(int secondDecayMode){
  m_secondDecayMode=secondDecayMode;
}

void Tauola::setRadiation(bool rad){
  m_rad=rad;
}

void Tauola::setRadiationCutOff(double rad_cut_off){
  m_rad_cut_off=rad_cut_off;
}


void Tauola::setInitialisePhy(double iniphy){
  m_iniphy=iniphy;
}

void Tauola::setTauBr(int i, double value)
{
	if(taubra_.nchan==0)
		Log::Warning()<<"setTauBr(): run Tauola::initialize() first."<<endl;
	else if(i<1 || i>taubra_.nchan || value<0.)
		Log::Warning()<<"setTauBr(): Invalid input. Value must be >= 0 and 0 < i <= "<<taubra_.nchan<<endl;
	else taubra_.gamprt[i-1]=(float)value;
}

void Tauola::setTaukle(double bra1,double brk0, double brk0b, double brks)
{
	if(bra1<0 || bra1>1 || brk0<0 ||brk0>1 || brk0b<0 || brk0b>1 || brks<0 ||brks>1)
	{
		Log::Warning()<<"setTaukle(): variables must be in range [0,1]. Ignored."<<endl;
		return;
	}
	taukle_.bra1 =(float)bra1;
	taukle_.brk0 =(float)brk0;
	taukle_.brk0b=(float)brk0b;
	taukle_.brks =(float)brks;
}

double Tauola::getTauMass(){
  return f_getTauMass();
}

double Tauola::getHiggsScalarPseudoscalarMixingAngle(){
  return m_higgs_scalar_pseudoscalar_mix;
}

int Tauola::getHiggsScalarPseudoscalarPDG(){
  return m_higgs_scalar_pseudoscalar_pdg;
}

/** set the mixing angle. coupling: tau~(cos(phi)+isin(phi)gamma5)tau */
void Tauola::setHiggsScalarPseudoscalarMixingAngle(double angle){
  m_higgs_scalar_pseudoscalar_mix=angle;
} 

/** set the pdg code of the higgs particle which tauola should 
    treat as a scalar-pseudoscalar mix  */
void Tauola::setHiggsScalarPseudoscalarPDG(int pdg_code){
  m_higgs_scalar_pseudoscalar_pdg=pdg_code;
} 

int Tauola::getHelPlus(){
  return helPlus;
}
int Tauola::getHelMinus(){
  return helMinus;
}
double Tauola::getEWwt(){
  return wtEW;
}
double Tauola::getEWwt0(){
  return wtEW0;
}
void Tauola::setEWwt(double wt, double wt0)
{ 
  wtEW=wt;
  wtEW0=wt0;
}
void Tauola::setHelicities(int Minus, int Plus)
{ 
  helMinus=Minus;
  helPlus=Plus;
}
void Tauola::setEtaK0sPi(int eta, int k, int pi)
{  
  ion[0]=pi;
  ion[1]=k;
  ion[2]=eta;
}
