#include "Plots.h"
#include <iostream>
#include <fstream>
#include <math.h>
using namespace std;

int    Plots::inc_P=1;
double Plots::cosTheta=-0.2;
int    Plots::IT=1000;
int    Plots::SANCplot=0;
bool   Plots::SANCexit=false,Plots::SANCdone=false;

void Plots::SANC(TauolaParticlePair t_pair)
{
	if(SANCdone) return;
	if(SANCplot&1) SANCtest1(t_pair);
	if(SANCplot&2) SANCtest2(t_pair);
	if(SANCplot&4) SANCtest3(t_pair);
	if(SANCplot&8) SANCtest4(t_pair);
	if(SANCexit) { cout<<"Exiting after SANC plots!"<<endl; exit(0); }
	SANCdone=true;
}

void Plots::SANCtest1(TauolaParticlePair t_pair)
{
	cout<<"SANC plot 1 (short)..."<<endl;
	double smin=log(6.*6.)+0.0001;
	double smax=log(17000.*17000.);
	double step=(smax-smin)/(IT-1);

	ofstream f1,f2,f3;
	f1.open("f-sanc.txt");
	f2.open("f-born.txt");
	f3.open("f-plzap0.txt");
	for(int i=0;i<IT;i++)
	{
		double s=exp(smin+i*step);
		t_pair.recalculateRij(inc_P,15,s,cosTheta);
		f1<<sqrt(s)<<" "<<t_pair.m_R[0][3]<<endl;
		t_pair.recalculateRij(11,15,s,cosTheta);
		f2<<sqrt(s)<<" "<<t_pair.m_R[0][3]<<endl;
		int out_P=15;
		double pz = 1-plzap0_(&inc_P,&out_P,&s, &cosTheta);
		t_pair.m_R[0][3]=2*pz-1;
		f3<<sqrt(s)<<" "<<t_pair.m_R[0][3]<<endl;
	}
	f1.close();
	f2.close();
	f3.close();
}

void Plots::SANCtest2(TauolaParticlePair t_pair)
{
	cout<<"SANC plot 2 (short)..."<<endl;
	double smin=log(6.*6.)+0.0001;
	double smax=log(17000.*17000.);
	double step=(smax-smin)/(IT-1);

	ofstream f1,f2,f3;
	f1.open("f-w.txt");
	f2.open("f-w0.txt");
	f3.open("f-ww0.txt");
	for(int i=0;i<IT;i++)
	{
		double s=exp(smin+i*step);
		t_pair.recalculateRij(inc_P,15,s,cosTheta);
		f1<<sqrt(s)<<" "<<Tauola::getEWwt()<<endl;
		f2<<sqrt(s)<<" "<<Tauola::getEWwt0()<<endl;
		f3<<sqrt(s)<<" "<<Tauola::getEWwt()/Tauola::getEWwt0()<<endl;
	}
	f1.close();
	f2.close();
	f3.close();
}

void Plots::SANCtest3(TauolaParticlePair t_pair)
{
	cout<<"SANC plot 3 (long)..."<<endl;
	double smin=log(6.*6.)+0.0001;
	double smax=log(17000.*17000.);
	double step=(smax-smin)/(IT-1);

	ofstream f1;
	f1.open("f-err.txt");
	double costheta=-1.;
	for(int i=0;i<IT;i++)
	{
		double buf=0.,err=0.;
		for(int j=0;j<IT;j++)
		{
			double s=exp(smin+j*step);
			t_pair.recalculateRij(inc_P,15,s,costheta);
			buf = t_pair.m_R[0][3];
			t_pair.recalculateRij(11,15,s,costheta);
			err += (buf-t_pair.m_R[0][3])*(buf-t_pair.m_R[0][3]);
		}
		f1<<costheta<<" "<<err/IT<<endl;
		err=0.;
		costheta+=2./IT;
	}
	f1.close();
}

void Plots::SANCtest4(TauolaParticlePair t_pair)
{
	cout<<"SANC plot 4 (medium)..."<<endl;
	double smin=log(6.*6.)+0.0001;
	double smax=log(17000.*17000.);
	double step=(smax-smin)/(IT-1);

	ofstream f1;
	f1.open("f-cross.txt");
	for(int i=0;i<IT;i++)
	{
		double s=exp(smin+i*step);
		double buf=0.,costheta=-1.;
		for(int j=0;j<IT;j++)
		{
			t_pair.recalculateRij(inc_P,15,s,costheta);
			buf+=Tauola::getEWwt()/Tauola::getEWwt0();
			costheta+=2./IT;
		}
		f1<<sqrt(s)<<" "<<buf/IT<<endl;
	}
	f1.close();
}

void Plots::addSancPlot(int plot)
{
	if(plot==1) SANCplot|=1;
	else if(plot==2) SANCplot|=2;
	else if(plot==3) SANCplot|=4;
	else if(plot==4) SANCplot|=8;
}

void Plots::exitAfterSancPlots(bool e) { SANCexit=true; }
void Plots::setSancVariables(int inc, double cos) { inc_P=inc; cosTheta=cos; }
