#ifndef __PLOTS_CLASS_HEADER__
#define __PLOTS_CLASS_HEADER__

/**
 * This file contains routines for debug plot generation.
 * They are called by friend class TauolaParticlePair.
 *
 * @author Tomasz Przedzinski
 * @date 20 December 2009
 */

#include "TauolaParticlePair.h"

class Plots
{
public:
	/**   SANC tables plots
	Writes the data for plots for the 1-1 table or 2-2 table
	using 11-11 table as the born-level table, so before
	running, the 11-11 table must be substituted with born-level
	table for either 1-1 or 2-2.
	The output files are adopted for the draw.C root script. */
	static void SANC(TauolaParticlePair t_pair);

	/** Adds one of the 4 plots to the list of things to be ploted. */
	static void addSancPlot(int plot);

	/** Sets cosTheta (for plots 1 and 2)
            and incoming particle pdgid (for all plots). */
	static void setSancVariables(int inc, double cos);

	/** Quit after plots are finished */
	static void exitAfterSancPlots(bool e);
private:
	/** SANC test - three functions - table, born level and plzap0 */
	static void SANCtest1(TauolaParticlePair t_pair);

	/** Weights - three functions - w, w0 and w/w0 */
	static void SANCtest2(TauolaParticlePair t_pair);

	/** Error check - one function - table vs born for all cosTheta */
	static void SANCtest3(TauolaParticlePair t_pair);

	/** cross-section - one function - w/w0 */
	static void SANCtest4(TauolaParticlePair t_pair);
private:
	static int inc_P;
	static double cosTheta;
	static int IT;
	static int  SANCplot;
	static bool SANCexit,SANCdone;
};

#endif
