************************************************************************
* File (nc_ff_1313_2020.F) created on Thu Dec  4 16:16:19 MSK 2008.
************************************************************************
* This is the FORTRAN module (nc_ff_1313_2020) to calculate 1-loop EW
* form factors for the up + up -> ta + ta process.
*
* It is produced by s2n package of SANC (v1.10) Project.
* Copyright (C), SANC Project Team, 2002-2008.
*
* http://sanc.jinr.ru/
* http://pcphsanc.cern.ch/
* E-mail: <sanc@jinr.ru>
************************************************************************
      subroutine nc_ff_1313_2020 (qs,ts,us)
      implicit none!
#include "looptools.h"
#include "s2n_declare.h"

      complex*16 ff_qed_ll,ff_qed_lq,ff_qed_ql,ff_qed_qq,ff_qed_ld
      complex*16 ff_qed_qd,ff_ew_ll,ff_ew_ld,ff_ew_lq,ff_ew_ql,ff_ew_qq
      complex*16 ff_ew_qd,ff_qed_gg
      real*8 isr,ifi,fsr

      real*8 det3itataqs
      real*8 a0fta,a0fup,a0fw,a0fz,a0fh
      real*8 lnlaupm,lnlatam
      complex*16 b0ptazta,b0ptahta,b0ptacw
      complex*16 b0fqstata,b0ftazta,b0ftatac,b0ftstac,b0fustac,b0fqszc,
     & b0fqscc,b0ftawc,b0ftahta,b0fqsww,b0fqszh,b0fqszz
      complex*16 c0ctatsczta,c0ctausczta,c0upupqszupc,c0upupqscupc,c0ta
     & taqsztac,c0tataqsctac,c0irupupqs,c0iruptats,c0iruptaus,c0irtataqs
     & ,c0irtaupts,c0irtaupus,c0tataqswcw,c0tataqsztah,c0tataqstazta,c0t
     & ataqstahta,c0tataqscwc,c0tataqsztaz,c0ccqszcz,c0ccqswcw,c0ccqscwc
     & ,c0ccqsczc
      complex*16 b0d1tataz
      complex*16 b0dwtacw
      complex*16 d0cctataqstszczta,d0cctataqsuszczta,d0cctataqsuswcwc
      complex*16 jaaqstsupta,jaaqsusupta,javqstsuptaz,javqsusuptaz
      real*8 sdet3ictats,sdet3ictaus,sdet4itatsus,sdet3itataqs
      real*8 sdet3ctats,sdet3ctaus
      real*8 pxx2zqsc
      complex*16 propzqs,propizqs,prop1zqs

      common/unibos_bos/za1bos,zmzzzbos,zmwzwbos,zmhzhbos,deltarhobos
      common/unibos_fer/za1fer,zz1fer,zh1fer,zw1fer,zmsqrfer,
     & zmzzzfer,zmwzwfer,zmhzhfer,deltarhofer,tadfer
      common/unipro_fer/caldzfer,caldwfer,pizgfer,piggfer

      if (iqed.eq.1) then
         isr = 1d0
         ifi = 1d0
         fsr = 1d0
      elseif(iqed.eq.2) then
         isr = 1d0
         ifi = 0d0
         fsr = 0d0
      elseif(iqed.eq.3) then
         isr = 0d0
         ifi = 1d0
         fsr = 0d0
      elseif(iqed.eq.4) then
         isr = 0d0
         ifi = 0d0
         fsr = 1d0
      elseif(iqed.eq.5) then
         isr = 0d0
         ifi = 1d0
         fsr = 1d0
      else
         isr = 0d0
         ifi = 0d0
         fsr = 0d0
      endif

      cmz2 = mz2

      prop1zqs = (cmz2+qs)
      propizqs = (rzm2+qs)
      propzqs = 1d0/propizqs
      det3itataqs = 1d0/(-1d0/4d0*((-rtam2)**2+(-rtam2)**2+(qs)**2
     & -2d0*(-rtam2)*(-rtam2)-2d0*(-rtam2)*(qs)
     & -2d0*(-rtam2)*(qs)))
      a0fta = log(rtam2/thmu2) - 1d0
      a0fup = log(rupm2/thmu2) - 1d0
      a0fw = log(rwm2/thmu2) - 1d0
      a0fz = log(rzm2/thmu2) - 1d0
      a0fh = log(rhm2/thmu2) - 1d0
      lnlaupm = log(rupm2/tlmu2)
      lnlatam = log(rtam2/tlmu2)
      b0ptazta = b0p(-rtam2,zm2,tam2)
      b0ptahta = b0p(-rtam2,hm2,tam2)
      b0ptacw = b0p(-rtam2,cm2,wm2)
      b0fqstata = b0f(qs,thmu2,tam2,tam2)
      b0ftazta = b0f(-rtam2,thmu2,zm2,tam2)
      b0ftatac = b0f(-rtam2,thmu2,tam2,cm2)
      b0ftstac = b0f(ts,thmu2,tam2,cm2)
      b0fustac = b0f(us,thmu2,tam2,cm2)
      b0fqszc = b0f(qs,thmu2,zm2,cm2)
      b0fqscc = b0f(qs,thmu2,cm2,cm2)
      b0ftawc = b0f(-rtam2,thmu2,wm2,cm2)
      b0ftahta = b0f(-rtam2,thmu2,hm2,tam2)
      b0fqsww = b0f(qs,thmu2,wm2,wm2)
      b0fqszh = b0f(qs,thmu2,zm2,hm2)
      b0fqszz = b0f(qs,thmu2,zm2,zm2)
      c0ctatsczta = -c0(0d0,rtam2,-ts,0d0,rzm2,rtam2)
      c0ctausczta = -c0(0d0,rtam2,-us,0d0,rzm2,rtam2)
      c0upupqszupc = -c0(rupm2,rupm2,-qs,rzm2,rupm2,0d0)
      c0upupqscupc = -c0(rupm2,rupm2,-qs,0d0,rupm2,0d0)
      c0tataqsztac = -c0(rtam2,rtam2,-qs,rzm2,rtam2,0d0)
      c0tataqsctac = -c0(rtam2,rtam2,-qs,0d0,rtam2,0d0)
      c0irupupqs = c0ir(tlmu2,upm2,upm2,qs)
      c0iruptats = c0ir(tlmu2,upm2,tam2,ts)
      c0iruptaus = c0ir(tlmu2,upm2,tam2,us)
      c0irtataqs = c0ir(tlmu2,tam2,tam2,qs)
      c0irtaupts = c0ir(tlmu2,tam2,upm2,ts)
      c0irtaupus = c0ir(tlmu2,tam2,upm2,us)
      c0tataqswcw = -c0(rtam2,rtam2,-qs,rwm2,0d0,rwm2)
      c0tataqsztah = -c0(rtam2,rtam2,-qs,rzm2,rtam2,rhm2)
      c0tataqstazta = -c0(rtam2,rtam2,-qs,rtam2,rzm2,rtam2)
      c0tataqstahta = -c0(rtam2,rtam2,-qs,rtam2,rhm2,rtam2)
      c0tataqscwc = -c0(rtam2,rtam2,-qs,0d0,rwm2,0d0)
      c0tataqsztaz = -c0(rtam2,rtam2,-qs,rzm2,rtam2,rzm2)
      c0ccqszcz = -c0(0d0,0d0,-qs,rzm2,0d0,rzm2)
      c0ccqswcw = -c0(0d0,0d0,-qs,rwm2,0d0,rwm2)
      c0ccqscwc = -c0(0d0,0d0,-qs,0d0,rwm2,0d0)
      c0ccqsczc = -c0(0d0,0d0,-qs,0d0,rzm2,0d0)
      b0d1tataz = b0d1(-rtam2,thmu2,tam2,zm2)
      b0dwtacw = b0dw(-rtam2,thmu2,cm2,wm2)
      d0cctataqstszczta =
     & d0(0d0,0d0,rtam2,rtam2,-qs,-ts,rzm2,0d0,rzm2,rtam2)
      d0cctataqsuszczta =
     & d0(0d0,0d0,rtam2,rtam2,-qs,-us,rzm2,0d0,rzm2,rtam2)
      d0cctataqsuswcwc =
     & d0(0d0,0d0,rtam2,rtam2,-qs,-us,rwm2,0d0,rwm2,0d0)
      jaaqstsupta = jaa(qs,ts,upm2,tam2)
      jaaqsusupta = jaa(qs,us,upm2,tam2)
      javqstsuptaz = jav(qs,ts,upm2,tam2,cmz2)
      javqsusuptaz = jav(qs,us,upm2,tam2,cmz2)
      sdet3ictats = 1d0/(ts+(mta)**2)
      sdet3ictaus = 1d0/(us+(mta)**2)
      sdet4itatsus = 1d0/(ts*us-mta**4)
      sdet3itataqs = 1d0/(qs+(mta+mta)**2)
      sdet3ctats = (ts+mta**2)
      sdet3ctaus = (us+mta**2)
      pxx2zqsc = (2*mz**2)+(qs)

      ff_qed_gg =
     & +stw**2*piggfer-za1fer

      ff_qed_ll =
     & +isr*(-stw**2*qup**2)
     & +fsr*(-stw**2*qta**2)
     & +det3itataqs*fsr*(2*stw**2*qta**2*qs*mta**2)
     & +det3itataqs*a0fta*fsr*(-2*stw**2*qta**2*qs*mta**2)
     & +det3itataqs*b0fqstata*fsr*(-2*stw**2*qta**2*qs*mta**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw
     & **2*qup*vpaup*qta*vpata*ts*mz**2*mta**2-4*stw**2*qup*vmaup*qta*vm
     & ata*ts*mz**2*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*vpata*ts*mta**2-4*stw**2*qup*vpaup*qta*vpata*mta**
     & 4-4*stw**2*qup*vmaup*qta*vmata*ts*mta**2-4*stw**2*qup*vmaup*qta*v
     & mata*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*vpata*ts*mta**2-4*stw**2*qup*vpaup*qta*vpata*mta**
     & 4-4*stw**2*qup*vmaup*qta*vmata*ts*mta**2-4*stw**2*qup*vmaup*qta*v
     & mata*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(8*stw**2*
     & qup*vpaup*qta*vpata*ts*mta**2+8*stw**2*qup*vpaup*qta*vpata*mta**4
     & +8*stw**2*qup*vmaup*qta*vmata*ts*mta**2+8*stw**2*qup*vmaup*qta*vm
     & ata*mta**4)
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw**2*qup*vpaup
     & *qta*vpata/qs*mz**2*mta**2-4*stw**2*qup*vmaup*qta*vmata/qs*mz**2*
     & mta**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(-4*stw
     & **2*qup*vpaup*qta*vmata*us*mz**2*mta**2-4*stw**2*qup*vmaup*qta*vp
     & ata*us*mz**2*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*vmata*us*mta**2-4*stw**2*qup*vpaup*qta*vmata*mta**
     & 4-4*stw**2*qup*vmaup*qta*vpata*us*mta**2-4*stw**2*qup*vmaup*qta*v
     & pata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*vmata*us*mta**2-4*stw**2*qup*vpaup*qta*vmata*mta**
     & 4-4*stw**2*qup*vmaup*qta*vpata*us*mta**2-4*stw**2*qup*vmaup*qta*v
     & pata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(8*stw**2*
     & qup*vpaup*qta*vmata*us*mta**2+8*stw**2*qup*vpaup*qta*vmata*mta**4
     & +8*stw**2*qup*vmaup*qta*vpata*us*mta**2+8*stw**2*qup*vmaup*qta*vp
     & ata*mta**4)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*ifi*(-4*stw**2*qup*vpaup
     & *qta*vmata/qs*mz**2*mta**2-4*stw**2*qup*vmaup*qta*vpata/qs*mz**2*
     & mta**2)
     & +sdet4itatsus**2*jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(8*sdet
     & 3ctats**3*stw**4*ctw**2*qup**2*qta**2*ts-8*sdet3ctats**3*stw**4*c
     & tw**2*qup**2*qta**2*us)
     & +sdet4itatsus**2*jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(-8*sde
     & t3ctaus**3*stw**4*ctw**2*qup**2*qta**2*ts+8*sdet3ctaus**3*stw**4*
     & ctw**2*qup**2*qta**2*us)
     & +sdet4itatsus**2*javqstsuptaz*dreal(propizqs)*ifi*(-2*sdet3ctats*
     & stw**2*qup*vpaup*qta*vpata*qs*ts**2+2*sdet3ctats*stw**2*qup*vpaup
     & *qta*vpata*qs*mta**4-2*sdet3ctats*stw**2*qup*vpaup*qta*vpata*ts**
     & 2*mz**2+2*sdet3ctats*stw**2*qup*vpaup*qta*vpata*mz**2*mta**4-2*sd
     & et3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts**2+2*sdet3ctats*stw**2*
     & qup*vmaup*qta*vmata*qs*mta**4-2*sdet3ctats*stw**2*qup*vmaup*qta*v
     & mata*ts**2*mz**2+2*sdet3ctats*stw**2*qup*vmaup*qta*vmata*mz**2*mt
     & a**4)
     & +sdet4itatsus**2*javqsusuptaz*dreal(propizqs)*ifi*(-2*sdet3ctaus*
     & stw**2*qup*vpaup*qta*vmata*qs*us**2+2*sdet3ctaus*stw**2*qup*vpaup
     & *qta*vmata*qs*mta**4-2*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*us**
     & 2*mz**2+2*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*mz**2*mta**4-2*sd
     & et3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us**2+2*sdet3ctaus*stw**2*
     & qup*vmaup*qta*vpata*qs*mta**4-2*sdet3ctaus*stw**2*qup*vmaup*qta*v
     & pata*us**2*mz**2+2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*mz**2*mt
     & a**4)
     & +sdet4itatsus**2*c0upupqszupc*dreal(propizqs)*ifi*(2*sdet3ctats*s
     & tw**2*qup*vpaup*qta*vpata*qs*ts*mta**2-2*sdet3ctats*stw**2*qup*vp
     & aup*qta*vpata*qs*us*mta**2+2*sdet3ctats*stw**2*qup*vpaup*qta*vpat
     & a*ts*mz**2*mta**2-2*sdet3ctats*stw**2*qup*vpaup*qta*vpata*us*mz**
     & 2*mta**2+2*sdet3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts*mta**2-2*s
     & det3ctats*stw**2*qup*vmaup*qta*vmata*qs*us*mta**2+2*sdet3ctats*st
     & w**2*qup*vmaup*qta*vmata*ts*mz**2*mta**2-2*sdet3ctats*stw**2*qup*
     & vmaup*qta*vmata*us*mz**2*mta**2+2*sdet3ctats**2*stw**2*qup*vpaup*
     & qta*vpata*qs*ts-2*sdet3ctats**2*stw**2*qup*vpaup*qta*vpata*qs*mta
     & **2+2*sdet3ctats**2*stw**2*qup*vpaup*qta*vpata*ts*mz**2-2*sdet3ct
     & ats**2*stw**2*qup*vpaup*qta*vpata*mz**2*mta**2+2*sdet3ctats**2*st
     & w**2*qup*vmaup*qta*vmata*qs*ts-2*sdet3ctats**2*stw**2*qup*vmaup*q
     & ta*vmata*qs*mta**2+2*sdet3ctats**2*stw**2*qup*vmaup*qta*vmata*ts*
     & mz**2-2*sdet3ctats**2*stw**2*qup*vmaup*qta*vmata*mz**2*mta**2-2*s
     & det3ctaus*stw**2*qup*vpaup*qta*vmata*qs*ts*mta**2+2*sdet3ctaus*st
     & w**2*qup*vpaup*qta*vmata*qs*us*mta**2-2*sdet3ctaus*stw**2*qup*vpa
     & up*qta*vmata*ts*mz**2*mta**2+2*sdet3ctaus*stw**2*qup*vpaup*qta*vm
     & ata*us*mz**2*mta**2-2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*qs*ts
     & *mta**2+2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us*mta**2-2*sd
     & et3ctaus*stw**2*qup*vmaup*qta*vpata*ts*mz**2*mta**2+2*sdet3ctaus*
     & stw**2*qup*vmaup*qta*vpata*us*mz**2*mta**2+2*sdet3ctaus**2*stw**2
     & *qup*vpaup*qta*vmata*qs*us-2*sdet3ctaus**2*stw**2*qup*vpaup*qta*v
     & mata*qs*mta**2+2*sdet3ctaus**2*stw**2*qup*vpaup*qta*vmata*us*mz**
     & 2-2*sdet3ctaus**2*stw**2*qup*vpaup*qta*vmata*mz**2*mta**2+2*sdet3
     & ctaus**2*stw**2*qup*vmaup*qta*vpata*qs*us-2*sdet3ctaus**2*stw**2*
     & qup*vmaup*qta*vpata*qs*mta**2+2*sdet3ctaus**2*stw**2*qup*vmaup*qt
     & a*vpata*us*mz**2-2*sdet3ctaus**2*stw**2*qup*vmaup*qta*vpata*mz**2
     & *mta**2)
     & +sdet4itatsus**2*c0upupqscupc*dreal(propizqs)*ifi*cfscheme*(16*st
     & w**4*ctw**2*qup**2*qta**2*qs**2*ts*us-8*stw**4*ctw**2*qup**2*qta*
     & *2*qs**2*ts**2-8*stw**4*ctw**2*qup**2*qta**2*qs**2*us**2)
     & +sdet4itatsus**2*c0tataqsztac*dreal(propizqs)*ifi*(-2*sdet3ctats*
     & stw**2*qup*vpaup*qta*vpata*qs*ts*mta**2+2*sdet3ctats*stw**2*qup*v
     & paup*qta*vpata*qs*ts**2+2*sdet3ctats*stw**2*qup*vpaup*qta*vpata*q
     & s*us*mta**2-2*sdet3ctats*stw**2*qup*vpaup*qta*vpata*qs*mta**4-2*s
     & det3ctats*stw**2*qup*vpaup*qta*vpata*ts*mz**2*mta**2+2*sdet3ctats
     & *stw**2*qup*vpaup*qta*vpata*ts**2*mz**2+2*sdet3ctats*stw**2*qup*v
     & paup*qta*vpata*us*mz**2*mta**2-2*sdet3ctats*stw**2*qup*vpaup*qta*
     & vpata*mz**2*mta**4-2*sdet3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts*
     & mta**2+2*sdet3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts**2+2*sdet3ct
     & ats*stw**2*qup*vmaup*qta*vmata*qs*us*mta**2-2*sdet3ctats*stw**2*q
     & up*vmaup*qta*vmata*qs*mta**4-2*sdet3ctats*stw**2*qup*vmaup*qta*vm
     & ata*ts*mz**2*mta**2+2*sdet3ctats*stw**2*qup*vmaup*qta*vmata*ts**2
     & *mz**2+2*sdet3ctats*stw**2*qup*vmaup*qta*vmata*us*mz**2*mta**2-2*
     & sdet3ctats*stw**2*qup*vmaup*qta*vmata*mz**2*mta**4+2*sdet3ctaus*s
     & tw**2*qup*vpaup*qta*vmata*qs*ts*mta**2-2*sdet3ctaus*stw**2*qup*vp
     & aup*qta*vmata*qs*us*mta**2+2*sdet3ctaus*stw**2*qup*vpaup*qta*vmat
     & a*qs*us**2-2*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*qs*mta**4+2*sd
     & et3ctaus*stw**2*qup*vpaup*qta*vmata*ts*mz**2*mta**2-2*sdet3ctaus*
     & stw**2*qup*vpaup*qta*vmata*us*mz**2*mta**2+2*sdet3ctaus*stw**2*qu
     & p*vpaup*qta*vmata*us**2*mz**2-2*sdet3ctaus*stw**2*qup*vpaup*qta*v
     & mata*mz**2*mta**4+2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*qs*ts*m
     & ta**2-2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us*mta**2+2*sdet
     & 3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us**2-2*sdet3ctaus*stw**2*qu
     & p*vmaup*qta*vpata*qs*mta**4+2*sdet3ctaus*stw**2*qup*vmaup*qta*vpa
     & ta*ts*mz**2*mta**2-2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*us*mz*
     & *2*mta**2+2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*us**2*mz**2-2*s
     & det3ctaus*stw**2*qup*vmaup*qta*vpata*mz**2*mta**4)
     & +sdet4itatsus**2*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(64*st
     & w**4*ctw**2*qup**2*qta**2*qs*ts*us*mta**2-32*stw**4*ctw**2*qup**2
     & *qta**2*qs*ts**2*mta**2-32*stw**4*ctw**2*qup**2*qta**2*qs*us**2*m
     & ta**2+16*stw**4*ctw**2*qup**2*qta**2*qs**2*ts*us-8*stw**4*ctw**2*
     & qup**2*qta**2*qs**2*ts**2-8*stw**4*ctw**2*qup**2*qta**2*qs**2*us*
     & *2-64*sdet3ctats*stw**4*ctw**2*qup**2*qta**2*qs*mta**4-16*sdet3ct
     & ats*stw**4*ctw**2*qup**2*qta**2*qs**2*mta**2-64*sdet3ctaus*stw**4
     & *ctw**2*qup**2*qta**2*qs*mta**4-16*sdet3ctaus*stw**4*ctw**2*qup**
     & 2*qta**2*qs**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*ifi*(-4*sdet3ctats*s
     & tw**2*qup*vpaup*qta*vpata*qs*ts**2+4*sdet3ctats*stw**2*qup*vpaup*
     & qta*vpata*qs*mta**4-4*sdet3ctats*stw**2*qup*vpaup*qta*vpata*ts**2
     & *mz**2+4*sdet3ctats*stw**2*qup*vpaup*qta*vpata*mz**2*mta**4-4*sde
     & t3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts**2+4*sdet3ctats*stw**2*q
     & up*vmaup*qta*vmata*qs*mta**4-4*sdet3ctats*stw**2*qup*vmaup*qta*vm
     & ata*ts**2*mz**2+4*sdet3ctats*stw**2*qup*vmaup*qta*vmata*mz**2*mta
     & **4)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*ifi*(-4*sdet3ctaus*s
     & tw**2*qup*vpaup*qta*vmata*qs*us**2+4*sdet3ctaus*stw**2*qup*vpaup*
     & qta*vmata*qs*mta**4-4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*us**2
     & *mz**2+4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*mz**2*mta**4-4*sde
     & t3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us**2+4*sdet3ctaus*stw**2*q
     & up*vmaup*qta*vpata*qs*mta**4-4*sdet3ctaus*stw**2*qup*vmaup*qta*vp
     & ata*us**2*mz**2+4*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*mz**2*mta
     & **4)
     & +sdet4itatsus*javqstsuptaz*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*vpata*ts*mta**2-2*stw**2*qup*vpaup*qta*vpata*mta**4-2*stw*
     & *2*qup*vpaup*qta*vmata*ts*mta**2-2*stw**2*qup*vpaup*qta*vmata*mta
     & **4-2*stw**2*qup*vmaup*qta*vpata*ts*mta**2-2*stw**2*qup*vmaup*qta
     & *vpata*mta**4-2*stw**2*qup*vmaup*qta*vmata*ts*mta**2-2*stw**2*qup
     & *vmaup*qta*vmata*mta**4-4*sdet3ctats*stw**2*qup*vpaup*qta*vpata*t
     & s-4*sdet3ctats*stw**2*qup*vmaup*qta*vmata*ts)
     & +sdet4itatsus*javqsusuptaz*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*vpata*us*mta**2-2*stw**2*qup*vpaup*qta*vpata*mta**4-2*stw*
     & *2*qup*vpaup*qta*vmata*us*mta**2-2*stw**2*qup*vpaup*qta*vmata*mta
     & **4-2*stw**2*qup*vmaup*qta*vpata*us*mta**2-2*stw**2*qup*vmaup*qta
     & *vpata*mta**4-2*stw**2*qup*vmaup*qta*vmata*us*mta**2-2*stw**2*qup
     & *vmaup*qta*vmata*mta**4-4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*u
     & s-4*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*us)
     & +sdet4itatsus*c0upupqszupc*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*vpata*qs*ts-2*stw**2*qup*vpaup*qta*vpata*qs*mta**2+2*stw**
     & 2*qup*vpaup*qta*vpata*ts*mz**2+2*stw**2*qup*vpaup*qta*vpata*mz**2
     & *mta**2-2*stw**2*qup*vpaup*qta*vmata*qs*us-2*stw**2*qup*vpaup*qta
     & *vmata*qs*mta**2+2*stw**2*qup*vpaup*qta*vmata*us*mz**2+2*stw**2*q
     & up*vpaup*qta*vmata*mz**2*mta**2-2*stw**2*qup*vmaup*qta*vpata*qs*u
     & s-2*stw**2*qup*vmaup*qta*vpata*qs*mta**2+2*stw**2*qup*vmaup*qta*v
     & pata*us*mz**2+2*stw**2*qup*vmaup*qta*vpata*mz**2*mta**2-2*stw**2*
     & qup*vmaup*qta*vmata*qs*ts-2*stw**2*qup*vmaup*qta*vmata*qs*mta**2+
     & 2*stw**2*qup*vmaup*qta*vmata*ts*mz**2+2*stw**2*qup*vmaup*qta*vmat
     & a*mz**2*mta**2)
     & +sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*vpata/qs*ts*mz**2*mta**2+2*stw**2*qup*vpaup*qta*vpata/qs*u
     & s*mz**2*mta**2-2*stw**2*qup*vpaup*qta*vpata*qs*ts+2*stw**2*qup*vp
     & aup*qta*vpata*ts*mz**2-10*stw**2*qup*vpaup*qta*vpata*ts*mta**2+2*
     & stw**2*qup*vpaup*qta*vpata*us*mta**2-8*stw**2*qup*vpaup*qta*vpata
     & *mta**4+2*stw**2*qup*vpaup*qta*vmata/qs*ts*mz**2*mta**2-2*stw**2*
     & qup*vpaup*qta*vmata/qs*us*mz**2*mta**2-2*stw**2*qup*vpaup*qta*vma
     & ta*qs*us+2*stw**2*qup*vpaup*qta*vmata*ts*mta**2+2*stw**2*qup*vpau
     & p*qta*vmata*us*mz**2-10*stw**2*qup*vpaup*qta*vmata*us*mta**2-8*st
     & w**2*qup*vpaup*qta*vmata*mta**4+2*stw**2*qup*vmaup*qta*vpata/qs*t
     & s*mz**2*mta**2-2*stw**2*qup*vmaup*qta*vpata/qs*us*mz**2*mta**2-2*
     & stw**2*qup*vmaup*qta*vpata*qs*us+2*stw**2*qup*vmaup*qta*vpata*ts*
     & mta**2+2*stw**2*qup*vmaup*qta*vpata*us*mz**2-10*stw**2*qup*vmaup*
     & qta*vpata*us*mta**2-8*stw**2*qup*vmaup*qta*vpata*mta**4-2*stw**2*
     & qup*vmaup*qta*vmata/qs*ts*mz**2*mta**2+2*stw**2*qup*vmaup*qta*vma
     & ta/qs*us*mz**2*mta**2-2*stw**2*qup*vmaup*qta*vmata*qs*ts+2*stw**2
     & *qup*vmaup*qta*vmata*ts*mz**2-10*stw**2*qup*vmaup*qta*vmata*ts*mt
     & a**2+2*stw**2*qup*vmaup*qta*vmata*us*mta**2-8*stw**2*qup*vmaup*qt
     & a*vmata*mta**4+4*sdet3ctats*stw**2*qup*vpaup*qta*vpata/qs*mz**2*m
     & ta**2+4*sdet3ctats*stw**2*qup*vpaup*qta*vpata*mta**2+4*sdet3ctats
     & *stw**2*qup*vmaup*qta*vmata/qs*mz**2*mta**2+4*sdet3ctats*stw**2*q
     & up*vmaup*qta*vmata*mta**2+4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata
     & /qs*mz**2*mta**2+4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*mta**2+4
     & *sdet3ctaus*stw**2*qup*vmaup*qta*vpata/qs*mz**2*mta**2+4*sdet3cta
     & us*stw**2*qup*vmaup*qta*vpata*mta**2)
     & +sdet4itatsus*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(-32*stw*
     & *4*ctw**2*qup**2*qta**2*qs*mta**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw**2*qup*vpau
     & p*qta*vpata*ts*mta**2-4*stw**2*qup*vpaup*qta*vpata*mta**4-4*stw**
     & 2*qup*vpaup*qta*vmata*ts*mta**2-4*stw**2*qup*vpaup*qta*vmata*mta*
     & *4-4*stw**2*qup*vmaup*qta*vpata*ts*mta**2-4*stw**2*qup*vmaup*qta*
     & vpata*mta**4-4*stw**2*qup*vmaup*qta*vmata*ts*mta**2-4*stw**2*qup*
     & vmaup*qta*vmata*mta**4-4*sdet3ctats*stw**2*qup*vpaup*qta*vpata/qs
     & *mz**2*mta**2-8*sdet3ctats*stw**2*qup*vpaup*qta*vpata*ts-4*sdet3c
     & tats*stw**2*qup*vmaup*qta*vmata/qs*mz**2*mta**2-8*sdet3ctats*stw*
     & *2*qup*vmaup*qta*vmata*ts)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(-4*stw**2*qup*vpau
     & p*qta*vpata*us*mta**2-4*stw**2*qup*vpaup*qta*vpata*mta**4-4*stw**
     & 2*qup*vpaup*qta*vmata*us*mta**2-4*stw**2*qup*vpaup*qta*vmata*mta*
     & *4-4*stw**2*qup*vmaup*qta*vpata*us*mta**2-4*stw**2*qup*vmaup*qta*
     & vpata*mta**4-4*stw**2*qup*vmaup*qta*vmata*us*mta**2-4*stw**2*qup*
     & vmaup*qta*vmata*mta**4-4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata/qs
     & *mz**2*mta**2-8*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*us-4*sdet3c
     & taus*stw**2*qup*vmaup*qta*vpata/qs*mz**2*mta**2-8*sdet3ctaus*stw*
     & *2*qup*vmaup*qta*vpata*us)
     & +sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(-64*stw**4*c
     & tw**2*qup**2*qta**2*mta**2)
     & +sdet4itatsus*b0fqszc*dreal(propizqs)*ifi*(4*stw**2*qup*vpaup*qta
     & *vpata*ts+4*stw**2*qup*vpaup*qta*vpata*mta**2+4*stw**2*qup*vpaup*
     & qta*vmata*us+4*stw**2*qup*vpaup*qta*vmata*mta**2+4*stw**2*qup*vma
     & up*qta*vpata*us+4*stw**2*qup*vmaup*qta*vpata*mta**2+4*stw**2*qup*
     & vmaup*qta*vmata*ts+4*stw**2*qup*vmaup*qta*vmata*mta**2)
     & +sdet4itatsus*b0fqscc*dreal(propizqs)*ifi*cfscheme*(16*sdet3ctats
     & *stw**4*ctw**2*qup**2*qta**2+16*sdet3ctaus*stw**4*ctw**2*qup**2*q
     & ta**2)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*cfscheme*(32*stw**4*ct
     & w**2*qup**2*qta**2*mta**2-16*sdet3ctats*stw**4*ctw**2*qup**2*qta*
     & *2)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(-4*stw**2*qup*vpaup*q
     & ta*vpata*ts-4*stw**2*qup*vpaup*qta*vpata*mta**2-4*stw**2*qup*vmau
     & p*qta*vmata*ts-4*stw**2*qup*vmaup*qta*vmata*mta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*cfscheme*(32*stw**4*ct
     & w**2*qup**2*qta**2*mta**2-16*sdet3ctaus*stw**4*ctw**2*qup**2*qta*
     & *2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(-4*stw**2*qup*vpaup*q
     & ta*vmata*us-4*stw**2*qup*vpaup*qta*vmata*mta**2-4*stw**2*qup*vmau
     & p*qta*vpata*us-4*stw**2*qup*vmaup*qta*vpata*mta**2)
     & +javqstsuptaz*ifi*(-4*sdet3ctats*stw**2*qup*vpaup*qta*vpata+4*sde
     & t3ctats*stw**2*qup*vpaup*qta*vmata+4*sdet3ctats*stw**2*qup*vmaup*
     & qta*vpata-4*sdet3ctats*stw**2*qup*vmaup*qta*vmata)
     & +javqsusuptaz*ifi*(4*sdet3ctaus*stw**2*qup*vpaup*qta*vpata-4*sdet
     & 3ctaus*stw**2*qup*vpaup*qta*vmata-4*sdet3ctaus*stw**2*qup*vmaup*q
     & ta*vpata+4*sdet3ctaus*stw**2*qup*vmaup*qta*vmata)
     & +c0irupupqs*isr*(-2*stw**2*qup**2*qs)
     & +c0iruptats*ifi*(4*sdet3ctats*stw**2*qup*vpaup*qta*vpata-4*sdet3c
     & tats*stw**2*qup*vpaup*qta*vmata-4*sdet3ctats*stw**2*qup*vmaup*qta
     & *vpata+4*sdet3ctats*stw**2*qup*vmaup*qta*vmata)
     & +c0iruptaus*ifi*(-4*sdet3ctaus*stw**2*qup*vpaup*qta*vpata+4*sdet3
     & ctaus*stw**2*qup*vpaup*qta*vmata+4*sdet3ctaus*stw**2*qup*vmaup*qt
     & a*vpata-4*sdet3ctaus*stw**2*qup*vmaup*qta*vmata)
     & +c0irtataqs*fsr*(-2*stw**2*qta**2*qs-4*stw**2*qta**2*mta**2)
     & +c0ctatsczta*ifi*(-4*sdet3ctats*stw**2*qup*vpaup*qta*vpata+4*sdet
     & 3ctats*stw**2*qup*vpaup*qta*vmata+4*sdet3ctats*stw**2*qup*vmaup*q
     & ta*vpata-4*sdet3ctats*stw**2*qup*vmaup*qta*vmata)
     & +c0ctausczta*ifi*(4*sdet3ctaus*stw**2*qup*vpaup*qta*vpata-4*sdet3
     & ctaus*stw**2*qup*vpaup*qta*vmata-4*sdet3ctaus*stw**2*qup*vmaup*qt
     & a*vpata+4*sdet3ctaus*stw**2*qup*vmaup*qta*vmata)
     & +a0fup*isr*(-3*stw**2*qup**2)
     & +a0fta*fsr*(-3*stw**2*qta**2)
     & +b0fqstata*fsr*(-3*stw**2*qta**2)
     & +b0fqscc*isr*(-3*stw**2*qup**2)
     & +lnlaupm*isr*(2*stw**2*qup**2)
     & +lnlatam*fsr*(2*stw**2*qta**2)

      ff_qed_ql =
     & +isr*(-stw**2*qup**2)
     & +fsr*(-stw**2*qta**2)
     & +det3itataqs*fsr*(2*stw**2*qta**2*qs*mta**2)
     & +det3itataqs*a0fta*fsr*(-2*stw**2*qta**2*qs*mta**2)
     & +det3itataqs*b0fqstata*fsr*(-2*stw**2*qta**2*qs*mta**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(4*stw*
     & *2*qup*qta*vmata*ts*mz**2*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*vmata*ts*mta**2+4*stw**2*qup*qta*vmata*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*vmata*ts*mta**2+4*stw**2*qup*qta*vmata*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(-8*stw**2
     & *qup*qta*vmata*ts*mta**2-8*stw**2*qup*qta*vmata*mta**4)
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*ifi*(4*stw**2*qup*qta*vm
     & ata/qs*mz**2*mta**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(4*stw*
     & *2*qup*qta*vpata*us*mz**2*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*vpata*us*mta**2+4*stw**2*qup*qta*vpata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*vpata*us*mta**2+4*stw**2*qup*qta*vpata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(-8*stw**2
     & *qup*qta*vpata*us*mta**2-8*stw**2*qup*qta*vpata*mta**4)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*ifi*(4*stw**2*qup*qta*vp
     & ata/qs*mz**2*mta**2)
     & +sdet4itatsus**2*jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(2*sdet
     & 3ctats**3*stw**2*ctw**2*qup*qta**2*ts-2*sdet3ctats**3*stw**2*ctw*
     & *2*qup*qta**2*us)
     & +sdet4itatsus**2*jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(-2*sde
     & t3ctaus**3*stw**2*ctw**2*qup*qta**2*ts+2*sdet3ctaus**3*stw**2*ctw
     & **2*qup*qta**2*us)
     & +sdet4itatsus**2*javqstsuptaz*dreal(propizqs)*ifi*(2*sdet3ctats*s
     & tw**2*qup*qta*vmata*qs*ts**2-2*sdet3ctats*stw**2*qup*qta*vmata*qs
     & *mta**4+2*sdet3ctats*stw**2*qup*qta*vmata*ts**2*mz**2-2*sdet3ctat
     & s*stw**2*qup*qta*vmata*mz**2*mta**4)
     & +sdet4itatsus**2*javqsusuptaz*dreal(propizqs)*ifi*(2*sdet3ctaus*s
     & tw**2*qup*qta*vpata*qs*us**2-2*sdet3ctaus*stw**2*qup*qta*vpata*qs
     & *mta**4+2*sdet3ctaus*stw**2*qup*qta*vpata*us**2*mz**2-2*sdet3ctau
     & s*stw**2*qup*qta*vpata*mz**2*mta**4)
     & +sdet4itatsus**2*c0upupqszupc*dreal(propizqs)*ifi*(-2*sdet3ctats*
     & stw**2*qup*qta*vmata*qs*ts*mta**2+2*sdet3ctats*stw**2*qup*qta*vma
     & ta*qs*us*mta**2-2*sdet3ctats*stw**2*qup*qta*vmata*ts*mz**2*mta**2
     & +2*sdet3ctats*stw**2*qup*qta*vmata*us*mz**2*mta**2-2*sdet3ctats**
     & 2*stw**2*qup*qta*vmata*qs*ts+2*sdet3ctats**2*stw**2*qup*qta*vmata
     & *qs*mta**2-2*sdet3ctats**2*stw**2*qup*qta*vmata*ts*mz**2+2*sdet3c
     & tats**2*stw**2*qup*qta*vmata*mz**2*mta**2+2*sdet3ctaus*stw**2*qup
     & *qta*vpata*qs*ts*mta**2-2*sdet3ctaus*stw**2*qup*qta*vpata*qs*us*m
     & ta**2+2*sdet3ctaus*stw**2*qup*qta*vpata*ts*mz**2*mta**2-2*sdet3ct
     & aus*stw**2*qup*qta*vpata*us*mz**2*mta**2-2*sdet3ctaus**2*stw**2*q
     & up*qta*vpata*qs*us+2*sdet3ctaus**2*stw**2*qup*qta*vpata*qs*mta**2
     & -2*sdet3ctaus**2*stw**2*qup*qta*vpata*us*mz**2+2*sdet3ctaus**2*st
     & w**2*qup*qta*vpata*mz**2*mta**2)
     & +sdet4itatsus**2*c0upupqscupc*dreal(propizqs)*ifi*cfscheme*(4*stw
     & **2*ctw**2*qup*qta**2*qs**2*ts*us-2*stw**2*ctw**2*qup*qta**2*qs**
     & 2*ts**2-2*stw**2*ctw**2*qup*qta**2*qs**2*us**2)
     & +sdet4itatsus**2*c0tataqsztac*dreal(propizqs)*ifi*(2*sdet3ctats*s
     & tw**2*qup*qta*vmata*qs*ts*mta**2-2*sdet3ctats*stw**2*qup*qta*vmat
     & a*qs*ts**2-2*sdet3ctats*stw**2*qup*qta*vmata*qs*us*mta**2+2*sdet3
     & ctats*stw**2*qup*qta*vmata*qs*mta**4+2*sdet3ctats*stw**2*qup*qta*
     & vmata*ts*mz**2*mta**2-2*sdet3ctats*stw**2*qup*qta*vmata*ts**2*mz*
     & *2-2*sdet3ctats*stw**2*qup*qta*vmata*us*mz**2*mta**2+2*sdet3ctats
     & *stw**2*qup*qta*vmata*mz**2*mta**4-2*sdet3ctaus*stw**2*qup*qta*vp
     & ata*qs*ts*mta**2+2*sdet3ctaus*stw**2*qup*qta*vpata*qs*us*mta**2-2
     & *sdet3ctaus*stw**2*qup*qta*vpata*qs*us**2+2*sdet3ctaus*stw**2*qup
     & *qta*vpata*qs*mta**4-2*sdet3ctaus*stw**2*qup*qta*vpata*ts*mz**2*m
     & ta**2+2*sdet3ctaus*stw**2*qup*qta*vpata*us*mz**2*mta**2-2*sdet3ct
     & aus*stw**2*qup*qta*vpata*us**2*mz**2+2*sdet3ctaus*stw**2*qup*qta*
     & vpata*mz**2*mta**4)
     & +sdet4itatsus**2*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(16*st
     & w**2*ctw**2*qup*qta**2*qs*ts*us*mta**2-8*stw**2*ctw**2*qup*qta**2
     & *qs*ts**2*mta**2-8*stw**2*ctw**2*qup*qta**2*qs*us**2*mta**2+4*stw
     & **2*ctw**2*qup*qta**2*qs**2*ts*us-2*stw**2*ctw**2*qup*qta**2*qs**
     & 2*ts**2-2*stw**2*ctw**2*qup*qta**2*qs**2*us**2-16*sdet3ctats*stw*
     & *2*ctw**2*qup*qta**2*qs*mta**4-4*sdet3ctats*stw**2*ctw**2*qup*qta
     & **2*qs**2*mta**2-16*sdet3ctaus*stw**2*ctw**2*qup*qta**2*qs*mta**4
     & -4*sdet3ctaus*stw**2*ctw**2*qup*qta**2*qs**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*ifi*(4*sdet3ctats*st
     & w**2*qup*qta*vmata*qs*ts**2-4*sdet3ctats*stw**2*qup*qta*vmata*qs*
     & mta**4+4*sdet3ctats*stw**2*qup*qta*vmata*ts**2*mz**2-4*sdet3ctats
     & *stw**2*qup*qta*vmata*mz**2*mta**4)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*ifi*(4*sdet3ctaus*st
     & w**2*qup*qta*vpata*qs*us**2-4*sdet3ctaus*stw**2*qup*qta*vpata*qs*
     & mta**4+4*sdet3ctaus*stw**2*qup*qta*vpata*us**2*mz**2-4*sdet3ctaus
     & *stw**2*qup*qta*vpata*mz**2*mta**4)
     & +sdet4itatsus*javqstsuptaz*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & vpata*ts*mta**2+2*stw**2*qup*qta*vpata*mta**4+2*stw**2*qup*qta*vm
     & ata*ts*mta**2+2*stw**2*qup*qta*vmata*mta**4+4*sdet3ctats*stw**2*q
     & up*qta*vmata*ts)
     & +sdet4itatsus*javqsusuptaz*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & vpata*us*mta**2+2*stw**2*qup*qta*vpata*mta**4+2*stw**2*qup*qta*vm
     & ata*us*mta**2+2*stw**2*qup*qta*vmata*mta**4+4*sdet3ctaus*stw**2*q
     & up*qta*vpata*us)
     & +sdet4itatsus*c0upupqszupc*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & vpata*qs*us+2*stw**2*qup*qta*vpata*qs*mta**2-2*stw**2*qup*qta*vpa
     & ta*us*mz**2-2*stw**2*qup*qta*vpata*mz**2*mta**2+2*stw**2*qup*qta*
     & vmata*qs*ts+2*stw**2*qup*qta*vmata*qs*mta**2-2*stw**2*qup*qta*vma
     & ta*ts*mz**2-2*stw**2*qup*qta*vmata*mz**2*mta**2)
     & +sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(-2*stw**2*qup*qta
     & *vpata/qs*ts*mz**2*mta**2+2*stw**2*qup*qta*vpata/qs*us*mz**2*mta*
     & *2+2*stw**2*qup*qta*vpata*qs*us-2*stw**2*qup*qta*vpata*ts*mta**2-
     & 2*stw**2*qup*qta*vpata*us*mz**2+10*stw**2*qup*qta*vpata*us*mta**2
     & +8*stw**2*qup*qta*vpata*mta**4+2*stw**2*qup*qta*vmata/qs*ts*mz**2
     & *mta**2-2*stw**2*qup*qta*vmata/qs*us*mz**2*mta**2+2*stw**2*qup*qt
     & a*vmata*qs*ts-2*stw**2*qup*qta*vmata*ts*mz**2+10*stw**2*qup*qta*v
     & mata*ts*mta**2-2*stw**2*qup*qta*vmata*us*mta**2+8*stw**2*qup*qta*
     & vmata*mta**4-4*sdet3ctats*stw**2*qup*qta*vmata/qs*mz**2*mta**2-4*
     & sdet3ctats*stw**2*qup*qta*vmata*mta**2-4*sdet3ctaus*stw**2*qup*qt
     & a*vpata/qs*mz**2*mta**2-4*sdet3ctaus*stw**2*qup*qta*vpata*mta**2)
     & 
     & +sdet4itatsus*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(-8*stw**
     & 2*ctw**2*qup*qta**2*qs*mta**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(4*stw**2*qup*qta*v
     & pata*ts*mta**2+4*stw**2*qup*qta*vpata*mta**4+4*stw**2*qup*qta*vma
     & ta*ts*mta**2+4*stw**2*qup*qta*vmata*mta**4+4*sdet3ctats*stw**2*qu
     & p*qta*vmata/qs*mz**2*mta**2+8*sdet3ctats*stw**2*qup*qta*vmata*ts)
     & 
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(4*stw**2*qup*qta*v
     & pata*us*mta**2+4*stw**2*qup*qta*vpata*mta**4+4*stw**2*qup*qta*vma
     & ta*us*mta**2+4*stw**2*qup*qta*vmata*mta**4+4*sdet3ctaus*stw**2*qu
     & p*qta*vpata/qs*mz**2*mta**2+8*sdet3ctaus*stw**2*qup*qta*vpata*us)
     & 
     & +sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(-16*stw**2*c
     & tw**2*qup*qta**2*mta**2)
     & +sdet4itatsus*b0fqszc*dreal(propizqs)*ifi*(-4*stw**2*qup*qta*vpat
     & a*us-4*stw**2*qup*qta*vpata*mta**2-4*stw**2*qup*qta*vmata*ts-4*st
     & w**2*qup*qta*vmata*mta**2)
     & +sdet4itatsus*b0fqscc*dreal(propizqs)*ifi*cfscheme*(4*sdet3ctats*
     & stw**2*ctw**2*qup*qta**2+4*sdet3ctaus*stw**2*ctw**2*qup*qta**2)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*cfscheme*(8*stw**2*ctw
     & **2*qup*qta**2*mta**2-4*sdet3ctats*stw**2*ctw**2*qup*qta**2)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(4*stw**2*qup*qta*vmat
     & a*ts+4*stw**2*qup*qta*vmata*mta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*cfscheme*(8*stw**2*ctw
     & **2*qup*qta**2*mta**2-4*sdet3ctaus*stw**2*ctw**2*qup*qta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(4*stw**2*qup*qta*vpat
     & a*us+4*stw**2*qup*qta*vpata*mta**2)
     & +javqstsuptaz*ifi*(-4*sdet3ctats*stw**2*qup*qta*vpata+4*sdet3ctat
     & s*stw**2*qup*qta*vmata)
     & +javqsusuptaz*ifi*(4*sdet3ctaus*stw**2*qup*qta*vpata-4*sdet3ctaus
     & *stw**2*qup*qta*vmata)
     & +c0irupupqs*isr*(-2*stw**2*qup**2*qs)
     & +c0iruptats*ifi*(4*sdet3ctats*stw**2*qup*qta*vpata-4*sdet3ctats*s
     & tw**2*qup*qta*vmata)
     & +c0iruptaus*ifi*(-4*sdet3ctaus*stw**2*qup*qta*vpata+4*sdet3ctaus*
     & stw**2*qup*qta*vmata)
     & +c0irtataqs*fsr*(-2*stw**2*qta**2*qs-4*stw**2*qta**2*mta**2)
     & +c0ctatsczta*ifi*(-4*sdet3ctats*stw**2*qup*qta*vpata+4*sdet3ctats
     & *stw**2*qup*qta*vmata)
     & +c0ctausczta*ifi*(4*sdet3ctaus*stw**2*qup*qta*vpata-4*sdet3ctaus*
     & stw**2*qup*qta*vmata)
     & +a0fup*isr*(-3*stw**2*qup**2)
     & +a0fta*fsr*(-3*stw**2*qta**2)
     & +b0fqstata*fsr*(-3*stw**2*qta**2)
     & +b0fqscc*isr*(-3*stw**2*qup**2)
     & +lnlaupm*isr*(2*stw**2*qup**2)
     & +lnlatam*fsr*(2*stw**2*qta**2)

      ff_qed_lq =
     & +isr*(-stw**2*qup**2)
     & +fsr*(-stw**2*qta**2)
     & +det3itataqs*fsr*(-1d0/2*qta*qs*mta**2)
     & +det3itataqs*a0fta*fsr*(1d0/2*qta*qs*mta**2)
     & +det3itataqs*b0fqstata*fsr*(1d0/2*qta*qs*mta**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw
     & **2*qup*vmaup*qta*ts*mz**2*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vmaup*qta*ts*mta**2+2*qup*vpaup*vpata*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vmaup*qta*ts*mta**2+2*qup*vpaup*vpata*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(8*stw**2*
     & qup*vmaup*qta*ts*mta**2-4*qup*vpaup*vpata*mta**4)
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*ifi*(2*qup*vpaup*vpata/q
     & s*mz**2*mta**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(-4*stw
     & **2*qup*vpaup*qta*us*mz**2*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*us*mta**2+2*qup*vmaup*vpata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*us*mta**2+2*qup*vmaup*vpata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(8*stw**2*
     & qup*vpaup*qta*us*mta**2-4*qup*vmaup*vpata*mta**4)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*ifi*(2*qup*vmaup*vpata/q
     & s*mz**2*mta**2)
     & +sdet4itatsus**2*jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(-2*sde
     & t3ctats**3*stw**2*ctw**2*qup**2*qta*ts+2*sdet3ctats**3*stw**2*ctw
     & **2*qup**2*qta*us)
     & +sdet4itatsus**2*jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(2*sdet
     & 3ctaus**3*stw**2*ctw**2*qup**2*qta*ts-2*sdet3ctaus**3*stw**2*ctw*
     & *2*qup**2*qta*us)
     & +sdet4itatsus**2*javqstsuptaz*dreal(propizqs)*ifi*(2*sdet3ctats*s
     & tw**2*qup*vmaup*qta*qs*ts*mta**2-2*sdet3ctats*stw**2*qup*vmaup*qt
     & a*qs*ts**2+2*sdet3ctats*stw**2*qup*vmaup*qta*ts*mz**2*mta**2-2*sd
     & et3ctats*stw**2*qup*vmaup*qta*ts**2*mz**2+sdet3ctats*qup*vpaup*vp
     & ata*qs*ts*mta**2-sdet3ctats*qup*vpaup*vpata*qs*mta**4+sdet3ctats*
     & qup*vpaup*vpata*ts*mz**2*mta**2-sdet3ctats*qup*vpaup*vpata*mz**2*
     & mta**4)
     & +sdet4itatsus**2*javqsusuptaz*dreal(propizqs)*ifi*(2*sdet3ctaus*s
     & tw**2*qup*vpaup*qta*qs*us*mta**2-2*sdet3ctaus*stw**2*qup*vpaup*qt
     & a*qs*us**2+2*sdet3ctaus*stw**2*qup*vpaup*qta*us*mz**2*mta**2-2*sd
     & et3ctaus*stw**2*qup*vpaup*qta*us**2*mz**2+sdet3ctaus*qup*vmaup*vp
     & ata*qs*us*mta**2-sdet3ctaus*qup*vmaup*vpata*qs*mta**4+sdet3ctaus*
     & qup*vmaup*vpata*us*mz**2*mta**2-sdet3ctaus*qup*vmaup*vpata*mz**2*
     & mta**4)
     & +sdet4itatsus**2*c0upupqszupc*dreal(propizqs)*ifi*(-sdet3ctats*qu
     & p*vpaup*vpata*qs*ts*mta**2+sdet3ctats*qup*vpaup*vpata*qs*us*mta**
     & 2-sdet3ctats*qup*vpaup*vpata*ts*mz**2*mta**2+sdet3ctats*qup*vpaup
     & *vpata*us*mz**2*mta**2+2*sdet3ctats**2*stw**2*qup*vmaup*qta*qs*ts
     & -2*sdet3ctats**2*stw**2*qup*vmaup*qta*qs*mta**2+2*sdet3ctats**2*s
     & tw**2*qup*vmaup*qta*ts*mz**2-2*sdet3ctats**2*stw**2*qup*vmaup*qta
     & *mz**2*mta**2+sdet3ctaus*qup*vmaup*vpata*qs*ts*mta**2-sdet3ctaus*
     & qup*vmaup*vpata*qs*us*mta**2+sdet3ctaus*qup*vmaup*vpata*ts*mz**2*
     & mta**2-sdet3ctaus*qup*vmaup*vpata*us*mz**2*mta**2+2*sdet3ctaus**2
     & *stw**2*qup*vpaup*qta*qs*us-2*sdet3ctaus**2*stw**2*qup*vpaup*qta*
     & qs*mta**2+2*sdet3ctaus**2*stw**2*qup*vpaup*qta*us*mz**2-2*sdet3ct
     & aus**2*stw**2*qup*vpaup*qta*mz**2*mta**2)
     & +sdet4itatsus**2*c0upupqscupc*dreal(propizqs)*ifi*cfscheme*(-4*st
     & w**2*ctw**2*qup**2*qta*qs**2*ts*us+2*stw**2*ctw**2*qup**2*qta*qs*
     & *2*ts**2+2*stw**2*ctw**2*qup**2*qta*qs**2*us**2)
     & +sdet4itatsus**2*c0tataqsztac*dreal(propizqs)*ifi*(-4*sdet3ctats*
     & stw**2*qup*vmaup*qta*qs*ts*mta**2+2*sdet3ctats*stw**2*qup*vmaup*q
     & ta*qs*ts**2+2*sdet3ctats*stw**2*qup*vmaup*qta*qs*mta**4-4*sdet3ct
     & ats*stw**2*qup*vmaup*qta*ts*mz**2*mta**2+2*sdet3ctats*stw**2*qup*
     & vmaup*qta*ts**2*mz**2+2*sdet3ctats*stw**2*qup*vmaup*qta*mz**2*mta
     & **4-sdet3ctats*qup*vpaup*vpata*qs*ts*mta**2-sdet3ctats*qup*vpaup*
     & vpata*qs*us*mta**2+2*sdet3ctats*qup*vpaup*vpata*qs*mta**4-sdet3ct
     & ats*qup*vpaup*vpata*ts*mz**2*mta**2-sdet3ctats*qup*vpaup*vpata*us
     & *mz**2*mta**2+2*sdet3ctats*qup*vpaup*vpata*mz**2*mta**4-4*sdet3ct
     & aus*stw**2*qup*vpaup*qta*qs*us*mta**2+2*sdet3ctaus*stw**2*qup*vpa
     & up*qta*qs*us**2+2*sdet3ctaus*stw**2*qup*vpaup*qta*qs*mta**4-4*sde
     & t3ctaus*stw**2*qup*vpaup*qta*us*mz**2*mta**2+2*sdet3ctaus*stw**2*
     & qup*vpaup*qta*us**2*mz**2+2*sdet3ctaus*stw**2*qup*vpaup*qta*mz**2
     & *mta**4-sdet3ctaus*qup*vmaup*vpata*qs*ts*mta**2-sdet3ctaus*qup*vm
     & aup*vpata*qs*us*mta**2+2*sdet3ctaus*qup*vmaup*vpata*qs*mta**4-sde
     & t3ctaus*qup*vmaup*vpata*ts*mz**2*mta**2-sdet3ctaus*qup*vmaup*vpat
     & a*us*mz**2*mta**2+2*sdet3ctaus*qup*vmaup*vpata*mz**2*mta**4)
     & +sdet4itatsus**2*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(-16*s
     & tw**2*ctw**2*qup**2*qta*qs*ts*us*mta**2+8*stw**2*ctw**2*qup**2*qt
     & a*qs*ts**2*mta**2+8*stw**2*ctw**2*qup**2*qta*qs*us**2*mta**2-4*st
     & w**2*ctw**2*qup**2*qta*qs**2*ts*us+2*stw**2*ctw**2*qup**2*qta*qs*
     & *2*ts**2+2*stw**2*ctw**2*qup**2*qta*qs**2*us**2+16*sdet3ctats*stw
     & **2*ctw**2*qup**2*qta*qs*mta**4+4*sdet3ctats*stw**2*ctw**2*qup**2
     & *qta*qs**2*mta**2+16*sdet3ctaus*stw**2*ctw**2*qup**2*qta*qs*mta**
     & 4+4*sdet3ctaus*stw**2*ctw**2*qup**2*qta*qs**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*ifi*(4*sdet3ctats*st
     & w**2*qup*vmaup*qta*qs*ts*mta**2-4*sdet3ctats*stw**2*qup*vmaup*qta
     & *qs*ts**2+4*sdet3ctats*stw**2*qup*vmaup*qta*ts*mz**2*mta**2-4*sde
     & t3ctats*stw**2*qup*vmaup*qta*ts**2*mz**2+2*sdet3ctats*qup*vpaup*v
     & pata*qs*ts*mta**2-2*sdet3ctats*qup*vpaup*vpata*qs*mta**4+2*sdet3c
     & tats*qup*vpaup*vpata*ts*mz**2*mta**2-2*sdet3ctats*qup*vpaup*vpata
     & *mz**2*mta**4)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*ifi*(4*sdet3ctaus*st
     & w**2*qup*vpaup*qta*qs*us*mta**2-4*sdet3ctaus*stw**2*qup*vpaup*qta
     & *qs*us**2+4*sdet3ctaus*stw**2*qup*vpaup*qta*us*mz**2*mta**2-4*sde
     & t3ctaus*stw**2*qup*vpaup*qta*us**2*mz**2+2*sdet3ctaus*qup*vmaup*v
     & pata*qs*us*mta**2-2*sdet3ctaus*qup*vmaup*vpata*qs*mta**4+2*sdet3c
     & taus*qup*vmaup*vpata*us*mz**2*mta**2-2*sdet3ctaus*qup*vmaup*vpata
     & *mz**2*mta**4)
     & +sdet4itatsus*javqstsuptaz*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*mta**4-2*stw**2*qup*vmaup*qta*mta**4+qup*vpaup*vpata*ts*mt
     & a**2+qup*vmaup*vpata*ts*mta**2+2*sdet3ctats*stw**2*qup*vmaup*qta/
     & qs*mz**2*mta**2-4*sdet3ctats*stw**2*qup*vmaup*qta*ts+4*sdet3ctats
     & *stw**2*qup*vmaup*qta*mta**2+sdet3ctats*qup*vpaup*vpata/qs*mz**2*
     & mta**2+2*sdet3ctats*qup*vpaup*vpata*mta**2)
     & +sdet4itatsus*javqsusuptaz*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*mta**4-2*stw**2*qup*vmaup*qta*mta**4+qup*vpaup*vpata*us*mt
     & a**2+qup*vmaup*vpata*us*mta**2+2*sdet3ctaus*stw**2*qup*vpaup*qta/
     & qs*mz**2*mta**2-4*sdet3ctaus*stw**2*qup*vpaup*qta*us+4*sdet3ctaus
     & *stw**2*qup*vpaup*qta*mta**2+sdet3ctaus*qup*vmaup*vpata/qs*mz**2*
     & mta**2+2*sdet3ctaus*qup*vmaup*vpata*mta**2)
     & +sdet4itatsus*c0upupqszupc*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*qs*us+2*stw**2*qup*vpaup*qta*us*mz**2-2*stw**2*qup*vmaup*q
     & ta*qs*ts+2*stw**2*qup*vmaup*qta*ts*mz**2+qup*vpaup*vpata*qs*mta**
     & 2-qup*vpaup*vpata*mz**2*mta**2+qup*vmaup*vpata*qs*mta**2-qup*vmau
     & p*vpata*mz**2*mta**2)
     & +sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(-2*stw**2*qup*vpa
     & up*qta*qs*us+2*stw**2*qup*vpaup*qta*us*mz**2-8*stw**2*qup*vpaup*q
     & ta*us*mta**2-2*stw**2*qup*vmaup*qta*qs*ts+2*stw**2*qup*vmaup*qta*
     & ts*mz**2-8*stw**2*qup*vmaup*qta*ts*mta**2+qup*vpaup*vpata/qs*ts*m
     & z**2*mta**2-qup*vpaup*vpata/qs*us*mz**2*mta**2+qup*vpaup*vpata*ts
     & *mta**2-qup*vpaup*vpata*us*mta**2+4*qup*vpaup*vpata*mta**4-qup*vm
     & aup*vpata/qs*ts*mz**2*mta**2+qup*vmaup*vpata/qs*us*mz**2*mta**2-q
     & up*vmaup*vpata*ts*mta**2+qup*vmaup*vpata*us*mta**2+4*qup*vmaup*vp
     & ata*mta**4-4*sdet3ctats*stw**2*qup*vmaup*qta*mta**2-2*sdet3ctats*
     & qup*vpaup*vpata/qs*mz**2*mta**2-4*sdet3ctats*qup*vpaup*vpata*mta*
     & *2-4*sdet3ctaus*stw**2*qup*vpaup*qta*mta**2-2*sdet3ctaus*qup*vmau
     & p*vpata/qs*mz**2*mta**2-4*sdet3ctaus*qup*vmaup*vpata*mta**2)
     & +sdet4itatsus*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(8*stw**2
     & *ctw**2*qup**2*qta*qs*mta**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw**2*qup*vpau
     & p*qta*mta**4-4*stw**2*qup*vmaup*qta*mta**4+2*qup*vpaup*vpata*ts*m
     & ta**2+2*qup*vmaup*vpata*ts*mta**2-8*sdet3ctats*stw**2*qup*vmaup*q
     & ta*ts+8*sdet3ctats*stw**2*qup*vmaup*qta*mta**2+2*sdet3ctats*qup*v
     & paup*vpata/qs*mz**2*mta**2+4*sdet3ctats*qup*vpaup*vpata*mta**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(-4*stw**2*qup*vpau
     & p*qta*mta**4-4*stw**2*qup*vmaup*qta*mta**4+2*qup*vpaup*vpata*us*m
     & ta**2+2*qup*vmaup*vpata*us*mta**2-8*sdet3ctaus*stw**2*qup*vpaup*q
     & ta*us+8*sdet3ctaus*stw**2*qup*vpaup*qta*mta**2+2*sdet3ctaus*qup*v
     & maup*vpata/qs*mz**2*mta**2+4*sdet3ctaus*qup*vmaup*vpata*mta**2)
     & +sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(16*stw**2*ct
     & w**2*qup**2*qta*mta**2)
     & +sdet4itatsus*b0fqszc*dreal(propizqs)*ifi*(4*stw**2*qup*vpaup*qta
     & *us+4*stw**2*qup*vmaup*qta*ts-2*qup*vpaup*vpata*mta**2-2*qup*vmau
     & p*vpata*mta**2)
     & +sdet4itatsus*b0fqscc*dreal(propizqs)*ifi*cfscheme*(-4*sdet3ctats
     & *stw**2*ctw**2*qup**2*qta-4*sdet3ctaus*stw**2*ctw**2*qup**2*qta)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*cfscheme*(-8*stw**2*ct
     & w**2*qup**2*qta*mta**2+4*sdet3ctats*stw**2*ctw**2*qup**2*qta)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(-4*stw**2*qup*vmaup*q
     & ta*ts+2*qup*vpaup*vpata*mta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*cfscheme*(-8*stw**2*ct
     & w**2*qup**2*qta*mta**2+4*sdet3ctaus*stw**2*ctw**2*qup**2*qta)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(-4*stw**2*qup*vpaup*q
     & ta*us+2*qup*vmaup*vpata*mta**2)
     & +javqstsuptaz*ifi*(4*sdet3ctats*stw**2*qup*vpaup*qta-4*sdet3ctats
     & *stw**2*qup*vmaup*qta)
     & +javqstsuptaz*dreal(propizqs)*ifi*(2*stw**2*qup*vpaup*qta/qs*mta*
     & *2+2*stw**2*qup*vmaup*qta/qs*mta**2+qup*vpaup*vpata/qs*mta**2+qup
     & *vmaup*vpata/qs*mta**2)
     & +javqsusuptaz*ifi*(-4*sdet3ctaus*stw**2*qup*vpaup*qta+4*sdet3ctau
     & s*stw**2*qup*vmaup*qta)
     & +javqsusuptaz*dreal(propizqs)*ifi*(2*stw**2*qup*vpaup*qta/qs*mta*
     & *2+2*stw**2*qup*vmaup*qta/qs*mta**2+qup*vpaup*vpata/qs*mta**2+qup
     & *vmaup*vpata/qs*mta**2)
     & +c0irupupqs*isr*(-2*stw**2*qup**2*qs)
     & +c0iruptats*ifi*(-4*sdet3ctats*stw**2*qup*vpaup*qta+4*sdet3ctats*
     & stw**2*qup*vmaup*qta)
     & +c0iruptaus*ifi*(4*sdet3ctaus*stw**2*qup*vpaup*qta-4*sdet3ctaus*s
     & tw**2*qup*vmaup*qta)
     & +c0irtataqs*fsr*(-2*stw**2*qta**2*qs-4*stw**2*qta**2*mta**2)
     & +c0ctatsczta*ifi*(4*sdet3ctats*stw**2*qup*vpaup*qta-4*sdet3ctats*
     & stw**2*qup*vmaup*qta)
     & +c0ctausczta*ifi*(-4*sdet3ctaus*stw**2*qup*vpaup*qta+4*sdet3ctaus
     & *stw**2*qup*vmaup*qta)
     & +a0fup*isr*(-3*stw**2*qup**2)
     & +a0fta*fsr*(-3*stw**2*qta**2)
     & +b0fqstata*fsr*(-3*stw**2*qta**2)
     & +b0fqscc*isr*(-3*stw**2*qup**2)
     & +lnlaupm*isr*(2*stw**2*qup**2)
     & +lnlatam*fsr*(2*stw**2*qta**2)

      ff_qed_qq =
     & +isr*(-stw**2*qup**2)
     & +fsr*(-stw**2*qta**2)
     & +prop1zqs*c0irupupqs*isr*cfscheme*(2*stw**2*qup**2-2*qup**2)
     & +prop1zqs*c0irtaupts*ifi*cfscheme*(-4*sdet3ctats*ctw**2*qup*qta/q
     & s)
     & +prop1zqs*c0irtaupus*ifi*cfscheme*(4*sdet3ctaus*ctw**2*qup*qta/qs
     & )
     & +prop1zqs*c0irtataqs*fsr*cfscheme*(4*stw**2*qta**2/qs*mta**2+2*st
     & w**2*qta**2-4*qta**2/qs*mta**2-2*qta**2)
     & +prop1zqs*lnlaupm*isr*cfscheme*(-2*stw**2*qup**2/qs+2*qup**2/qs)
     & +prop1zqs*lnlatam*fsr*cfscheme*(-2*stw**2*qta**2/qs+2*qta**2/qs)
     & +det3itataqs*fsr*(-1d0/2*qta*qs*mta**2)
     & +det3itataqs*a0fta*fsr*(1d0/2*qta*qs*mta**2)
     & +det3itataqs*b0fqstata*fsr*(1d0/2*qta*qs*mta**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(4*stw*
     & *2*qup*qta*ts*mz**2*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(
     & 4*ctw**2*qup*qta*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*cfscheme*(
     & -4*ctw**2*qup*qta*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(-8*stw**2
     & *qup*qta*ts*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-2*qup*vp
     & ata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(
     & -4*ctw**2*qup*qta*us*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-2*qup*vp
     & ata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*cfscheme*(
     & 4*ctw**2*qup*qta*us*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(4*qup*vpa
     & ta*mta**4)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*ifi*(-2*qup*vpata/qs*mz*
     & *2*mta**2)
     & +sdet4itatsus**2*jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(-sdet3
     & ctats**3*ctw**2*qup*qta*ts+sdet3ctats**3*ctw**2*qup*qta*mta**2)
     & +sdet4itatsus**2*jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(sdet3c
     & taus**3*ctw**2*qup*qta*ts-sdet3ctaus**3*ctw**2*qup*qta*mta**2)
     & +sdet4itatsus**2*javqstsuptaz*dreal(propizqs)*ifi*(-2*sdet3ctats*
     & stw**2*qup*qta*qs*ts*mta**2+2*sdet3ctats*stw**2*qup*qta*qs*ts**2-
     & 2*sdet3ctats*stw**2*qup*qta*ts*mz**2*mta**2+2*sdet3ctats*stw**2*q
     & up*qta*ts**2*mz**2)
     & +sdet4itatsus**2*javqsusuptaz*dreal(propizqs)*ifi*(-sdet3ctaus*qu
     & p*vpata*qs*us*mta**2+sdet3ctaus*qup*vpata*qs*mta**4-sdet3ctaus*qu
     & p*vpata*us*mz**2*mta**2+sdet3ctaus*qup*vpata*mz**2*mta**4)
     & +sdet4itatsus**2*c0upupqszupc*dreal(propizqs)*ifi*(-2*sdet3ctats*
     & *2*stw**2*qup*qta*qs*ts+2*sdet3ctats**2*stw**2*qup*qta*qs*mta**2-
     & 2*sdet3ctats**2*stw**2*qup*qta*ts*mz**2+2*sdet3ctats**2*stw**2*qu
     & p*qta*mz**2*mta**2-sdet3ctaus*qup*vpata*qs*ts*mta**2+sdet3ctaus*q
     & up*vpata*qs*us*mta**2-sdet3ctaus*qup*vpata*ts*mz**2*mta**2+sdet3c
     & taus*qup*vpata*us*mz**2*mta**2)
     & +sdet4itatsus**2*c0upupqscupc*dreal(propizqs)*ifi*cfscheme*(-ctw*
     & *2*qup*qta*qs**2*ts*us-ctw**2*qup*qta*qs**2*ts*mta**2+ctw**2*qup*
     & qta*qs**2*ts**2+ctw**2*qup*qta*qs**2*us*mta**2)
     & +sdet4itatsus**2*c0tataqsztac*dreal(propizqs)*ifi*(4*sdet3ctats*s
     & tw**2*qup*qta*qs*ts*mta**2-2*sdet3ctats*stw**2*qup*qta*qs*ts**2-2
     & *sdet3ctats*stw**2*qup*qta*qs*mta**4+4*sdet3ctats*stw**2*qup*qta*
     & ts*mz**2*mta**2-2*sdet3ctats*stw**2*qup*qta*ts**2*mz**2-2*sdet3ct
     & ats*stw**2*qup*qta*mz**2*mta**4+sdet3ctaus*qup*vpata*qs*ts*mta**2
     & +sdet3ctaus*qup*vpata*qs*us*mta**2-2*sdet3ctaus*qup*vpata*qs*mta*
     & *4+sdet3ctaus*qup*vpata*ts*mz**2*mta**2+sdet3ctaus*qup*vpata*us*m
     & z**2*mta**2-2*sdet3ctaus*qup*vpata*mz**2*mta**4)
     & +sdet4itatsus**2*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(-4*ct
     & w**2*qup*qta*qs*ts*us*mta**2-4*ctw**2*qup*qta*qs*ts*mta**4+4*ctw*
     & *2*qup*qta*qs*ts**2*mta**2+4*ctw**2*qup*qta*qs*us*mta**4-ctw**2*q
     & up*qta*qs**2*ts*us-ctw**2*qup*qta*qs**2*ts*mta**2+ctw**2*qup*qta*
     & qs**2*ts**2+ctw**2*qup*qta*qs**2*us*mta**2+8*sdet3ctats*ctw**2*qu
     & p*qta*qs*mta**4+2*sdet3ctats*ctw**2*qup*qta*qs**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*ifi*(-4*sdet3ctats*s
     & tw**2*qup*qta*qs*ts*mta**2+4*sdet3ctats*stw**2*qup*qta*qs*ts**2-4
     & *sdet3ctats*stw**2*qup*qta*ts*mz**2*mta**2+4*sdet3ctats*stw**2*qu
     & p*qta*ts**2*mz**2)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*ifi*(-2*sdet3ctaus*q
     & up*vpata*qs*us*mta**2+2*sdet3ctaus*qup*vpata*qs*mta**4-2*sdet3cta
     & us*qup*vpata*us*mz**2*mta**2+2*sdet3ctaus*qup*vpata*mz**2*mta**4)
     & 
     & +sdet4itatsus*jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(sdet3ctat
     & s*ctw**2*qup*qta*ts)
     & +sdet4itatsus*jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(-sdet3cta
     & us*ctw**2*qup*qta*us)
     & +sdet4itatsus*javqstsuptaz*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & mta**4-qup*vpata*ts*mta**2-2*sdet3ctats*stw**2*qup*qta/qs*mz**2*m
     & ta**2+4*sdet3ctats*stw**2*qup*qta*ts-4*sdet3ctats*stw**2*qup*qta*
     & mta**2)
     & +sdet4itatsus*javqsusuptaz*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & mta**4-qup*vpata*us*mta**2-sdet3ctaus*qup*vpata/qs*mz**2*mta**2-2
     & *sdet3ctaus*qup*vpata*mta**2)
     & +sdet4itatsus*c0upupqszupc*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & qs*ts-2*stw**2*qup*qta*ts*mz**2-qup*vpata*qs*mta**2+qup*vpata*mz*
     & *2*mta**2)
     & +sdet4itatsus*c0upupqscupc*dreal(propizqs)*ifi*cfscheme*(ctw**2*q
     & up*qta*qs*ts-ctw**2*qup*qta*qs*us)
     & +sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(2*stw**2*qup*qta*
     & qs*ts-2*stw**2*qup*qta*ts*mz**2+8*stw**2*qup*qta*ts*mta**2+qup*vp
     & ata/qs*ts*mz**2*mta**2-qup*vpata/qs*us*mz**2*mta**2+qup*vpata*ts*
     & mta**2-qup*vpata*us*mta**2-4*qup*vpata*mta**4+4*sdet3ctats*stw**2
     & *qup*qta*mta**2+2*sdet3ctaus*qup*vpata/qs*mz**2*mta**2+4*sdet3cta
     & us*qup*vpata*mta**2)
     & +sdet4itatsus*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(ctw**2*q
     & up*qta*qs*ts-ctw**2*qup*qta*qs*us+2*ctw**2*qup*qta*qs*mta**2+4*ct
     & w**2*qup*qta*ts*mta**2-4*ctw**2*qup*qta*us*mta**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(4*stw**2*qup*qta*m
     & ta**4-2*qup*vpata*ts*mta**2+8*sdet3ctats*stw**2*qup*qta*ts-8*sdet
     & 3ctats*stw**2*qup*qta*mta**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(4*stw**2*qup*qta*m
     & ta**4-2*qup*vpata*us*mta**2-2*sdet3ctaus*qup*vpata/qs*mz**2*mta**
     & 2-4*sdet3ctaus*qup*vpata*mta**2)
     & +sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(4*ctw**2*qup
     & *qta*mta**2)
     & +sdet4itatsus*b0fqszc*dreal(propizqs)*ifi*(-4*stw**2*qup*qta*ts+2
     & *qup*vpata*mta**2)
     & +sdet4itatsus*b0fqscc*dreal(propizqs)*ifi*cfscheme*(-2*sdet3ctats
     & *ctw**2*qup*qta)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*cfscheme*(-2*ctw**2*qu
     & p*qta*mta**2+2*sdet3ctats*ctw**2*qup*qta)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(4*stw**2*qup*qta*ts)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*cfscheme*(-2*ctw**2*qu
     & p*qta*mta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(-2*qup*vpata*mta**2)
     & +jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(2*sdet3ctats*ctw**2*qu
     & p*qta/qs)
     & +jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(-2*sdet3ctaus*ctw**2*q
     & up*qta/qs)
     & +javqstsuptaz*ifi*(4*sdet3ctats*stw**2*qup*qta)
     & +javqstsuptaz*dreal(propizqs)*ifi*(-2*stw**2*qup*qta/qs*mta**2-qu
     & p*vpata/qs*mta**2)
     & +javqsusuptaz*ifi*(-4*sdet3ctaus*stw**2*qup*qta)
     & +javqsusuptaz*dreal(propizqs)*ifi*(-2*stw**2*qup*qta/qs*mta**2-qu
     & p*vpata/qs*mta**2)
     & +c0irupupqs*isr*(-2*stw**2*qup**2*qs)
     & +c0iruptats*ifi*(-4*sdet3ctats*stw**2*qup*qta)
     & +c0iruptaus*ifi*(4*sdet3ctaus*stw**2*qup*qta)
     & +c0irtataqs*fsr*(-2*stw**2*qta**2*qs-4*stw**2*qta**2*mta**2)
     & +c0ctatsczta*ifi*(4*sdet3ctats*stw**2*qup*qta)
     & +c0ctausczta*ifi*(-4*sdet3ctaus*stw**2*qup*qta)
     & +a0fup*isr*(-3*stw**2*qup**2)
     & +a0fup*dreal(propizqs)*isr*cfscheme*(3*stw**2*qup**2/qs-3*qup**2/
     & qs)
     & +a0fta*fsr*(-3*stw**2*qta**2)
     & +a0fta*dreal(propizqs)*fsr*cfscheme*(3*stw**2*qta**2/qs-3*qta**2/
     & qs)
     & +b0fqstata*fsr*(-3*stw**2*qta**2)
     & +b0fqstata*dreal(propizqs)*fsr*cfscheme*(3*stw**2*qta**2/qs-3*qta
     & **2/qs)
     & +b0fqscc*isr*(-3*stw**2*qup**2)
     & +b0fqscc*dreal(propizqs)*isr*cfscheme*(3*stw**2*qup**2/qs-3*qup**
     & 2/qs)
     & +lnlaupm*isr*(2*stw**2*qup**2)
     & +lnlatam*fsr*(2*stw**2*qta**2)
     & +dreal(propizqs)*isr*cfscheme*(stw**2*qup**2/qs-qup**2/qs)
     & +dreal(propizqs)*fsr*cfscheme*(stw**2*qta**2/qs-qta**2/qs)

      ff_qed_ld =
     & +det3itataqs*fsr*(stw**2*qta**2*vpata*qs+1d0/2*stw**2*qta**2*qs)
     & +det3itataqs*sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(-stw*
     & *2*qup*vpaup*qta*vpata*qs*ts*mz**2+4*stw**2*qup*vpaup*qta*vpata*q
     & s*ts*mta**2+stw**2*qup*vpaup*qta*vpata*qs*mz**2*mta**2-4*stw**2*q
     & up*vpaup*qta*vpata*qs*mta**4+stw**2*qup*vpaup*qta*vmata*qs*us*mz*
     & *2-4*stw**2*qup*vpaup*qta*vmata*qs*us*mta**2-stw**2*qup*vpaup*qta
     & *vmata*qs*mz**2*mta**2+4*stw**2*qup*vpaup*qta*vmata*qs*mta**4-stw
     & **2*qup*vmaup*qta*vpata*qs*us*mz**2+4*stw**2*qup*vmaup*qta*vpata*
     & qs*us*mta**2+stw**2*qup*vmaup*qta*vpata*qs*mz**2*mta**2-4*stw**2*
     & qup*vmaup*qta*vpata*qs*mta**4+stw**2*qup*vmaup*qta*vmata*qs*ts*mz
     & **2-4*stw**2*qup*vmaup*qta*vmata*qs*ts*mta**2-stw**2*qup*vmaup*qt
     & a*vmata*qs*mz**2*mta**2+4*stw**2*qup*vmaup*qta*vmata*qs*mta**4)
     & +det3itataqs*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(stw**2*qu
     & p*vpaup*qta*vpata*qs*ts-stw**2*qup*vpaup*qta*vpata*qs*mta**2-stw*
     & *2*qup*vpaup*qta*vmata*qs*us+stw**2*qup*vpaup*qta*vmata*qs*mta**2
     & +stw**2*qup*vmaup*qta*vpata*qs*us-stw**2*qup*vmaup*qta*vpata*qs*m
     & ta**2-stw**2*qup*vmaup*qta*vmata*qs*ts+stw**2*qup*vmaup*qta*vmata
     & *qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(stw**2*qu
     & p*vpaup*qta*vpata*qs*ts-stw**2*qup*vpaup*qta*vpata*qs*mta**2-stw*
     & *2*qup*vpaup*qta*vmata*qs*us+stw**2*qup*vpaup*qta*vmata*qs*mta**2
     & +stw**2*qup*vmaup*qta*vpata*qs*us-stw**2*qup*vmaup*qta*vpata*qs*m
     & ta**2-stw**2*qup*vmaup*qta*vmata*qs*ts+stw**2*qup*vmaup*qta*vmata
     & *qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0fqszc*dreal(propizqs)*ifi*(-2*stw**2*
     & qup*vpaup*qta*vpata*qs*ts+2*stw**2*qup*vpaup*qta*vpata*qs*mta**2+
     & 2*stw**2*qup*vpaup*qta*vmata*qs*us-2*stw**2*qup*vpaup*qta*vmata*q
     & s*mta**2-2*stw**2*qup*vmaup*qta*vpata*qs*us+2*stw**2*qup*vmaup*qt
     & a*vpata*qs*mta**2+2*stw**2*qup*vmaup*qta*vmata*qs*ts-2*stw**2*qup
     & *vmaup*qta*vmata*qs*mta**2)
     & +det3itataqs*a0fta*fsr*(-stw**2*qta**2*vpata*qs-1d0/2*stw**2*qta*
     & *2*qs)
     & +det3itataqs*b0fqstata*fsr*(-stw**2*qta**2*vpata*qs-1d0/2*stw**2*
     & qta**2*qs)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw
     & **2*qup*vpaup*qta*vpata*ts*mz**2+4*stw**2*qup*vmaup*qta*vmata*ts*
     & mz**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*vpata*ts+4*stw**2*qup*vmaup*qta*vmata*ts)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*vpaup*qta*vpata*ts+4*stw**2*qup*vmaup*qta*vmata*ts)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(8*stw**2*
     & qup*vpaup*qta*vpata*ts-8*stw**2*qup*vmaup*qta*vmata*ts)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(4*stw*
     & *2*qup*vpaup*qta*vmata*us*mz**2-4*stw**2*qup*vmaup*qta*vpata*us*m
     & z**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(4*stw**2*
     & qup*vpaup*qta*vmata*us-4*stw**2*qup*vmaup*qta*vpata*us)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(4*stw**2*
     & qup*vpaup*qta*vmata*us-4*stw**2*qup*vmaup*qta*vpata*us)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(-8*stw**2
     & *qup*vpaup*qta*vmata*us+8*stw**2*qup*vmaup*qta*vpata*us)
     & +sdet4itatsus**2*javqstsuptaz*dreal(propizqs)*ifi*(4*sdet3ctats*s
     & tw**2*qup*vpaup*qta*vpata*qs*ts+4*sdet3ctats*stw**2*qup*vpaup*qta
     & *vpata*ts*mz**2-4*sdet3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts-4*s
     & det3ctats*stw**2*qup*vmaup*qta*vmata*ts*mz**2)
     & +sdet4itatsus**2*javqsusuptaz*dreal(propizqs)*ifi*(-4*sdet3ctaus*
     & stw**2*qup*vpaup*qta*vmata*qs*us-4*sdet3ctaus*stw**2*qup*vpaup*qt
     & a*vmata*us*mz**2+4*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us+4*
     & sdet3ctaus*stw**2*qup*vmaup*qta*vpata*us*mz**2)
     & +sdet4itatsus**2*c0upupqszupc*dreal(propizqs)*ifi*(-4*sdet3ctats*
     & *2*stw**2*qup*vpaup*qta*vpata*qs-4*sdet3ctats**2*stw**2*qup*vpaup
     & *qta*vpata*mz**2+4*sdet3ctats**2*stw**2*qup*vmaup*qta*vmata*qs+4*
     & sdet3ctats**2*stw**2*qup*vmaup*qta*vmata*mz**2+4*sdet3ctaus**2*st
     & w**2*qup*vpaup*qta*vmata*qs+4*sdet3ctaus**2*stw**2*qup*vpaup*qta*
     & vmata*mz**2-4*sdet3ctaus**2*stw**2*qup*vmaup*qta*vpata*qs-4*sdet3
     & ctaus**2*stw**2*qup*vmaup*qta*vpata*mz**2)
     & +sdet4itatsus**2*c0tataqsztac*dreal(propizqs)*ifi*(-4*sdet3ctats*
     & stw**2*qup*vpaup*qta*vpata*qs*ts+4*sdet3ctats*stw**2*qup*vpaup*qt
     & a*vpata*qs*mta**2-4*sdet3ctats*stw**2*qup*vpaup*qta*vpata*ts*mz**
     & 2+4*sdet3ctats*stw**2*qup*vpaup*qta*vpata*mz**2*mta**2+4*sdet3cta
     & ts*stw**2*qup*vmaup*qta*vmata*qs*ts-4*sdet3ctats*stw**2*qup*vmaup
     & *qta*vmata*qs*mta**2+4*sdet3ctats*stw**2*qup*vmaup*qta*vmata*ts*m
     & z**2-4*sdet3ctats*stw**2*qup*vmaup*qta*vmata*mz**2*mta**2+4*sdet3
     & ctaus*stw**2*qup*vpaup*qta*vmata*qs*us-4*sdet3ctaus*stw**2*qup*vp
     & aup*qta*vmata*qs*mta**2+4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*u
     & s*mz**2-4*sdet3ctaus*stw**2*qup*vpaup*qta*vmata*mz**2*mta**2-4*sd
     & et3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us+4*sdet3ctaus*stw**2*qup
     & *vmaup*qta*vpata*qs*mta**2-4*sdet3ctaus*stw**2*qup*vmaup*qta*vpat
     & a*us*mz**2+4*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*mz**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*ifi*(8*sdet3ctats*st
     & w**2*qup*vpaup*qta*vpata*qs*ts+8*sdet3ctats*stw**2*qup*vpaup*qta*
     & vpata*ts*mz**2-8*sdet3ctats*stw**2*qup*vmaup*qta*vmata*qs*ts-8*sd
     & et3ctats*stw**2*qup*vmaup*qta*vmata*ts*mz**2)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*ifi*(-8*sdet3ctaus*s
     & tw**2*qup*vpaup*qta*vmata*qs*us-8*sdet3ctaus*stw**2*qup*vpaup*qta
     & *vmata*us*mz**2+8*sdet3ctaus*stw**2*qup*vmaup*qta*vpata*qs*us+8*s
     & det3ctaus*stw**2*qup*vmaup*qta*vpata*us*mz**2)
     & +sdet4itatsus*javqstsuptaz*dreal(propizqs)*ifi*(2*sdet3ctats*stw*
     & *2*qup*vpaup*qta*vpata/qs*mz**2+4*sdet3ctats*stw**2*qup*vpaup*qta
     & *vpata-2*sdet3ctats*stw**2*qup*vmaup*qta*vmata/qs*mz**2-4*sdet3ct
     & ats*stw**2*qup*vmaup*qta*vmata-2*sdet3ctats**2*stw**2*qup*vpaup*q
     & ta*vpata/qs+2*sdet3ctats**2*stw**2*qup*vpaup*qta*vmata/qs-2*sdet3
     & ctats**2*stw**2*qup*vmaup*qta*vpata/qs+2*sdet3ctats**2*stw**2*qup
     & *vmaup*qta*vmata/qs)
     & +sdet4itatsus*javqsusuptaz*dreal(propizqs)*ifi*(-2*sdet3ctaus*stw
     & **2*qup*vpaup*qta*vmata/qs*mz**2-4*sdet3ctaus*stw**2*qup*vpaup*qt
     & a*vmata+2*sdet3ctaus*stw**2*qup*vmaup*qta*vpata/qs*mz**2+4*sdet3c
     & taus*stw**2*qup*vmaup*qta*vpata-2*sdet3ctaus**2*stw**2*qup*vpaup*
     & qta*vpata/qs+2*sdet3ctaus**2*stw**2*qup*vpaup*qta*vmata/qs-2*sdet
     & 3ctaus**2*stw**2*qup*vmaup*qta*vpata/qs+2*sdet3ctaus**2*stw**2*qu
     & p*vmaup*qta*vmata/qs)
     & +sdet4itatsus*c0upupqszupc*dreal(propizqs)*ifi*(2*stw**2*qup*vpau
     & p*qta*vpata*qs-2*stw**2*qup*vpaup*qta*vpata*mz**2-2*stw**2*qup*vp
     & aup*qta*vmata*qs+2*stw**2*qup*vpaup*qta*vmata*mz**2+2*stw**2*qup*
     & vmaup*qta*vpata*qs-2*stw**2*qup*vmaup*qta*vpata*mz**2-2*stw**2*qu
     & p*vmaup*qta*vmata*qs+2*stw**2*qup*vmaup*qta*vmata*mz**2)
     & +sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(2*stw**2*qup*vpau
     & p*qta*vpata*qs+2*stw**2*qup*vpaup*qta*vpata*mz**2-2*stw**2*qup*vp
     & aup*qta*vmata*qs-2*stw**2*qup*vpaup*qta*vmata*mz**2+2*stw**2*qup*
     & vmaup*qta*vpata*qs+2*stw**2*qup*vmaup*qta*vpata*mz**2-2*stw**2*qu
     & p*vmaup*qta*vmata*qs-2*stw**2*qup*vmaup*qta*vmata*mz**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(4*stw**2*qup*vpaup
     & *qta*vpata*ts-4*stw**2*qup*vpaup*qta*vmata*ts+4*stw**2*qup*vmaup*
     & qta*vpata*ts-4*stw**2*qup*vmaup*qta*vmata*ts+8*sdet3ctats*stw**2*
     & qup*vpaup*qta*vpata-8*sdet3ctats*stw**2*qup*vmaup*qta*vmata)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(4*stw**2*qup*vpaup
     & *qta*vpata*us-4*stw**2*qup*vpaup*qta*vmata*us+4*stw**2*qup*vmaup*
     & qta*vpata*us-4*stw**2*qup*vmaup*qta*vmata*us-8*sdet3ctaus*stw**2*
     & qup*vpaup*qta*vmata+8*sdet3ctaus*stw**2*qup*vmaup*qta*vpata)

      ff_qed_qd =
     & +det3itataqs*fsr*(stw**2*qta**2*vpata*qs+1d0/2*stw**2*qta**2*qs)
     & +det3itataqs*sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(stw**
     & 2*qup*qta*vpata*qs*us*mz**2-4*stw**2*qup*qta*vpata*qs*us*mta**2-s
     & tw**2*qup*qta*vpata*qs*mz**2*mta**2+4*stw**2*qup*qta*vpata*qs*mta
     & **4-stw**2*qup*qta*vmata*qs*ts*mz**2+4*stw**2*qup*qta*vmata*qs*ts
     & *mta**2+stw**2*qup*qta*vmata*qs*mz**2*mta**2-4*stw**2*qup*qta*vma
     & ta*qs*mta**4)
     & +det3itataqs*sdet4itatsus*c0tataqsctac*dreal(propizqs)*ifi*cfsche
     & me*(-4*stw**2*ctw**2*qup*qta**2*qs*ts*mta**2+4*stw**2*ctw**2*qup*
     & qta**2*qs*us*mta**2)
     & +det3itataqs*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-stw**2*q
     & up*qta*vpata*qs*us+stw**2*qup*qta*vpata*qs*mta**2+stw**2*qup*qta*
     & vmata*qs*ts-stw**2*qup*qta*vmata*qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(
     & -2*stw**2*ctw**2*qup*qta**2*qs*ts+2*stw**2*ctw**2*qup*qta**2*qs*u
     & s)
     & +det3itataqs*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-stw**2*q
     & up*qta*vpata*qs*us+stw**2*qup*qta*vpata*qs*mta**2+stw**2*qup*qta*
     & vmata*qs*ts-stw**2*qup*qta*vmata*qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0fqszc*dreal(propizqs)*ifi*(2*stw**2*q
     & up*qta*vpata*qs*us-2*stw**2*qup*qta*vpata*qs*mta**2-2*stw**2*qup*
     & qta*vmata*qs*ts+2*stw**2*qup*qta*vmata*qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0fqscc*dreal(propizqs)*ifi*cfscheme*(2
     & *stw**2*ctw**2*qup*qta**2*qs*ts-2*stw**2*ctw**2*qup*qta**2*qs*us)
     & 
     & +det3itataqs*a0fta*fsr*(-stw**2*qta**2*vpata*qs-1d0/2*stw**2*qta*
     & *2*qs)
     & +det3itataqs*a0fta*dreal(propizqs)*fsr*cfscheme*(2*stw**2*ctw**2*
     & qta**3)
     & +det3itataqs*b0fqstata*fsr*(-stw**2*qta**2*vpata*qs-1d0/2*stw**2*
     & qta**2*qs)
     & +det3itataqs*b0fqstata*dreal(propizqs)*fsr*cfscheme*(2*stw**2*ctw
     & **2*qta**3)
     & +det3itataqs*dreal(propizqs)*fsr*cfscheme*(-2*stw**2*ctw**2*qta**
     & 3)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw
     & **2*qup*qta*vmata*ts*mz**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*qta*vmata*ts)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(
     & 8*stw**2*ctw**2*qup*qta**2*ts)
     & +sdet3ictats*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(-4*stw**2
     & *qup*qta*vmata*ts)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*cfscheme*(
     & -8*stw**2*ctw**2*qup*qta**2*ts)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*ifi*(8*stw**2*
     & qup*qta*vmata*ts)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(4*stw*
     & *2*qup*qta*vpata*us*mz**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*vpata*us)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*cfscheme*(
     & -8*stw**2*ctw**2*qup*qta**2*us)
     & +sdet3ictaus*sdet4itatsus*b0ftatac*dreal(propizqs)*ifi*(4*stw**2*
     & qup*qta*vpata*us)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*cfscheme*(
     & 8*stw**2*ctw**2*qup*qta**2*us)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*ifi*(-8*stw**2
     & *qup*qta*vpata*us)
     & +sdet4itatsus**2*jaaqstsupta*dreal(propizqs)*ifi*cfscheme*(4*sdet
     & 3ctats**3*stw**2*ctw**2*qup*qta**2)
     & +sdet4itatsus**2*jaaqsusupta*dreal(propizqs)*ifi*cfscheme*(-4*sde
     & t3ctaus**3*stw**2*ctw**2*qup*qta**2)
     & +sdet4itatsus**2*javqstsuptaz*dreal(propizqs)*ifi*(4*sdet3ctats*s
     & tw**2*qup*qta*vmata*qs*ts+4*sdet3ctats*stw**2*qup*qta*vmata*ts*mz
     & **2)
     & +sdet4itatsus**2*javqsusuptaz*dreal(propizqs)*ifi*(-4*sdet3ctaus*
     & stw**2*qup*qta*vpata*qs*us-4*sdet3ctaus*stw**2*qup*qta*vpata*us*m
     & z**2)
     & +sdet4itatsus**2*c0upupqszupc*dreal(propizqs)*ifi*(-4*sdet3ctats*
     & *2*stw**2*qup*qta*vmata*qs-4*sdet3ctats**2*stw**2*qup*qta*vmata*m
     & z**2+4*sdet3ctaus**2*stw**2*qup*qta*vpata*qs+4*sdet3ctaus**2*stw*
     & *2*qup*qta*vpata*mz**2)
     & +sdet4itatsus**2*c0upupqscupc*dreal(propizqs)*ifi*cfscheme*(-4*st
     & w**2*ctw**2*qup*qta**2*qs**2*ts+4*stw**2*ctw**2*qup*qta**2*qs**2*
     & us)
     & +sdet4itatsus**2*c0tataqsztac*dreal(propizqs)*ifi*(-4*sdet3ctats*
     & stw**2*qup*qta*vmata*qs*ts+4*sdet3ctats*stw**2*qup*qta*vmata*qs*m
     & ta**2-4*sdet3ctats*stw**2*qup*qta*vmata*ts*mz**2+4*sdet3ctats*stw
     & **2*qup*qta*vmata*mz**2*mta**2+4*sdet3ctaus*stw**2*qup*qta*vpata*
     & qs*us-4*sdet3ctaus*stw**2*qup*qta*vpata*qs*mta**2+4*sdet3ctaus*st
     & w**2*qup*qta*vpata*us*mz**2-4*sdet3ctaus*stw**2*qup*qta*vpata*mz*
     & *2*mta**2)
     & +sdet4itatsus**2*c0tataqsctac*dreal(propizqs)*ifi*cfscheme*(-8*st
     & w**2*ctw**2*qup*qta**2*qs*ts*mta**2+8*stw**2*ctw**2*qup*qta**2*qs
     & *us*mta**2-4*stw**2*ctw**2*qup*qta**2*qs**2*ts+4*stw**2*ctw**2*qu
     & p*qta**2*qs**2*us)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*ifi*(8*sdet3ctats*st
     & w**2*qup*qta*vmata*qs*ts+8*sdet3ctats*stw**2*qup*qta*vmata*ts*mz*
     & *2)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*ifi*(-8*sdet3ctaus*s
     & tw**2*qup*qta*vpata*qs*us-8*sdet3ctaus*stw**2*qup*qta*vpata*us*mz
     & **2)
     & +sdet4itatsus*javqstsuptaz*dreal(propizqs)*ifi*(2*sdet3ctats*stw*
     & *2*qup*qta*vmata/qs*mz**2+4*sdet3ctats*stw**2*qup*qta*vmata+2*sde
     & t3ctats**2*stw**2*qup*qta*vpata/qs-2*sdet3ctats**2*stw**2*qup*qta
     & *vmata/qs)
     & +sdet4itatsus*javqsusuptaz*dreal(propizqs)*ifi*(-2*sdet3ctaus*stw
     & **2*qup*qta*vpata/qs*mz**2-4*sdet3ctaus*stw**2*qup*qta*vpata+2*sd
     & et3ctaus**2*stw**2*qup*qta*vpata/qs-2*sdet3ctaus**2*stw**2*qup*qt
     & a*vmata/qs)
     & +sdet4itatsus*c0upupqszupc*dreal(propizqs)*ifi*(-2*stw**2*qup*qta
     & *vpata*qs+2*stw**2*qup*qta*vpata*mz**2+2*stw**2*qup*qta*vmata*qs-
     & 2*stw**2*qup*qta*vmata*mz**2)
     & +sdet4itatsus*c0tataqsztac*dreal(propizqs)*ifi*(-2*stw**2*qup*qta
     & *vpata*qs-2*stw**2*qup*qta*vpata*mz**2+2*stw**2*qup*qta*vmata*qs+
     & 2*stw**2*qup*qta*vmata*mz**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*ifi*(-4*stw**2*qup*qta*
     & vpata*ts+4*stw**2*qup*qta*vmata*ts+8*sdet3ctats*stw**2*qup*qta*vm
     & ata)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*ifi*(-4*stw**2*qup*qta*
     & vpata*us+4*stw**2*qup*qta*vmata*us-8*sdet3ctaus*stw**2*qup*qta*vp
     & ata)

      ff_ew_ll =
     & +sdet3itataqs*c0tataqswcw*dreal(propizqs)*(-7d0/2*mw**2*rtaw*rwz+
     & 3*mw**2*rtaw**2*rwz+1d0/2*mw**2*rtaw**3*rwz)
     & +sdet3itataqs*c0tataqswcw*(11*mw**4*rtaw*rwz-26*mw**4*rtaw**2*rwz
     & +11*mw**4*rtaw**3*rwz+2*mw**4*rtaw**4*rwz+2*mw**4*rwz)
     & +sdet3itataqs*c0tataqsztah*(-3d0/4*mw**4*rtaw/rwz**2-1d0/2*mw**4*
     & rtaw/rwz*rhw+1d0/4*mw**4*rtaw*rhw**2+2*mw**4*rtaw**2/rwz-2*mw**4*
     & rtaw**2*rhw+4*mw**4*rtaw**3)
     & +sdet3itataqs*c0tataqstazta*(-55d0/4*mw**4*rtaw/rwz**2+36*mw**4*r
     & taw/rwz-24*mw**4*rtaw-7d0/2*mw**4/rwz**3+9*mw**4/rwz**2-6*mw**4/r
     & wz)
     & +sdet3itataqs*c0tataqstahta*(1d0/4*mw**4*rtaw*rhw**2-2*mw**4*rtaw
     & **2*rhw)
     & +sdet3itataqs*c0tataqscwc*(11d0/2*mw**4*rtaw+6*mw**4*rtaw**2+3d0/
     & 2*mw**4*rtaw**3+mw**4)
     & +sdet3itataqs*b0ftawc*dreal(propizqs)*(2*rtaw*rwz)
     & +sdet3itataqs*b0ftawc*(-13*mw**2*rtaw*rwz+6*mw**2*rtaw+7*mw**2*rt
     & aw**2*rwz+2*mw**2*rtaw**2-2*mw**2*rwz+mw**2)
     & +sdet3itataqs*b0ftazta*(-13*mw**2*rtaw/rwz-24*mw**2*rtaw*rwz-1d0/
     & 4*mw**2*rtaw*rhw+36*mw**2*rtaw+mw**2*rtaw**2-7d0/2*mw**2/rwz**2+9
     & *mw**2/rwz-6*mw**2)
     & +sdet3itataqs*b0ftahta*(3d0/4*mw**2*rtaw/rwz-mw**2*rtaw**2)
     & +sdet3itataqs*b0fqsww*dreal(propizqs)*(-7d0/2*rtaw*rwz-1d0/2*rtaw
     & **2*rwz)
     & +sdet3itataqs*b0fqsww*(13*mw**2*rtaw*rwz-13*mw**2*rtaw**2*rwz-2*m
     & w**2*rtaw**3*rwz+2*mw**2*rwz)
     & +sdet3itataqs*b0fqszh*(-3d0/2*mw**2*rtaw/rwz+1d0/2*mw**2*rtaw*rhw
     & -2*mw**2*rtaw**2)
     & +sdet3itataqs*b0fqstata*(55d0/4*mw**2*rtaw/rwz+24*mw**2*rtaw*rwz-
     & 1d0/4*mw**2*rtaw*rhw-36*mw**2*rtaw+2*mw**2*rtaw**2+7d0/2*mw**2/rw
     & z**2-9*mw**2/rwz+6*mw**2)
     & +sdet3itataqs*b0fqscc*(-9d0/2*mw**2*rtaw-3d0/2*mw**2*rtaw**2-mw**
     & 2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/ctw**2*v
     & paup**2*vpata**2*ts*mta**2-1d0/ctw**2*vpaup**2*vpata**2*mta**4-1d
     & 0/ctw**2*vmaup**2*vmata**2*ts*mta**2-1d0/ctw**2*vmaup**2*vmata**2
     & *mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*(1d0/ctw**2*vp
     & aup**2*vpata**2*ts*mta**2+1d0/ctw**2*vpaup**2*vpata**2*mta**4+1d0
     & /ctw**2*vmaup**2*vmata**2*ts*mta**2+1d0/ctw**2*vmaup**2*vmata**2*
     & mta**4)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/ctw**2*v
     & paup**2*vmata**2*us*mta**2-1d0/ctw**2*vpaup**2*vmata**2*mta**4-1d
     & 0/ctw**2*vmaup**2*vpata**2*us*mta**2-1d0/ctw**2*vmaup**2*vpata**2
     & *mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*(1d0/ctw**2*vp
     & aup**2*vmata**2*us*mta**2+1d0/ctw**2*vpaup**2*vmata**2*mta**4+1d0
     & /ctw**2*vmaup**2*vpata**2*us*mta**2+1d0/ctw**2*vmaup**2*vpata**2*
     & mta**4)
     & +sdet4itatsus**2*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(1
     & d0/4/ctw**2*vpaup**2*vpata**2*ts*mta**4-1d0/4/ctw**2*vpaup**2*vpa
     & ta**2*us*mta**4+1d0/4/ctw**2*vmaup**2*vmata**2*ts*mta**4-1d0/4/ct
     & w**2*vmaup**2*vmata**2*us*mta**4+1d0/4*sdet3ctats/ctw**2*vpaup**2
     & *vpata**2*ts*mta**2-1d0/4*sdet3ctats/ctw**2*vpaup**2*vpata**2*mta
     & **4+1d0/4*sdet3ctats/ctw**2*vmaup**2*vmata**2*ts*mta**2-1d0/4*sde
     & t3ctats/ctw**2*vmaup**2*vmata**2*mta**4-1d0/4*sdet3ctats**2/ctw**
     & 2*vpaup**2*vpata**2*qs-sdet3ctats**2/ctw**2*vpaup**2*vpata**2*mta
     & **2-1d0/4*sdet3ctats**2/ctw**2*vmaup**2*vmata**2*qs-sdet3ctats**2
     & /ctw**2*vmaup**2*vmata**2*mta**2)
     & +sdet4itatsus**2*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/4/ctw**2*vpaup**2*vmata**2*ts*mta**4+1d0/4/ctw**2*vpaup**2*vm
     & ata**2*us*mta**4-1d0/4/ctw**2*vmaup**2*vpata**2*ts*mta**4+1d0/4/c
     & tw**2*vmaup**2*vpata**2*us*mta**4+1d0/4*sdet3ctaus/ctw**2*vpaup**
     & 2*vmata**2*us*mta**2-1d0/4*sdet3ctaus/ctw**2*vpaup**2*vmata**2*mt
     & a**4+1d0/4*sdet3ctaus/ctw**2*vmaup**2*vpata**2*us*mta**2-1d0/4*sd
     & et3ctaus/ctw**2*vmaup**2*vpata**2*mta**4-1d0/4*sdet3ctaus**2/ctw*
     & *2*vpaup**2*vmata**2*qs-sdet3ctaus**2/ctw**2*vpaup**2*vmata**2*mt
     & a**2-1d0/4*sdet3ctaus**2/ctw**2*vmaup**2*vpata**2*qs-sdet3ctaus**
     & 2/ctw**2*vmaup**2*vpata**2*mta**2)
     & +sdet4itatsus**2*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/4*sd
     & et3ctats/ctw**2*vpaup**2*vpata**2*qs*ts-1d0/4*sdet3ctats/ctw**2*v
     & paup**2*vpata**2*qs*mta**2-sdet3ctats/ctw**2*vpaup**2*vpata**2*ts
     & *mta**2-sdet3ctats/ctw**2*vpaup**2*vpata**2*mta**4-1d0/4*sdet3cta
     & ts/ctw**2*vmaup**2*vmata**2*qs*ts-1d0/4*sdet3ctats/ctw**2*vmaup**
     & 2*vmata**2*qs*mta**2-sdet3ctats/ctw**2*vmaup**2*vmata**2*ts*mta**
     & 2-sdet3ctats/ctw**2*vmaup**2*vmata**2*mta**4-1d0/4*sdet3ctaus/ctw
     & **2*vpaup**2*vmata**2*qs*us-1d0/4*sdet3ctaus/ctw**2*vpaup**2*vmat
     & a**2*qs*mta**2-sdet3ctaus/ctw**2*vpaup**2*vmata**2*us*mta**2-sdet
     & 3ctaus/ctw**2*vpaup**2*vmata**2*mta**4-1d0/4*sdet3ctaus/ctw**2*vm
     & aup**2*vpata**2*qs*us-1d0/4*sdet3ctaus/ctw**2*vmaup**2*vpata**2*q
     & s*mta**2-sdet3ctaus/ctw**2*vmaup**2*vpata**2*us*mta**2-sdet3ctaus
     & /ctw**2*vmaup**2*vpata**2*mta**4)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(-1d0/2*sde
     & t3ctats/ctw**2*vpaup**2*vpata**2*ts**2+1d0/2*sdet3ctats/ctw**2*vp
     & aup**2*vpata**2*mta**4-1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata**2*
     & ts**2+1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata**2*mta**4)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*pxx2zqsc*(-1d0/2*sde
     & t3ctaus/ctw**2*vpaup**2*vmata**2*us**2+1d0/2*sdet3ctaus/ctw**2*vp
     & aup**2*vmata**2*mta**4-1d0/2*sdet3ctaus/ctw**2*vmaup**2*vpata**2*
     & us**2+1d0/2*sdet3ctaus/ctw**2*vmaup**2*vpata**2*mta**4)
     & +sdet4itatsus**2*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**
     & 2*vpaup**2*vpata**2*qs*ts*mta**2+1d0/4/ctw**2*vpaup**2*vpata**2*q
     & s*mta**4-1d0/4/ctw**2*vpaup**2*vmata**2*qs*us*mta**2+1d0/4/ctw**2
     & *vpaup**2*vmata**2*qs*mta**4-1d0/4/ctw**2*vmaup**2*vpata**2*qs*us
     & *mta**2+1d0/4/ctw**2*vmaup**2*vpata**2*qs*mta**4-1d0/4/ctw**2*vma
     & up**2*vmata**2*qs*ts*mta**2+1d0/4/ctw**2*vmaup**2*vmata**2*qs*mta
     & **4+1d0/4*sdet3ctats**2/ctw**2*vpaup**2*vpata**2*ts-1d0/4*sdet3ct
     & ats**2/ctw**2*vpaup**2*vpata**2*mta**2+1d0/4*sdet3ctats**2/ctw**2
     & *vmaup**2*vmata**2*ts-1d0/4*sdet3ctats**2/ctw**2*vmaup**2*vmata**
     & 2*mta**2+1d0/4*sdet3ctaus**2/ctw**2*vpaup**2*vmata**2*us-1d0/4*sd
     & et3ctaus**2/ctw**2*vpaup**2*vmata**2*mta**2+1d0/4*sdet3ctaus**2/c
     & tw**2*vmaup**2*vpata**2*us-1d0/4*sdet3ctaus**2/ctw**2*vmaup**2*vp
     & ata**2*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(-1d0
     & /2/ctw**2*vpaup**2*vpata**2*mta**2-1d0/2/ctw**2*vmaup**2*vmata**2
     & *mta**2-1d0/8*sdet3ctats/ctw**2*vpaup**2*vpata**2-1d0/8*sdet3ctat
     & s/ctw**2*vmaup**2*vmata**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc*(1d0/2/c
     & tw**2*vpaup**2*vpata*vmata*ts*mta**2+1d0/2/ctw**2*vpaup**2*vpata*
     & vmata*mta**4+1d0/4/ctw**2*vpaup**2*vpata**2*qs*mta**2+3d0/4/ctw**
     & 2*vpaup**2*vpata**2*ts**2-3d0/4/ctw**2*vpaup**2*vpata**2*mta**4+1
     & d0/2/ctw**2*vmaup**2*vpata*vmata*ts*mta**2+1d0/2/ctw**2*vmaup**2*
     & vpata*vmata*mta**4+1d0/4/ctw**2*vmaup**2*vmata**2*qs*mta**2+3d0/4
     & /ctw**2*vmaup**2*vmata**2*ts**2-3d0/4/ctw**2*vmaup**2*vmata**2*mt
     & a**4+sdet3ctats/ctw**2*vpaup**2*vpata**2*mta**2+sdet3ctats/ctw**2
     & *vmaup**2*vmata**2*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*(-1d0/8/ctw**2*vp
     & aup**2*vpata**2*qs*ts*mta**2+1d0/8/ctw**2*vpaup**2*vpata**2*qs*us
     & *mta**2-1d0/8/ctw**2*vmaup**2*vmata**2*qs*ts*mta**2+1d0/8/ctw**2*
     & vmaup**2*vmata**2*qs*us*mta**2-1d0/8*sdet3ctats/ctw**2*vpaup**2*v
     & pata**2*qs*ts+1d0/8*sdet3ctats/ctw**2*vpaup**2*vpata**2*qs*mta**2
     & -1d0/8*sdet3ctats/ctw**2*vmaup**2*vmata**2*qs*ts+1d0/8*sdet3ctats
     & /ctw**2*vmaup**2*vmata**2*qs*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(-1d0
     & /2/ctw**2*vpaup**2*vmata**2*mta**2-1d0/2/ctw**2*vmaup**2*vpata**2
     & *mta**2-1d0/8*sdet3ctaus/ctw**2*vpaup**2*vmata**2-1d0/8*sdet3ctau
     & s/ctw**2*vmaup**2*vpata**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(1d0/2/c
     & tw**2*vpaup**2*vpata*vmata*us*mta**2+1d0/2/ctw**2*vpaup**2*vpata*
     & vmata*mta**4+1d0/4/ctw**2*vpaup**2*vmata**2*qs*mta**2+3d0/4/ctw**
     & 2*vpaup**2*vmata**2*us**2-3d0/4/ctw**2*vpaup**2*vmata**2*mta**4+1
     & d0/2/ctw**2*vmaup**2*vpata*vmata*us*mta**2+1d0/2/ctw**2*vmaup**2*
     & vpata*vmata*mta**4+1d0/4/ctw**2*vmaup**2*vpata**2*qs*mta**2+3d0/4
     & /ctw**2*vmaup**2*vpata**2*us**2-3d0/4/ctw**2*vmaup**2*vpata**2*mt
     & a**4+sdet3ctaus/ctw**2*vpaup**2*vmata**2*mta**2+sdet3ctaus/ctw**2
     & *vmaup**2*vpata**2*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*(1d0/8/ctw**2*vpa
     & up**2*vmata**2*qs*ts*mta**2-1d0/8/ctw**2*vpaup**2*vmata**2*qs*us*
     & mta**2+1d0/8/ctw**2*vmaup**2*vpata**2*qs*ts*mta**2-1d0/8/ctw**2*v
     & maup**2*vpata**2*qs*us*mta**2-1d0/8*sdet3ctaus/ctw**2*vpaup**2*vm
     & ata**2*qs*us+1d0/8*sdet3ctaus/ctw**2*vpaup**2*vmata**2*qs*mta**2-
     & 1d0/8*sdet3ctaus/ctw**2*vmaup**2*vpata**2*qs*us+1d0/8*sdet3ctaus/
     & ctw**2*vmaup**2*vpata**2*qs*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/2/ctw**
     & 2*vpaup**2*vpata**2*mta**2-1d0/2/ctw**2*vpaup**2*vmata**2*mta**2-
     & 1d0/2/ctw**2*vmaup**2*vpata**2*mta**2-1d0/2/ctw**2*vmaup**2*vmata
     & **2*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2
     & *vpata**2*ts**2-1d0/2/ctw**2*vpaup**2*vpata**2*mta**4+1d0/2/ctw**
     & 2*vpaup**2*vmata**2*us**2-1d0/2/ctw**2*vpaup**2*vmata**2*mta**4+1
     & d0/2/ctw**2*vmaup**2*vpata**2*us**2-1d0/2/ctw**2*vmaup**2*vpata**
     & 2*mta**4+1d0/2/ctw**2*vmaup**2*vmata**2*ts**2-1d0/2/ctw**2*vmaup*
     & *2*vmata**2*mta**4)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*(-1d0/ctw**2*vpaup**2*v
     & pata*vmata*ts*mta**2-1d0/ctw**2*vpaup**2*vpata*vmata*mta**4-1d0/c
     & tw**2*vpaup**2*vpata**2*ts*mta**2-1d0/ctw**2*vpaup**2*vpata**2*ts
     & **2-1d0/ctw**2*vmaup**2*vpata*vmata*ts*mta**2-1d0/ctw**2*vmaup**2
     & *vpata*vmata*mta**4-1d0/ctw**2*vmaup**2*vmata**2*ts*mta**2-1d0/ct
     & w**2*vmaup**2*vmata**2*ts**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*(-1d0/ctw**2*vpaup**2*v
     & pata*vmata*us*mta**2-1d0/ctw**2*vpaup**2*vpata*vmata*mta**4-1d0/c
     & tw**2*vpaup**2*vmata**2*us*mta**2-1d0/ctw**2*vpaup**2*vmata**2*us
     & **2-1d0/ctw**2*vmaup**2*vpata*vmata*us*mta**2-1d0/ctw**2*vmaup**2
     & *vpata*vmata*mta**4-1d0/ctw**2*vmaup**2*vpata**2*us*mta**2-1d0/ct
     & w**2*vmaup**2*vpata**2*us**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2*vp
     & aup**2*vpata**2*ts-1d0/4/ctw**2*vpaup**2*vpata**2*mta**2+1d0/4/ct
     & w**2*vpaup**2*vmata**2*us-1d0/4/ctw**2*vpaup**2*vmata**2*mta**2+1
     & d0/4/ctw**2*vmaup**2*vpata**2*us-1d0/4/ctw**2*vmaup**2*vpata**2*m
     & ta**2+1d0/4/ctw**2*vmaup**2*vmata**2*ts-1d0/4/ctw**2*vmaup**2*vma
     & ta**2*mta**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*(sdet3ctats/ctw**2*vpaup*
     & *2*vpata*vmata*mta**2+1d0/2*sdet3ctats/ctw**2*vpaup**2*vpata**2*t
     & s+1d0/2*sdet3ctats/ctw**2*vpaup**2*vpata**2*mta**2+sdet3ctats/ctw
     & **2*vmaup**2*vpata*vmata*mta**2+1d0/2*sdet3ctats/ctw**2*vmaup**2*
     & vmata**2*ts+1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata**2*mta**2+sdet
     & 3ctaus/ctw**2*vpaup**2*vpata*vmata*mta**2+1d0/2*sdet3ctaus/ctw**2
     & *vpaup**2*vmata**2*us+1d0/2*sdet3ctaus/ctw**2*vpaup**2*vmata**2*m
     & ta**2+sdet3ctaus/ctw**2*vmaup**2*vpata*vmata*mta**2+1d0/2*sdet3ct
     & aus/ctw**2*vmaup**2*vpata**2*us+1d0/2*sdet3ctaus/ctw**2*vmaup**2*
     & vpata**2*mta**2)
     & +sdet4itatsus*b0fqszz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vpat
     & a**2*ts+1d0/2/ctw**2*vpaup**2*vpata**2*mta**2+1d0/2/ctw**2*vpaup*
     & *2*vmata**2*us+1d0/2/ctw**2*vpaup**2*vmata**2*mta**2+1d0/2/ctw**2
     & *vmaup**2*vpata**2*us+1d0/2/ctw**2*vmaup**2*vpata**2*mta**2+1d0/2
     & /ctw**2*vmaup**2*vmata**2*ts+1d0/2/ctw**2*vmaup**2*vmata**2*mta**
     & 2)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*vp
     & ata**2*ts-1d0/2/ctw**2*vpaup**2*vpata**2*mta**2-1d0/2/ctw**2*vmau
     & p**2*vmata**2*ts-1d0/2/ctw**2*vmaup**2*vmata**2*mta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*vm
     & ata**2*us-1d0/2/ctw**2*vpaup**2*vmata**2*mta**2-1d0/2/ctw**2*vmau
     & p**2*vpata**2*us-1d0/2/ctw**2*vmaup**2*vpata**2*mta**2)
     & +d0cctataqstszczta*dreal(propizqs)*(1d0/8/ctw**2*vpaup**2*vpata**
     & 2*qs+1d0/2/ctw**2*vpaup**2*vpata**2*ts+1d0/2/ctw**2*vpaup**2*vpat
     & a**2*mz**2+1d0/2/ctw**2*vpaup**2*vpata**2*mta**2+1d0/8/ctw**2*vma
     & up**2*vmata**2*qs+1d0/2/ctw**2*vmaup**2*vmata**2*ts+1d0/2/ctw**2*
     & vmaup**2*vmata**2*mz**2+1d0/2/ctw**2*vmaup**2*vmata**2*mta**2-1d0
     & /2*sdet3ctats/ctw**2*vpaup**2*vmata**2-1d0/2*sdet3ctats/ctw**2*vm
     & aup**2*vpata**2)
     & +d0cctataqsuswcwc*dreal(propizqs)*(-2*us*rwz)
     & +d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2*vpaup**
     & 2*vmata**2+1d0/4/ctw**2*vmaup**2*vpata**2)
     & +d0cctataqsuszczta*dreal(propizqs)*(-1d0/8/ctw**2*vpaup**2*vmata*
     & *2*qs+1d0/2/ctw**2*vpaup**2*vmata**2*us+1d0/2/ctw**2*vpaup**2*vma
     & ta**2*mta**2-1d0/8/ctw**2*vmaup**2*vpata**2*qs+1d0/2/ctw**2*vmaup
     & **2*vpata**2*us+1d0/2/ctw**2*vmaup**2*vpata**2*mta**2-1d0/2*sdet3
     & ctaus/ctw**2*vpaup**2*vpata**2-1d0/2*sdet3ctaus/ctw**2*vmaup**2*v
     & mata**2)
     & +c0tataqswcw*dreal(propizqs)*(2*rwz)
     & +c0tataqswcw*(15d0/2*mw**2*rtaw*rwz-3*mw**2*rtaw**2*rwz-1d0/2*mw*
     & *2*rtaw**3*rwz-4*mw**2*rwz)
     & +c0tataqsztaz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vpata**2+1d0
     & /2/ctw**2*vpaup**2*vmata**2+1d0/2/ctw**2*vmaup**2*vpata**2+1d0/2/
     & ctw**2*vmaup**2*vmata**2)
     & +c0tataqsztah*(-1d0/4/qs*mw**4*rtaw/rwz**2+1d0/2/qs*mw**4*rtaw/rw
     & z*rhw-1d0/4/qs*mw**4*rtaw*rhw**2+mw**2*rtaw/rwz-mw**2*rtaw**2)
     & +c0tataqstazta*(-7d0/2*qs/rwz-6*qs*rwz+9*qs-5d0/2*mw**2*rtaw/rwz-
     & 4*mw**2*rtaw*rwz+6*mw**2*rtaw+7*mw**2/rwz**2-18*mw**2/rwz+12*mw**
     & 2)
     & +c0tataqstahta*(mw**2*rtaw**2)
     & +c0tataqscwc*(qs-mw**2*rtaw-1d0/2*mw**2*rtaw**2-2*mw**2)
     & +c0ccqswcw*dreal(propizqs)*(2*rwz)
     & +c0ccqswcw*(2/qs*mw**4*rwz-4*mw**2*rwz)
     & +c0ccqszcz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vpata**2+1d0/2/
     & ctw**2*vpaup**2*vmata**2+1d0/2/ctw**2*vmaup**2*vpata**2+1d0/2/ctw
     & **2*vmaup**2*vmata**2)
     & +c0ccqscwc*(-vpadn/qs*mw**4-vpadn*qs+2*vpadn*mw**2)
     & +c0ccqsczc*(3d0/2*vpaup/qs*mw**4/rwz**3+3d0/2*vpaup*qs/rwz-3*vpau
     & p*mw**2/rwz**2-3d0/2*vpaup**2/qs*mw**4/rwz**3-3d0/2*vpaup**2*qs/r
     & wz+3*vpaup**2*mw**2/rwz**2-1d0/2/qs*mw**4/rwz**3-1d0/2*qs/rwz+mw*
     & *2/rwz**2)
     & +a0fw*dreal(propzqs)*(3*mw**2/rwz/rhw+1d0/6*mw**2/rwz-4*mw**2*rwz
     & -8d0/3*mw**2)
     & +a0fw*(1d0/4+vpadn/qs*mw**2-3d0/2*vpadn+2/qs*mw**2*rwz+1d0/2*rwz)
     & +a0fz*dreal(propzqs)*(3d0/2*mw**2/rwz**3/rhw+1d0/6*mw**2/rwz**2-1
     & d0/12*mw**2/rwz*rhw)
     & +a0fz*(-3d0/2*vpaup/qs*mw**2/rwz**2+9d0/4*vpaup/rwz+3d0/2*vpaup**
     & 2/qs*mw**2/rwz**2-9d0/4*vpaup**2/rwz+5d0/12/qs*mw**2/rwz**2+1d0/1
     & 2/qs*mw**2/rwz*rhw-7d0/8/rwz)
     & +a0fh*dreal(propzqs)*(1d0/2*mw**2/rwz*rhw+1d0/12*mw**2*rhw**2)
     & +a0fh*(1d0/12/qs*mw**2/rwz*rhw-1d0/12/qs*mw**2*rhw**2-1d0/8*rhw)
     & +a0fta*(3d0/2+1d0/4*rtaw-1d0/2/rwz-rwz)
     & +b0ftawc*(-5d0/4-3d0/2*rtaw*rwz-1d0/2*rtaw+5d0/2*rwz)
     & +b0ftazta*(-12-1d0/4/qs*mw**2*rtaw/rwz+1d0/4/qs*mw**2*rtaw*rhw+37
     & d0/8/rwz+8*rwz)
     & +b0ftahta*(1d0/4/qs*mw**2*rtaw/rwz-1d0/4/qs*mw**2*rtaw*rhw-1d0/8*
     & rhw)
     & +b0fqsww*dreal(propzqs)*(1d0/12*mw**2/rwz**2+4d0/3*mw**2/rwz-4*mw
     & **2*rwz-17d0/3*mw**2)
     & +b0fqsww*dreal(propizqs)*(-1d0/12*qs/mw**4*rwz+1d0/4/mw**2*rtaw*r
     & wz+5d0/3/mw**2*rwz)
     & +b0fqsww*(-4d0/3+2/qs*mw**2*rwz-1d0/4*qs/mw**2*rtaw*rwz-5d0/3*qs/
     & mw**2*rwz+1d0/12*qs/mw**2+1d0/12*qs**2/mw**4*rwz+3*rtaw*rwz+1d0/2
     & *rtaw**2*rwz-1d0/12/rwz+rwz)
     & +b0fqszh*dreal(propzqs)*(mw**2/rwz**2-1d0/3*mw**2/rwz*rhw+1d0/12*
     & mw**2*rhw**2)
     & +b0fqszh*(-1d0/12/qs*mw**2/rwz**2+1d0/6/qs*mw**2/rwz*rhw-1d0/12/q
     & s*mw**2*rhw**2+1d0/2*rtaw-1d0/12/rwz)
     & +b0fqstata*(27d0/2-1d0/4*rtaw-21d0/4/rwz-9*rwz)
     & +b0fqscc*(3d0/2-3d0/2*vpaup/qs*mw**2/rwz**2+9d0/4*vpaup/rwz+3d0/2
     & *vpaup**2/qs*mw**2/rwz**2-9d0/4*vpaup**2/rwz+vpadn/qs*mw**2-3d0/2
     & *vpadn+1d0/2/qs*mw**2/rwz**2+1d0/4*rtaw-3d0/4/rwz)
     & +dreal(propzqs)*(mw**2/rwz**3/rhw-1d0/18*mw**2/rwz**2+2*mw**2/rwz
     & /rhw-1d0/6*mw**2/rwz*rhw-mw**2/rwz*zmzzzbos-5d0/9*mw**2/rwz-4*mw*
     & *2*rwz-8d0/3*mw**2)
     & +dreal(b0ptazta)*(-7d0/4*mw**2*rtaw/rwz-4*mw**2*rtaw*rwz+6*mw**2*
     & rtaw-5d0/4*mw**2/rwz**2+3*mw**2/rwz-2*mw**2)
     & +dreal(b0ptahta)*(-1d0/4*mw**2*rtaw*rhw+mw**2*rtaw**2)
     & +dreal(b0ptacw)*(1d0/4*mw**2*rtaw+1d0/4*mw**2*rtaw**2-1d0/2*mw**2
     & )
     & +b0dwtacw*(-1+rwz)
     & +b0d1tataz*(-3d0/2+1d0/2/rwz+rwz)
     & +47d0/9+1d0/stw**2*deltarhobos+1d0/stw**2*deltarhofer+3d0/8*vpaup
     & /rwz+3d0/4*vpaup-3d0/8*vpaup**2/rwz-vpadn-1d0/2*rtaw*rwz+3d0/4*rt
     & aw-143d0/72/rwz+2*rwz-za1bos-2*deltarhobos-za1fer-2*deltarhofer+c
     & aldzfer

      ff_ew_ql =
     & +sdet3itataqs*c0tataqswcw*(-2/qs*mw**6-13d0/2*mw**4*rtaw+11d0/4*m
     & w**4*rtaw**2+1d0/2*mw**4*rtaw**3+11d0/4*mw**4)
     & +sdet3itataqs*c0tataqsztah*(-3d0/4*mw**4*rtaw/rwz**2-1d0/2*mw**4*
     & rtaw/rwz*rhw+1d0/4*mw**4*rtaw*rhw**2+2*mw**4*rtaw**2/rwz-2*mw**4*
     & rtaw**2*rhw+4*mw**4*rtaw**3)
     & +sdet3itataqs*c0tataqstazta*(-3/qs*mw**6/rwz**3+4/qs*mw**6/rwz**2
     & -55d0/4*mw**4*rtaw/rwz**2+24*mw**4*rtaw/rwz-8*mw**4*rtaw-7d0/2*mw
     & **4/rwz**3+9*mw**4/rwz**2-6*mw**4/rwz)
     & +sdet3itataqs*c0tataqstahta*(1d0/4*mw**4*rtaw*rhw**2-2*mw**4*rtaw
     & **2*rhw)
     & +sdet3itataqs*c0tataqscwc*(11d0/2*mw**4*rtaw+6*mw**4*rtaw**2+3d0/
     & 2*mw**4*rtaw**3+mw**4)
     & +sdet3itataqs*b0ftawc*(2/qs*mw**4+31d0/4*mw**2*rtaw+2*mw**2*rtaw*
     & *2-9d0/4*mw**2)
     & +sdet3itataqs*b0ftazta*(-3/qs*mw**4/rwz**2+4/qs*mw**4/rwz-13*mw**
     & 2*rtaw/rwz-8*mw**2*rtaw*rwz-1d0/4*mw**2*rtaw*rhw+24*mw**2*rtaw+mw
     & **2*rtaw**2-7d0/2*mw**2/rwz**2+9*mw**2/rwz-6*mw**2)
     & +sdet3itataqs*b0ftahta*(3d0/4*mw**2*rtaw/rwz-mw**2*rtaw**2)
     & +sdet3itataqs*b0fqsww*(-2/qs*mw**4-13d0/4*mw**2*rtaw-1d0/2*mw**2*
     & rtaw**2+13d0/4*mw**2)
     & +sdet3itataqs*b0fqszh*(-3d0/2*mw**2*rtaw/rwz+1d0/2*mw**2*rtaw*rhw
     & -2*mw**2*rtaw**2)
     & +sdet3itataqs*b0fqstata*(3/qs*mw**4/rwz**2-4/qs*mw**4/rwz+55d0/4*
     & mw**2*rtaw/rwz+8*mw**2*rtaw*rwz-1d0/4*mw**2*rtaw*rhw-24*mw**2*rta
     & w+2*mw**2*rtaw**2+7d0/2*mw**2/rwz**2-9*mw**2/rwz+6*mw**2)
     & +sdet3itataqs*b0fqscc*(-9d0/2*mw**2*rtaw-3d0/2*mw**2*rtaw**2-mw**
     & 2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/ctw**2*vm
     & aup*vmata**2*ts*mta**2+1d0/ctw**2*vmaup*vmata**2*mta**4)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*(-1d0/ctw**2*v
     & maup*vmata**2*ts*mta**2-1d0/ctw**2*vmaup*vmata**2*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/ctw**2*vm
     & aup*vpata**2*us*mta**2+1d0/ctw**2*vmaup*vpata**2*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*(-1d0/ctw**2*v
     & maup*vpata**2*us*mta**2-1d0/ctw**2*vmaup*vpata**2*mta**4)
     & +sdet4itatsus**2*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/4/ctw**2*vmaup*vmata**2*ts*mta**4+1d0/4/ctw**2*vmaup*vmata**2
     & *us*mta**4-1d0/4*sdet3ctats/ctw**2*vmaup*vmata**2*ts*mta**2+1d0/4
     & *sdet3ctats/ctw**2*vmaup*vmata**2*mta**4+1d0/4*sdet3ctats**2/ctw*
     & *2*vmaup*vmata**2*qs+sdet3ctats**2/ctw**2*vmaup*vmata**2*mta**2)
     & +sdet4itatsus**2*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(1
     & d0/4/ctw**2*vmaup*vpata**2*ts*mta**4-1d0/4/ctw**2*vmaup*vpata**2*
     & us*mta**4-1d0/4*sdet3ctaus/ctw**2*vmaup*vpata**2*us*mta**2+1d0/4*
     & sdet3ctaus/ctw**2*vmaup*vpata**2*mta**4+1d0/4*sdet3ctaus**2/ctw**
     & 2*vmaup*vpata**2*qs+sdet3ctaus**2/ctw**2*vmaup*vpata**2*mta**2)
     & +sdet4itatsus**2*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(1d0/4*sde
     & t3ctats/ctw**2*vmaup*vmata**2*qs*ts+1d0/4*sdet3ctats/ctw**2*vmaup
     & *vmata**2*qs*mta**2+sdet3ctats/ctw**2*vmaup*vmata**2*ts*mta**2+sd
     & et3ctats/ctw**2*vmaup*vmata**2*mta**4+1d0/4*sdet3ctaus/ctw**2*vma
     & up*vpata**2*qs*us+1d0/4*sdet3ctaus/ctw**2*vmaup*vpata**2*qs*mta**
     & 2+sdet3ctaus/ctw**2*vmaup*vpata**2*us*mta**2+sdet3ctaus/ctw**2*vm
     & aup*vpata**2*mta**4)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(1d0/2*sdet
     & 3ctats/ctw**2*vmaup*vmata**2*ts**2-1d0/2*sdet3ctats/ctw**2*vmaup*
     & vmata**2*mta**4)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*pxx2zqsc*(1d0/2*sdet
     & 3ctaus/ctw**2*vmaup*vpata**2*us**2-1d0/2*sdet3ctaus/ctw**2*vmaup*
     & vpata**2*mta**4)
     & +sdet4itatsus**2*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2
     & *vmaup*vpata**2*qs*us*mta**2-1d0/4/ctw**2*vmaup*vpata**2*qs*mta**
     & 4+1d0/4/ctw**2*vmaup*vmata**2*qs*ts*mta**2-1d0/4/ctw**2*vmaup*vma
     & ta**2*qs*mta**4-1d0/4*sdet3ctats**2/ctw**2*vmaup*vmata**2*ts+1d0/
     & 4*sdet3ctats**2/ctw**2*vmaup*vmata**2*mta**2-1d0/4*sdet3ctaus**2/
     & ctw**2*vmaup*vpata**2*us+1d0/4*sdet3ctaus**2/ctw**2*vmaup*vpata**
     & 2*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(1d0/
     & 2/ctw**2*vmaup*vmata**2*mta**2+1d0/8*sdet3ctats/ctw**2*vmaup*vmat
     & a**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc*(-1d0/2/
     & ctw**2*vmaup*vpata*vmata*ts*mta**2-1d0/2/ctw**2*vmaup*vpata*vmata
     & *mta**4-1d0/4/ctw**2*vmaup*vmata**2*qs*mta**2-3d0/4/ctw**2*vmaup*
     & vmata**2*ts**2+3d0/4/ctw**2*vmaup*vmata**2*mta**4-sdet3ctats/ctw*
     & *2*vmaup*vmata**2*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*(1d0/8/ctw**2*vma
     & up*vmata**2*qs*ts*mta**2-1d0/8/ctw**2*vmaup*vmata**2*qs*us*mta**2
     & +1d0/8*sdet3ctats/ctw**2*vmaup*vmata**2*qs*ts-1d0/8*sdet3ctats/ct
     & w**2*vmaup*vmata**2*qs*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(1d0/
     & 2/ctw**2*vmaup*vpata**2*mta**2+1d0/8*sdet3ctaus/ctw**2*vmaup*vpat
     & a**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(-1d0/2/
     & ctw**2*vmaup*vpata*vmata*us*mta**2-1d0/2/ctw**2*vmaup*vpata*vmata
     & *mta**4-1d0/4/ctw**2*vmaup*vpata**2*qs*mta**2-3d0/4/ctw**2*vmaup*
     & vpata**2*us**2+3d0/4/ctw**2*vmaup*vpata**2*mta**4-sdet3ctaus/ctw*
     & *2*vmaup*vpata**2*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*(-1d0/8/ctw**2*vm
     & aup*vpata**2*qs*ts*mta**2+1d0/8/ctw**2*vmaup*vpata**2*qs*us*mta**
     & 2+1d0/8*sdet3ctaus/ctw**2*vmaup*vpata**2*qs*us-1d0/8*sdet3ctaus/c
     & tw**2*vmaup*vpata**2*qs*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(1d0/2/ctw**2
     & *vmaup*vpata**2*mta**2+1d0/2/ctw**2*vmaup*vmata**2*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*v
     & pata**2*us**2+1d0/2/ctw**2*vmaup*vpata**2*mta**4-1d0/2/ctw**2*vma
     & up*vmata**2*ts**2+1d0/2/ctw**2*vmaup*vmata**2*mta**4)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*(1d0/ctw**2*vmaup*vpata
     & *vmata*ts*mta**2+1d0/ctw**2*vmaup*vpata*vmata*mta**4+1d0/ctw**2*v
     & maup*vmata**2*ts*mta**2+1d0/ctw**2*vmaup*vmata**2*ts**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*(1d0/ctw**2*vmaup*vpata
     & *vmata*us*mta**2+1d0/ctw**2*vmaup*vpata*vmata*mta**4+1d0/ctw**2*v
     & maup*vpata**2*us*mta**2+1d0/ctw**2*vmaup*vpata**2*us**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**2*v
     & maup*vpata**2*us+1d0/4/ctw**2*vmaup*vpata**2*mta**2-1d0/4/ctw**2*
     & vmaup*vmata**2*ts+1d0/4/ctw**2*vmaup*vmata**2*mta**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*(-sdet3ctats/ctw**2*vmaup
     & *vpata*vmata*mta**2-1d0/2*sdet3ctats/ctw**2*vmaup*vmata**2*ts-1d0
     & /2*sdet3ctats/ctw**2*vmaup*vmata**2*mta**2-sdet3ctaus/ctw**2*vmau
     & p*vpata*vmata*mta**2-1d0/2*sdet3ctaus/ctw**2*vmaup*vpata**2*us-1d
     & 0/2*sdet3ctaus/ctw**2*vmaup*vpata**2*mta**2)
     & +sdet4itatsus*b0fqszz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpata*
     & *2*us-1d0/2/ctw**2*vmaup*vpata**2*mta**2-1d0/2/ctw**2*vmaup*vmata
     & **2*ts-1d0/2/ctw**2*vmaup*vmata**2*mta**2)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vmata*
     & *2*ts+1d0/2/ctw**2*vmaup*vmata**2*mta**2)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vpata*
     & *2*us+1d0/2/ctw**2*vmaup*vpata**2*mta**2)
     & +d0cctataqstszczta*dreal(propizqs)*(-1d0/8/ctw**2*vmaup*vmata**2*
     & qs-1d0/2/ctw**2*vmaup*vmata**2*ts-1d0/2/ctw**2*vmaup*vmata**2*mz*
     & *2-1d0/2/ctw**2*vmaup*vmata**2*mta**2+1d0/2*sdet3ctats/ctw**2*vma
     & up*vpata**2)
     & +d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**2*vmaup*
     & vpata**2)
     & +d0cctataqsuszczta*dreal(propizqs)*(1d0/8/ctw**2*vmaup*vpata**2*q
     & s-1d0/2/ctw**2*vmaup*vpata**2*us-1d0/2/ctw**2*vmaup*vpata**2*mta*
     & *2+1d0/2*sdet3ctaus/ctw**2*vmaup*vmata**2)
     & +c0tataqswcw*(-1d0/qs*mw**4*rtaw+1d0/4/qs*mw**4*rtaw**2+5d0/4/qs*
     & mw**4)
     & +c0tataqsztaz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpata**2-1d0/2
     & /ctw**2*vmaup*vmata**2)
     & +c0tataqsztah*(-1d0/4/qs*mw**4*rtaw/rwz**2+1d0/2/qs*mw**4*rtaw/rw
     & z*rhw-1d0/4/qs*mw**4*rtaw*rhw**2+mw**2*rtaw/rwz-mw**2*rtaw**2)
     & +c0tataqstazta*(3/qs*mw**4/rwz**2-4/qs*mw**4/rwz-7d0/2*qs/rwz-2*q
     & s*rwz+6*qs-5d0/2*mw**2*rtaw/rwz-4*mw**2*rtaw*rwz+6*mw**2*rtaw+7*m
     & w**2/rwz**2-15*mw**2/rwz+8*mw**2)
     & +c0tataqstahta*(mw**2*rtaw**2)
     & +c0tataqscwc*(qs-mw**2*rtaw-1d0/2*mw**2*rtaw**2-2*mw**2)
     & +c0ccqszcz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpata**2-1d0/2/ct
     & w**2*vmaup*vmata**2)
     & +c0ccqsczc*(vpaup/qs*mw**4/rwz**3+vpaup*qs/rwz-2*vpaup*mw**2/rwz*
     & *2-1d0/2*vpaup**2/qs*mw**4/rwz**3-1d0/2*vpaup**2*qs/rwz+vpaup**2*
     & mw**2/rwz**2-1d0/2/qs*mw**4/rwz**3-1d0/2*qs/rwz+mw**2/rwz**2)
     & +a0fw*dreal(propzqs)*(3*mw**2/rwz/rhw+1d0/6*mw**2/rwz-4*mw**2*rwz
     & -8d0/3*mw**2)
     & +a0fw*(1d0/4+4/qs*mw**2*rwz-1d0/6/qs*mw**2)
     & +a0fz*dreal(propzqs)*(3d0/2*mw**2/rwz**3/rhw+1d0/6*mw**2/rwz**2-1
     & d0/12*mw**2/rwz*rhw)
     & +a0fz*(-vpaup/qs*mw**2/rwz**2+3d0/2*vpaup/rwz+1d0/2*vpaup**2/qs*m
     & w**2/rwz**2-3d0/4*vpaup**2/rwz+5d0/12/qs*mw**2/rwz**2+1d0/12/qs*m
     & w**2/rwz*rhw-7d0/8/rwz)
     & +a0fh*dreal(propzqs)*(1d0/2*mw**2/rwz*rhw+1d0/12*mw**2*rhw**2)
     & +a0fh*(1d0/12/qs*mw**2/rwz*rhw-1d0/12/qs*mw**2*rhw**2-1d0/8*rhw)
     & +a0fta*(-3d0/2/qs*mw**2/rwz+2/qs*mw**2+1d0/4*rtaw-1d0/2/rwz+rwz)
     & +b0ftawc*(-5d0/4-1d0/4/qs*mw**2*rtaw+3d0/4/qs*mw**2-1d0/2*rtaw)
     & +b0ftazta*(-9-1d0/4/qs*mw**2*rtaw/rwz+1d0/4/qs*mw**2*rtaw*rhw+37d
     & 0/8/rwz+4*rwz)
     & +b0ftahta*(1d0/4/qs*mw**2*rtaw/rwz-1d0/4/qs*mw**2*rtaw*rhw-1d0/8*
     & rhw)
     & +b0fqsww*dreal(propzqs)*(1d0/12*mw**2/rwz**2+4d0/3*mw**2/rwz-4*mw
     & **2*rwz-17d0/3*mw**2)
     & +b0fqsww*(1d0/6+1d0/4/qs*mw**2*rtaw+4/qs*mw**2*rwz-11d0/12/qs*mw*
     & *2+1d0/4*rtaw-1d0/12/rwz)
     & +b0fqszh*dreal(propzqs)*(mw**2/rwz**2-1d0/3*mw**2/rwz*rhw+1d0/12*
     & mw**2*rhw**2)
     & +b0fqszh*(-1d0/12/qs*mw**2/rwz**2+1d0/6/qs*mw**2/rwz*rhw-1d0/12/q
     & s*mw**2*rhw**2+1d0/2*rtaw-1d0/12/rwz)
     & +b0fqstata*(9-3d0/2/qs*mw**2/rwz+2/qs*mw**2-1d0/4*rtaw-21d0/4/rwz
     & -3*rwz)
     & +b0fqscc*(3d0/2-vpaup/qs*mw**2/rwz**2+3d0/2*vpaup/rwz+1d0/2*vpaup
     & **2/qs*mw**2/rwz**2-3d0/4*vpaup**2/rwz+1d0/2/qs*mw**2/rwz**2+1d0/
     & 4*rtaw-3d0/4/rwz)
     & +dreal(propzqs)*(mw**2/rwz**3/rhw-1d0/18*mw**2/rwz**2+2*mw**2/rwz
     & /rhw-1d0/6*mw**2/rwz*rhw-mw**2/rwz*zmzzzbos-5d0/9*mw**2/rwz-4*mw*
     & *2*rwz-8d0/3*mw**2)
     & +dreal(b0ptazta)*(-7d0/4*mw**2*rtaw/rwz-4*mw**2*rtaw*rwz+6*mw**2*
     & rtaw-5d0/4*mw**2/rwz**2+3*mw**2/rwz-2*mw**2)
     & +dreal(b0ptahta)*(-1d0/4*mw**2*rtaw*rhw+mw**2*rtaw**2)
     & +dreal(b0ptacw)*(1d0/4*mw**2*rtaw+1d0/4*mw**2*rtaw**2-1d0/2*mw**2
     & )
     & +b0dwtacw*(-1-1d0/qs*mw**2)
     & +b0d1tataz*(3d0/2/qs*mw**2/rwz-2/qs*mw**2+1d0/2/rwz-rwz)
     & +65d0/18+1d0/4*vpaup/rwz-1d0/8*vpaup**2/rwz+1d0/2/qs*mw**2*rtaw-3
     & d0/2/qs*mw**2/rwz+4/qs*mw**2*rwz+1d0/3/qs*mw**2+3d0/4*rtaw-143d0/
     & 72/rwz-rwz-za1bos-deltarhobos-za1fer-deltarhofer+caldzfer-pizgfer
     & 

      ff_ew_lq =
     & +sdet3itataqs*c0tataqswcw*dreal(propizqs)*(-3d0/2/vmata*mw**2*rta
     & w*rwz+1d0/vmata*mw**2*rtaw**2*rwz+1d0/2/vmata*mw**2*rtaw**3*rwz)
     & +sdet3itataqs*c0tataqswcw*(7/vmata*mw**4*rtaw*rwz-12/vmata*mw**4*
     & rtaw**2*rwz+3/vmata*mw**4*rtaw**3*rwz+2/vmata*mw**4*rtaw**4*rwz)
     & +sdet3itataqs*c0tataqsztah*(-3d0/8/vmata*mw**4*rtaw/rwz**2-1d0/4/
     & vmata*mw**4*rtaw/rwz*rhw+1d0/8/vmata*mw**4*rtaw*rhw**2+1d0/vmata*
     & mw**4*rtaw**2/rwz-1d0/vmata*mw**4*rtaw**2*rhw+2/vmata*mw**4*rtaw*
     & *3)
     & +sdet3itataqs*c0tataqstazta*(-3d0/4/vmata*mw**4*rtaw/rwz**2-13d0/
     & 4*mw**4*rtaw/rwz**2+6*mw**4*rtaw/rwz-2*mw**4/rwz**3+4*mw**4/rwz**
     & 2-2*mw**4/rwz)
     & +sdet3itataqs*c0tataqstahta*(1d0/4/vmata*mw**4*rtaw*rhw**2-1d0/vm
     & ata*mw**4*rtaw**2*rhw-1d0/4*mw**4*rtaw*rhw**2)
     & +sdet3itataqs*c0tataqscwc*(3d0/2/vmata*mw**4*rtaw+2/vmata*mw**4*r
     & taw**2+1d0/2/vmata*mw**4*rtaw**3)
     & +sdet3itataqs*b0ftawc*dreal(propizqs)*(1d0/vmata*rtaw*rwz)
     & +sdet3itataqs*b0ftawc*(-7/vmata*mw**2*rtaw*rwz+2/vmata*mw**2*rtaw
     & +3/vmata*mw**2*rtaw**2*rwz+1d0/vmata*mw**2*rtaw**2)
     & +sdet3itataqs*b0ftazta*(-3d0/8/vmata*mw**2*rtaw/rwz-1d0/8/vmata*m
     & w**2*rtaw*rhw+1d0/2/vmata*mw**2*rtaw**2-13d0/4*mw**2*rtaw/rwz+6*m
     & w**2*rtaw-2*mw**2/rwz**2+4*mw**2/rwz-2*mw**2)
     & +sdet3itataqs*b0ftahta*(3d0/8/vmata*mw**2*rtaw/rwz+1d0/8/vmata*mw
     & **2*rtaw*rhw-1d0/2/vmata*mw**2*rtaw**2-1d0/4*mw**2*rtaw*rhw)
     & +sdet3itataqs*b0fqsww*dreal(propizqs)*(-3d0/2/vmata*rtaw*rwz-1d0/
     & 2/vmata*rtaw**2*rwz)
     & +sdet3itataqs*b0fqsww*(7/vmata*mw**2*rtaw*rwz-5/vmata*mw**2*rtaw*
     & *2*rwz-2/vmata*mw**2*rtaw**3*rwz)
     & +sdet3itataqs*b0fqszh*(-3d0/4/vmata*mw**2*rtaw/rwz+1d0/4/vmata*mw
     & **2*rtaw*rhw-1d0/vmata*mw**2*rtaw**2)
     & +sdet3itataqs*b0fqstata*(3d0/4/vmata*mw**2*rtaw/rwz-1d0/4/vmata*m
     & w**2*rtaw*rhw+1d0/vmata*mw**2*rtaw**2+13d0/4*mw**2*rtaw/rwz+1d0/4
     & *mw**2*rtaw*rhw-6*mw**2*rtaw+2*mw**2/rwz**2-4*mw**2/rwz+2*mw**2)
     & +sdet3itataqs*b0fqscc*(-3d0/2/vmata*mw**2*rtaw-1d0/2/vmata*mw**2*
     & rtaw**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(1
     & d0/2/ctw**2*vpaup**2*vpata**2/vmata*ts*mta**2-1d0/2/ctw**2*vmaup*
     & *2*vmata*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/ctw**2*v
     & paup**2*vpata**2/vmata*mta**4-1d0/ctw**2*vmaup**2*vmata*ts*mta**2
     & )
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*(1d0/ctw**2*vp
     & aup**2*vpata**2/vmata*mta**4+1d0/ctw**2*vmaup**2*vmata*ts*mta**2)
     & 
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*v
     & pata**2/vmata*mta**2-1d0/2/ctw**2*vmaup**2*vmata*mta**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*pxx2zqsc*(-
     & 1d0/2/ctw**2*vpaup**2*vmata*us*mta**2+1d0/2/ctw**2*vmaup**2*vpata
     & **2/vmata*us*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/ctw**2*v
     & paup**2*vmata*us*mta**2-1d0/ctw**2*vmaup**2*vpata**2/vmata*mta**4
     & )
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*(1d0/ctw**2*vp
     & aup**2*vmata*us*mta**2+1d0/ctw**2*vmaup**2*vpata**2/vmata*mta**4)
     & 
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*
     & vmata*mta**2+1d0/2/ctw**2*vmaup**2*vpata**2/vmata*mta**2)
     & +sdet4itatsus**2*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(1
     & d0/4/ctw**2*vmaup**2*vmata*ts*mta**4-1d0/4/ctw**2*vmaup**2*vmata*
     & us*mta**4+1d0/4*sdet3ctats/ctw**2*vpaup**2*vpata**2/vmata*ts*mta*
     & *2-1d0/4*sdet3ctats/ctw**2*vpaup**2*vpata**2/vmata*mta**4-1d0/4*s
     & det3ctats**2/ctw**2*vmaup**2*vmata*qs-sdet3ctats**2/ctw**2*vmaup*
     & *2*vmata*mta**2)
     & +sdet4itatsus**2*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/4/ctw**2*vpaup**2*vmata*ts*mta**4+1d0/4/ctw**2*vpaup**2*vmata
     & *us*mta**4+1d0/4*sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmata*us*mta
     & **2-1d0/4*sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmata*mta**4-1d0/4*
     & sdet3ctaus**2/ctw**2*vpaup**2*vmata*qs-sdet3ctaus**2/ctw**2*vpaup
     & **2*vmata*mta**2)
     & +sdet4itatsus**2*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/4*sd
     & et3ctats/ctw**2*vpaup**2*vpata**2/vmata*qs*mta**2-sdet3ctats/ctw*
     & *2*vpaup**2*vpata**2/vmata*mta**4-1d0/4*sdet3ctats/ctw**2*vmaup**
     & 2*vmata*qs*ts-sdet3ctats/ctw**2*vmaup**2*vmata*ts*mta**2-1d0/4*sd
     & et3ctaus/ctw**2*vpaup**2*vmata*qs*us-sdet3ctaus/ctw**2*vpaup**2*v
     & mata*us*mta**2-1d0/4*sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmata*qs
     & *mta**2-sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmata*mta**4)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(-1d0/2*sde
     & t3ctats/ctw**2*vpaup**2*vpata**2/vmata*ts*mta**2+1d0/2*sdet3ctats
     & /ctw**2*vpaup**2*vpata**2/vmata*mta**4+1d0/2*sdet3ctats/ctw**2*vm
     & aup**2*vmata*ts*mta**2-1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata*ts*
     & *2)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*pxx2zqsc*(1d0/2*sdet
     & 3ctaus/ctw**2*vpaup**2*vmata*us*mta**2-1d0/2*sdet3ctaus/ctw**2*vp
     & aup**2*vmata*us**2-1d0/2*sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmat
     & a*us*mta**2+1d0/2*sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmata*mta**
     & 4)
     & +sdet4itatsus**2*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**
     & 2*vpaup**2*vpata**2/vmata*qs*ts*mta**2+1d0/4/ctw**2*vpaup**2*vpat
     & a**2/vmata*qs*mta**4-1d0/4/ctw**2*vmaup**2*vpata**2/vmata*qs*us*m
     & ta**2+1d0/4/ctw**2*vmaup**2*vpata**2/vmata*qs*mta**4+1d0/4*sdet3c
     & tats**2/ctw**2*vmaup**2*vmata*ts-1d0/4*sdet3ctats**2/ctw**2*vmaup
     & **2*vmata*mta**2+1d0/4*sdet3ctaus**2/ctw**2*vpaup**2*vmata*us-1d0
     & /4*sdet3ctaus**2/ctw**2*vpaup**2*vmata*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(-1d0
     & /8/ctw**2*vpaup**2*vpata**2/vmata*mta**2-3d0/8/ctw**2*vmaup**2*vm
     & ata*mta**2-1d0/8*sdet3ctats/ctw**2*vmaup**2*vmata)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc*(1d0/2/c
     & tw**2*vpaup**2*vpata*mta**4+1d0/4/ctw**2*vpaup**2*vpata**2/vmata*
     & qs*mta**2-1d0/2/ctw**2*vpaup**2*vpata**2/vmata*mta**4+1d0/2/ctw**
     & 2*vmaup**2*vpata*ts*mta**2+3d0/4/ctw**2*vmaup**2*vmata*ts**2-1d0/
     & 4/ctw**2*vmaup**2*vmata*mta**4+sdet3ctats/ctw**2*vpaup**2*vpata**
     & 2/vmata*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*(-1d0/8/ctw**2*vp
     & aup**2*vpata**2/vmata*qs*ts*mta**2+1d0/8/ctw**2*vpaup**2*vpata**2
     & /vmata*qs*us*mta**2-1d0/8*sdet3ctats/ctw**2*vmaup**2*vmata*qs*ts+
     & 1d0/8*sdet3ctats/ctw**2*vmaup**2*vmata*qs*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(-3d0
     & /8/ctw**2*vpaup**2*vmata*mta**2-1d0/8/ctw**2*vmaup**2*vpata**2/vm
     & ata*mta**2-1d0/8*sdet3ctaus/ctw**2*vpaup**2*vmata)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(1d0/2/c
     & tw**2*vpaup**2*vpata*us*mta**2+3d0/4/ctw**2*vpaup**2*vmata*us**2-
     & 1d0/4/ctw**2*vpaup**2*vmata*mta**4+1d0/2/ctw**2*vmaup**2*vpata*mt
     & a**4+1d0/4/ctw**2*vmaup**2*vpata**2/vmata*qs*mta**2-1d0/2/ctw**2*
     & vmaup**2*vpata**2/vmata*mta**4+sdet3ctaus/ctw**2*vmaup**2*vpata**
     & 2/vmata*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*(1d0/8/ctw**2*vma
     & up**2*vpata**2/vmata*qs*ts*mta**2-1d0/8/ctw**2*vmaup**2*vpata**2/
     & vmata*qs*us*mta**2-1d0/8*sdet3ctaus/ctw**2*vpaup**2*vmata*qs*us+1
     & d0/8*sdet3ctaus/ctw**2*vpaup**2*vmata*qs*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**
     & 2*vpaup**2*vpata**2/vmata*mta**2-1d0/4/ctw**2*vpaup**2*vmata*mta*
     & *2-1d0/4/ctw**2*vmaup**2*vpata**2/vmata*mta**2-1d0/4/ctw**2*vmaup
     & **2*vmata*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2
     & *vpata**2/vmata*ts*mta**2-1d0/2/ctw**2*vpaup**2*vpata**2/vmata*mt
     & a**4-1d0/2/ctw**2*vpaup**2*vmata*us*mta**2+1d0/2/ctw**2*vpaup**2*
     & vmata*us**2+1d0/2/ctw**2*vmaup**2*vpata**2/vmata*us*mta**2-1d0/2/
     & ctw**2*vmaup**2*vpata**2/vmata*mta**4-1d0/2/ctw**2*vmaup**2*vmata
     & *ts*mta**2+1d0/2/ctw**2*vmaup**2*vmata*ts**2)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*(-1d0/ctw**2*vpaup**2*v
     & pata*mta**4-1d0/ctw**2*vpaup**2*vpata**2/vmata*ts*mta**2-1d0/ctw*
     & *2*vmaup**2*vpata*ts*mta**2-1d0/ctw**2*vmaup**2*vmata*ts**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*(-1d0/ctw**2*vpaup**2*v
     & pata*us*mta**2-1d0/ctw**2*vpaup**2*vmata*us**2-1d0/ctw**2*vmaup**
     & 2*vpata*mta**4-1d0/ctw**2*vmaup**2*vpata**2/vmata*us*mta**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**2*v
     & paup**2*vpata**2/vmata*mta**2+1d0/4/ctw**2*vpaup**2*vmata*us-1d0/
     & 4/ctw**2*vmaup**2*vpata**2/vmata*mta**2+1d0/4/ctw**2*vmaup**2*vma
     & ta*ts)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*(1d0/2*sdet3ctats/ctw**2*
     & vpaup**2*vpata**2/vmata*mta**2+sdet3ctats/ctw**2*vmaup**2*vpata*m
     & ta**2+1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata*ts+sdet3ctaus/ctw**2
     & *vpaup**2*vpata*mta**2+1d0/2*sdet3ctaus/ctw**2*vpaup**2*vmata*us+
     & 1d0/2*sdet3ctaus/ctw**2*vmaup**2*vpata**2/vmata*mta**2)
     & +sdet4itatsus*b0fqszz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vpat
     & a**2/vmata*mta**2+1d0/2/ctw**2*vpaup**2*vmata*us+1d0/2/ctw**2*vma
     & up**2*vpata**2/vmata*mta**2+1d0/2/ctw**2*vmaup**2*vmata*ts)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*vp
     & ata**2/vmata*mta**2-1d0/2/ctw**2*vmaup**2*vmata*ts)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*vm
     & ata*us-1d0/2/ctw**2*vmaup**2*vpata**2/vmata*mta**2)
     & +d0cctataqstszczta*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*vpata*
     & mta**2+1d0/2/ctw**2*vpaup**2*vpata**2/vmata*mta**2+1d0/2/ctw**2*v
     & maup**2*vpata*mta**2+1d0/8/ctw**2*vmaup**2*vmata*qs+1d0/2/ctw**2*
     & vmaup**2*vmata*ts+1d0/2/ctw**2*vmaup**2*vmata*mz**2-1d0/2*sdet3ct
     & ats/ctw**2*vpaup**2*vmata)
     & +d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2*vpaup**
     & 2*vmata)
     & +d0cctataqsuszczta*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vpata*m
     & ta**2-1d0/8/ctw**2*vpaup**2*vmata*qs+1d0/2/ctw**2*vpaup**2*vmata*
     & us-1d0/2/ctw**2*vmaup**2*vpata*mta**2+1d0/2/ctw**2*vmaup**2*vpata
     & **2/vmata*mta**2-1d0/2*sdet3ctaus/ctw**2*vmaup**2*vmata)
     & +c0tataqswcw*(3d0/2/vmata*mw**2*rtaw*rwz-1d0/vmata*mw**2*rtaw**2*
     & rwz-1d0/2/vmata*mw**2*rtaw**3*rwz)
     & +c0tataqsztaz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vmata+1d0/2/
     & ctw**2*vmaup**2*vmata)
     & +c0tataqsztah*(3d0/8/vmata/qs*mw**4*rtaw/rwz**2-1d0/4/vmata/qs*mw
     & **4*rtaw/rwz*rhw-1d0/8/vmata/qs*mw**4*rtaw*rhw**2-1d0/2/vmata*mw*
     & *2*rtaw**2-1d0/qs*mw**4*rtaw/rwz**2+1d0/qs*mw**4*rtaw/rwz*rhw+mw*
     & *2*rtaw/rwz)
     & +c0tataqstazta*(1d0/2/vmata*mw**2*rtaw/rwz-2*qs/rwz-2*qs*rwz+4*qs
     & -7d0/2*mw**2*rtaw/rwz-4*mw**2*rtaw*rwz+6*mw**2*rtaw+4*mw**2/rwz**
     & 2-8*mw**2/rwz+4*mw**2)
     & +c0tataqstahta*(mw**2*rtaw**2)
     & +c0tataqscwc*(-1d0/vmata*mw**2*rtaw)
     & +c0ccqswcw*(-2/qs**2*mw**6+4/qs*mw**4)
     & +c0ccqszcz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vmata+1d0/2/ctw
     & **2*vmaup**2*vmata)
     & +c0ccqscwc*(2*qdn/qs**2*mw**6+2*qdn/qs*mw**4*rwz-4*qdn/qs*mw**4+2
     & *qdn*qs*rwz-4*qdn*mw**2*rwz+2*qdn*mw**2-vpadn/qs*mw**4-vpadn*qs+2
     & *vpadn*mw**2)
     & +c0ccqsczc*(2*qup*vpaup/qs**2*mw**6/rwz**3-2*qup*vpaup/qs*mw**4/r
     & wz**2+2*qup*vpaup*qs-2*qup*vpaup*mw**2/rwz-qup/qs**2*mw**6/rwz**3
     & +qup/qs*mw**4/rwz**2-qup*qs+qup*mw**2/rwz+3d0/2*vpaup/qs*mw**4/rw
     & z**3+3d0/2*vpaup*qs/rwz-3*vpaup*mw**2/rwz**2-3d0/2*vpaup**2/qs*mw
     & **4/rwz**3-3d0/2*vpaup**2*qs/rwz+3*vpaup**2*mw**2/rwz**2-1d0/2/qs
     & *mw**4/rwz**3-1d0/2*qs/rwz+mw**2/rwz**2)
     & +a0fw*dreal(propzqs)*(3*mw**2/rwz/rhw+1d0/6*mw**2/rwz-4*mw**2*rwz
     & -8d0/3*mw**2)
     & +a0fw*(-2*qdn/qs**2*mw**4-2*qdn/qs*mw**2*rwz+3*qdn/qs*mw**2+3*qdn
     & *rwz+vpadn/qs*mw**2-3d0/2*vpadn-2/qs**2*mw**4+4/qs*mw**2*rwz+7d0/
     & 3/qs*mw**2)
     & +a0fz*dreal(propzqs)*(3d0/2*mw**2/rwz**3/rhw+1d0/6*mw**2/rwz**2-1
     & d0/12*mw**2/rwz*rhw)
     & +a0fz*(-2*qup*vpaup/qs**2*mw**4/rwz**2+qup*vpaup/qs*mw**2/rwz+3*q
     & up*vpaup+qup/qs**2*mw**4/rwz**2-1d0/2*qup/qs*mw**2/rwz-3d0/2*qup-
     & 3d0/2*vpaup/qs*mw**2/rwz**2+9d0/4*vpaup/rwz+3d0/2*vpaup**2/qs*mw*
     & *2/rwz**2-9d0/4*vpaup**2/rwz+5d0/12/qs*mw**2/rwz**2+1d0/12/qs*mw*
     & *2/rwz*rhw-7d0/8/rwz)
     & +a0fh*dreal(propzqs)*(1d0/2*mw**2/rwz*rhw+1d0/12*mw**2*rhw**2)
     & +a0fh*(1d0/12/qs*mw**2/rwz*rhw-1d0/12/qs*mw**2*rhw**2-1d0/8*rhw)
     & +a0fta*(-1+1d0/4*rtaw+1d0/4/rwz+rwz)
     & +b0ftawc*(-1d0/vmata*rtaw*rwz-1d0/4*rtaw)
     & +b0ftazta*(-7+3d0/8/vmata/qs*mw**2*rtaw/rwz+1d0/8/vmata/qs*mw**2*
     & rtaw*rhw-1d0/qs*mw**2*rtaw/rwz+25d0/8/rwz+4*rwz)
     & +b0ftahta*(-3d0/8/vmata/qs*mw**2*rtaw/rwz-1d0/8/vmata/qs*mw**2*rt
     & aw*rhw+1d0/qs*mw**2*rtaw/rwz-1d0/8*rhw)
     & +b0fqsww*dreal(propzqs)*(1d0/12*mw**2/rwz**2+4d0/3*mw**2/rwz-4*mw
     & **2*rwz-17d0/3*mw**2)
     & +b0fqsww*dreal(propizqs)*(1d0/4/vmata/mw**2*rtaw*rwz)
     & +b0fqsww*(1d0/6-1d0/4/vmata*qs/mw**2*rtaw*rwz+1d0/vmata*rtaw*rwz+
     & 1d0/2/vmata*rtaw**2*rwz-2/qs**2*mw**4+4/qs*mw**2*rwz+7d0/3/qs*mw*
     & *2-1d0/12/rwz)
     & +b0fqszh*dreal(propzqs)*(mw**2/rwz**2-1d0/3*mw**2/rwz*rhw+1d0/12*
     & mw**2*rhw**2)
     & +b0fqszh*(1d0/4/vmata*rtaw-1d0/12/qs*mw**2/rwz**2+1d0/6/qs*mw**2/
     & rwz*rhw-1d0/12/qs*mw**2*rhw**2-1d0/12/rwz)
     & +b0fqstata*(6-1d0/4/vmata*rtaw+1d0/4*rtaw-3/rwz-3*rwz)
     & +b0fqscc*(-2*qup*vpaup/qs**2*mw**4/rwz**2+qup*vpaup/qs*mw**2/rwz+
     & 3*qup*vpaup+qup/qs**2*mw**4/rwz**2-1d0/2*qup/qs*mw**2/rwz-3d0/2*q
     & up-2*qdn/qs**2*mw**4-2*qdn/qs*mw**2*rwz+3*qdn/qs*mw**2+3*qdn*rwz-
     & 3d0/2*vpaup/qs*mw**2/rwz**2+9d0/4*vpaup/rwz+3d0/2*vpaup**2/qs*mw*
     & *2/rwz**2-9d0/4*vpaup**2/rwz+vpadn/qs*mw**2-3d0/2*vpadn+1d0/4/vma
     & ta*rtaw+1d0/2/qs*mw**2/rwz**2-3d0/4/rwz)
     & +dreal(propzqs)*(mw**2/rwz**3/rhw-1d0/18*mw**2/rwz**2+2*mw**2/rwz
     & /rhw-1d0/6*mw**2/rwz*rhw-mw**2/rwz*zmzzzbos-5d0/9*mw**2/rwz-4*mw*
     & *2*rwz-8d0/3*mw**2)
     & +dreal(b0ptazta)*(-7d0/4*mw**2*rtaw/rwz-4*mw**2*rtaw*rwz+6*mw**2*
     & rtaw-5d0/4*mw**2/rwz**2+3*mw**2/rwz-2*mw**2)
     & +dreal(b0ptahta)*(-1d0/4*mw**2*rtaw*rhw+mw**2*rtaw**2)
     & +dreal(b0ptacw)*(1d0/4*mw**2*rtaw+1d0/4*mw**2*rtaw**2-1d0/2*mw**2
     & )
     & +b0dwtacw*(-1d0/2)
     & +b0d1tataz*(1-1d0/4/rwz-rwz)
     & +19d0/9+1d0/2*qup*vpaup/qs*mw**2/rwz+1d0/2*qup*vpaup-1d0/4*qup/qs
     & *mw**2/rwz-3d0/2*qup/qs*mw**2-3d0/2*qup*rwz-1d0/4*qup+2*qdn/qs*mw
     & **2+2*qdn*rwz+3d0/8*vpaup/rwz+3d0/4*vpaup-3d0/8*vpaup**2/rwz-vpad
     & n-1d0/2/vmata*rtaw*rwz+1d0/2/vmata*rtaw+4/qs*mw**2*rwz-2d0/3/qs*m
     & w**2-1d0/4*rtaw-89d0/72/rwz-rwz-za1bos-deltarhobos-za1fer-deltarh
     & ofer+caldzfer-pizgfer

      ff_ew_qq =
     & +sdet3itataqs*c0tataqswcw*(-3/vmata*mw**4*rtaw+3d0/4/vmata*mw**4*
     & rtaw**2+1d0/2/vmata*mw**4*rtaw**3+7d0/4/vmata*mw**4)
     & +sdet3itataqs*c0tataqsztah*(-3d0/8/vmata*mw**4*rtaw/rwz**2-1d0/4/
     & vmata*mw**4*rtaw/rwz*rhw+1d0/8/vmata*mw**4*rtaw*rhw**2+1d0/vmata*
     & mw**4*rtaw**2/rwz-1d0/vmata*mw**4*rtaw**2*rhw+2/vmata*mw**4*rtaw*
     & *3)
     & +sdet3itataqs*c0tataqstazta*(3d0/4/stw**2*mw**4*rtaw-3d0/16/stw**
     & 2*mw**4-3d0/4/vmata*mw**4*rtaw/rwz**2-2/qs*mw**6/rwz**3+2/qs*mw**
     & 6/rwz**2-13d0/4*mw**4*rtaw/rwz**2+11d0/4*mw**4*rtaw/rwz-2*mw**4/r
     & wz**3+45d0/16*mw**4/rwz**2-3d0/16*mw**4/rwz)
     & +sdet3itataqs*c0tataqstahta*(-1d0/4/stw**2*mw**4*rtaw*rhw**2+1d0/
     & 16/stw**2*mw**4*rhw**2+1d0/4/vmata*mw**4*rtaw*rhw**2-1d0/vmata*mw
     & **4*rtaw**2*rhw)
     & +sdet3itataqs*c0tataqscwc*(3d0/2/vmata*mw**4*rtaw+2/vmata*mw**4*r
     & taw**2+1d0/2/vmata*mw**4*rtaw**3)
     & +sdet3itataqs*b0ftawc*(11d0/4/vmata*mw**2*rtaw+1d0/vmata*mw**2*rt
     & aw**2-7d0/4/vmata*mw**2)
     & +sdet3itataqs*b0ftazta*(3d0/4/stw**2*mw**2*rtaw-3d0/16/stw**2*mw*
     & *2-3d0/8/vmata*mw**2*rtaw/rwz-1d0/8/vmata*mw**2*rtaw*rhw+1d0/2/vm
     & ata*mw**2*rtaw**2-2/qs*mw**4/rwz**2+2/qs*mw**4/rwz-13d0/4*mw**2*r
     & taw/rwz+2*mw**2*rtaw-2*mw**2/rwz**2+45d0/16*mw**2/rwz)
     & +sdet3itataqs*b0ftahta*(-1d0/4/stw**2*mw**2*rtaw*rhw+1d0/16/stw**
     & 2*mw**2*rhw+3d0/8/vmata*mw**2*rtaw/rwz+1d0/8/vmata*mw**2*rtaw*rhw
     & -1d0/2/vmata*mw**2*rtaw**2)
     & +sdet3itataqs*b0fqsww*(-5d0/4/vmata*mw**2*rtaw-1d0/2/vmata*mw**2*
     & rtaw**2+7d0/4/vmata*mw**2)
     & +sdet3itataqs*b0fqszh*(-3d0/4/vmata*mw**2*rtaw/rwz+1d0/4/vmata*mw
     & **2*rtaw*rhw-1d0/vmata*mw**2*rtaw**2)
     & +sdet3itataqs*b0fqstata*(1d0/4/stw**2*mw**2*rtaw*rhw-3d0/4/stw**2
     & *mw**2*rtaw-1d0/16/stw**2*mw**2*rhw+3d0/16/stw**2*mw**2+3d0/4/vma
     & ta*mw**2*rtaw/rwz-1d0/4/vmata*mw**2*rtaw*rhw+1d0/vmata*mw**2*rtaw
     & **2+2/qs*mw**4/rwz**2-2/qs*mw**4/rwz+13d0/4*mw**2*rtaw/rwz-2*mw**
     & 2*rtaw+2*mw**2/rwz**2-45d0/16*mw**2/rwz)
     & +sdet3itataqs*b0fqscc*(-3d0/2/vmata*mw**2*rtaw-1d0/2/vmata*mw**2*
     & rtaw**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(1
     & d0/2/ctw**2*vmaup*vmata*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/ctw**2*vm
     & aup*vmata*ts*mta**2)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*(-1d0/ctw**2*v
     & maup*vmata*ts*mta**2)
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vmat
     & a*mta**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*pxx2zqsc*(-
     & 1d0/2/ctw**2*vmaup*vpata**2/vmata*us*mta**2)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/ctw**2*vm
     & aup*vpata**2/vmata*mta**4)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*(-1d0/ctw**2*v
     & maup*vpata**2/vmata*mta**4)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpa
     & ta**2/vmata*mta**2)
     & +sdet4itatsus**2*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/4/ctw**2*vmaup*vmata*ts*mta**4+1d0/4/ctw**2*vmaup*vmata*us*mt
     & a**4+1d0/4*sdet3ctats**2/ctw**2*vmaup*vmata*qs+sdet3ctats**2/ctw*
     & *2*vmaup*vmata*mta**2)
     & +sdet4itatsus**2*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/4*sdet3ctaus/ctw**2*vmaup*vpata**2/vmata*us*mta**2+1d0/4*sdet
     & 3ctaus/ctw**2*vmaup*vpata**2/vmata*mta**4)
     & +sdet4itatsus**2*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(1d0/4*sde
     & t3ctats/ctw**2*vmaup*vmata*qs*ts+sdet3ctats/ctw**2*vmaup*vmata*ts
     & *mta**2+1d0/4*sdet3ctaus/ctw**2*vmaup*vpata**2/vmata*qs*mta**2+sd
     & et3ctaus/ctw**2*vmaup*vpata**2/vmata*mta**4)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(-1d0/2*sde
     & t3ctats/ctw**2*vmaup*vmata*ts*mta**2+1d0/2*sdet3ctats/ctw**2*vmau
     & p*vmata*ts**2)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*pxx2zqsc*(1d0/2*sdet
     & 3ctaus/ctw**2*vmaup*vpata**2/vmata*us*mta**2-1d0/2*sdet3ctaus/ctw
     & **2*vmaup*vpata**2/vmata*mta**4)
     & +sdet4itatsus**2*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2
     & *vmaup*vpata**2/vmata*qs*us*mta**2-1d0/4/ctw**2*vmaup*vpata**2/vm
     & ata*qs*mta**4-1d0/4*sdet3ctats**2/ctw**2*vmaup*vmata*ts+1d0/4*sde
     & t3ctats**2/ctw**2*vmaup*vmata*mta**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(3d0/
     & 8/ctw**2*vmaup*vmata*mta**2+1d0/8*sdet3ctats/ctw**2*vmaup*vmata)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc*(-1d0/2/
     & ctw**2*vmaup*vpata*ts*mta**2-3d0/4/ctw**2*vmaup*vmata*ts**2+1d0/4
     & /ctw**2*vmaup*vmata*mta**4)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*(1d0/8*sdet3ctats
     & /ctw**2*vmaup*vmata*qs*ts-1d0/8*sdet3ctats/ctw**2*vmaup*vmata*qs*
     & mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(1d0/
     & 8/ctw**2*vmaup*vpata**2/vmata*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(-1d0/2/
     & ctw**2*vmaup*vpata*mta**4-1d0/4/ctw**2*vmaup*vpata**2/vmata*qs*mt
     & a**2+1d0/2/ctw**2*vmaup*vpata**2/vmata*mta**4-sdet3ctaus/ctw**2*v
     & maup*vpata**2/vmata*mta**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*(-1d0/8/ctw**2*vm
     & aup*vpata**2/vmata*qs*ts*mta**2+1d0/8/ctw**2*vmaup*vpata**2/vmata
     & *qs*us*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2
     & *vmaup*vpata**2/vmata*mta**2+1d0/4/ctw**2*vmaup*vmata*mta**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*v
     & pata**2/vmata*us*mta**2+1d0/2/ctw**2*vmaup*vpata**2/vmata*mta**4+
     & 1d0/2/ctw**2*vmaup*vmata*ts*mta**2-1d0/2/ctw**2*vmaup*vmata*ts**2
     & )
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*(1d0/ctw**2*vmaup*vpata
     & *ts*mta**2+1d0/ctw**2*vmaup*vmata*ts**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*(1d0/ctw**2*vmaup*vpata
     & *mta**4+1d0/ctw**2*vmaup*vpata**2/vmata*us*mta**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2*vm
     & aup*vpata**2/vmata*mta**2-1d0/4/ctw**2*vmaup*vmata*ts)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*(-sdet3ctats/ctw**2*vmaup
     & *vpata*mta**2-1d0/2*sdet3ctats/ctw**2*vmaup*vmata*ts-1d0/2*sdet3c
     & taus/ctw**2*vmaup*vpata**2/vmata*mta**2)
     & +sdet4itatsus*b0fqszz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpata*
     & *2/vmata*mta**2-1d0/2/ctw**2*vmaup*vmata*ts)
     & +sdet4itatsus*b0ftstac*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vmata*
     & ts)
     & +sdet4itatsus*b0fustac*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vpata*
     & *2/vmata*mta**2)
     & +d0cctataqstszczta*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpata*mta
     & **2-1d0/8/ctw**2*vmaup*vmata*qs-1d0/2/ctw**2*vmaup*vmata*ts-1d0/2
     & /ctw**2*vmaup*vmata*mz**2)
     & +d0cctataqsuszczta*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vpata*mta*
     & *2-1d0/2/ctw**2*vmaup*vpata**2/vmata*mta**2+1d0/2*sdet3ctaus/ctw*
     & *2*vmaup*vmata)
     & +c0tataqswcw*(3d0/2/vmata/qs*mw**4*rtaw+1d0/4/vmata/qs*mw**4*rtaw
     & **2-7d0/4/vmata/qs*mw**4)
     & +c0tataqsztaz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vmata)
     & +c0tataqsztah*(3d0/8/vmata/qs*mw**4*rtaw/rwz**2-1d0/4/vmata/qs*mw
     & **4*rtaw/rwz*rhw-1d0/8/vmata/qs*mw**4*rtaw*rhw**2-1d0/2/vmata*mw*
     & *2*rtaw**2-1d0/qs*mw**4*rtaw/rwz**2+1d0/qs*mw**4*rtaw/rwz*rhw+mw*
     & *2*rtaw/rwz)
     & +c0tataqstazta*(-1d0/2/stw**2/qs*mw**4*rtaw+3d0/16/stw**2/qs*mw**
     & 4-1d0/2/stw**2*mw**2*rtaw+1d0/2/vmata*mw**2*rtaw/rwz-5d0/2/qs*mw*
     & *4*rtaw/rwz+4/qs*mw**4*rtaw+51d0/16/qs*mw**4/rwz**2-61d0/16/qs*mw
     & **4/rwz-2*qs/rwz+2*qs-7d0/2*mw**2*rtaw/rwz+4*mw**2*rtaw+4*mw**2/r
     & wz**2-6*mw**2/rwz+2*mw**2)
     & +c0tataqstahta*(1d0/stw**2/qs*mw**4*rtaw**2-1d0/16/stw**2/qs*mw**
     & 4*rhw**2+1d0/stw**2*mw**2*rtaw**2)
     & +c0tataqscwc*(-1d0/vmata*mw**2*rtaw)
     & +c0ccqszcz*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vmata)
     & +c0ccqsczc*(1d0/stw**2*vpaup/qs**2*mw**6-1d0/stw**2*vpaup/qs*mw**
     & 4+1d0/stw**2*vpaup*qs-1d0/stw**2*vpaup*mw**2-1d0/2/stw**2*vpaup**
     & 2/qs**2*mw**6+1d0/2/stw**2*vpaup**2/qs*mw**4-1d0/2/stw**2*vpaup**
     & 2*qs+1d0/2/stw**2*vpaup**2*mw**2-1d0/2/stw**2/qs**2*mw**6+1d0/2/s
     & tw**2/qs*mw**4-1d0/2/stw**2*qs+1d0/2/stw**2*mw**2+vpaup/qs**2*mw*
     & *6/rwz**3+vpaup/qs**2*mw**6/rwz**2+vpaup/qs**2*mw**6/rwz+vpaup/qs
     & *mw**4/rwz**3-vpaup/qs*mw**4/rwz**2-vpaup/qs*mw**4/rwz+vpaup*qs/r
     & wz-2*vpaup*mw**2/rwz**2-vpaup*mw**2/rwz-1d0/2*vpaup**2/qs**2*mw**
     & 6/rwz**3-1d0/2*vpaup**2/qs**2*mw**6/rwz**2-1d0/2*vpaup**2/qs**2*m
     & w**6/rwz-1d0/2*vpaup**2/qs*mw**4/rwz**3+1d0/2*vpaup**2/qs*mw**4/r
     & wz**2+1d0/2*vpaup**2/qs*mw**4/rwz-1d0/2*vpaup**2*qs/rwz+vpaup**2*
     & mw**2/rwz**2+1d0/2*vpaup**2*mw**2/rwz-1d0/2/qs**2*mw**6/rwz**3-1d
     & 0/2/qs**2*mw**6/rwz**2-1d0/2/qs**2*mw**6/rwz-1d0/2/qs*mw**4/rwz**
     & 3+1d0/2/qs*mw**4/rwz**2+1d0/2/qs*mw**4/rwz-1d0/2*qs/rwz+mw**2/rwz
     & **2+1d0/2*mw**2/rwz)
     & +a0fw*dreal(propzqs)*(3*mw**2/rwz/rhw+1d0/6*mw**2/rwz-4*mw**2*rwz
     & -8d0/3*mw**2)
     & +a0fw*(-4/qs**2*mw**4+4/qs*mw**2*rwz+8d0/3/qs*mw**2)
     & +a0fz*dreal(propzqs)*(3d0/2*mw**2/rwz**3/rhw+1d0/6*mw**2/rwz**2-1
     & d0/12*mw**2/rwz*rhw)
     & +a0fz*(-1d0/stw**2*vpaup/qs**2*mw**4+1d0/2/stw**2*vpaup/qs*mw**2+
     & 3d0/2/stw**2*vpaup+1d0/2/stw**2*vpaup**2/qs**2*mw**4-1d0/4/stw**2
     & *vpaup**2/qs*mw**2-3d0/4/stw**2*vpaup**2+1d0/2/stw**2/qs**2*mw**4
     & -3d0/8/stw**2/qs*mw**2-7d0/8/stw**2-vpaup/qs**2*mw**4/rwz**2-vpau
     & p/qs**2*mw**4/rwz-vpaup/qs*mw**2/rwz**2+1d0/2*vpaup/qs*mw**2/rwz+
     & 3d0/2*vpaup/rwz+1d0/2*vpaup**2/qs**2*mw**4/rwz**2+1d0/2*vpaup**2/
     & qs**2*mw**4/rwz+1d0/2*vpaup**2/qs*mw**2/rwz**2-1d0/4*vpaup**2/qs*
     & mw**2/rwz-3d0/4*vpaup**2/rwz+1d0/2/qs**2*mw**4/rwz**2+1d0/2/qs**2
     & *mw**4/rwz+5d0/12/qs*mw**2/rwz**2+1d0/12/qs*mw**2/rwz*rhw-3d0/8/q
     & s*mw**2/rwz-7d0/8/rwz)
     & +a0fh*dreal(propzqs)*(1d0/2*mw**2/rwz*rhw+1d0/12*mw**2*rhw**2)
     & +a0fh*(-1d0/8/stw**2/qs*mw**2*rhw-1d0/8/stw**2*rhw+1d0/12/qs*mw**
     & 2/rwz*rhw-1d0/12/qs*mw**2*rhw**2)
     & +a0fta*(-1+1d0/4/stw**2/qs*mw**2*rtaw+1d0/4/stw**2/qs*mw**2+1d0/4
     & /stw**2*rtaw+1d0/4/stw**2+1d0/4/qs*mw**2/rwz-1d0/qs*mw**2+1d0/4/r
     & wz)
     & +b0ftawc*(-1d0/4/stw**2/qs*mw**2*rtaw-1d0/4/stw**2*rtaw+1d0/4/vma
     & ta/qs*mw**2*rtaw+7d0/4/vmata/qs*mw**2)
     & +b0ftazta*(-4+5d0/16/stw**2/qs*mw**2+1d0/8/stw**2+3d0/8/vmata/qs*
     & mw**2*rtaw/rwz+1d0/8/vmata/qs*mw**2*rtaw*rhw-1d0/qs*mw**2*rtaw/rw
     & z+37d0/16/qs*mw**2/rwz-4/qs*mw**2+25d0/8/rwz)
     & +b0ftahta*(-3d0/16/stw**2/qs*mw**2*rhw-1d0/8/stw**2*rhw-3d0/8/vma
     & ta/qs*mw**2*rtaw/rwz-1d0/8/vmata/qs*mw**2*rtaw*rhw+1d0/qs*mw**2*r
     & taw/rwz)
     & +b0fqsww*dreal(propzqs)*(1d0/12*mw**2/rwz**2+4d0/3*mw**2/rwz-4*mw
     & **2*rwz-17d0/3*mw**2)
     & +b0fqsww*(1d0/4/vmata/qs*mw**2*rtaw-7d0/4/vmata/qs*mw**2+1d0/4/vm
     & ata*rtaw-4/qs**2*mw**4+4/qs*mw**2*rwz+17d0/3/qs*mw**2-1d0/12/rwz)
     & 
     & +b0fqszh*dreal(propzqs)*(mw**2/rwz**2-1d0/3*mw**2/rwz*rhw+1d0/12*
     & mw**2*rhw**2)
     & +b0fqszh*(1d0/4/vmata*rtaw-1d0/12/qs*mw**2/rwz**2+1d0/6/qs*mw**2/
     & rwz*rhw-1d0/12/qs*mw**2*rhw**2-1d0/12/rwz)
     & +b0fqstata*(3+1d0/4/stw**2/qs*mw**2*rtaw+1d0/16/stw**2/qs*mw**2*r
     & hw-3d0/16/stw**2/qs*mw**2+1d0/4/stw**2*rtaw-1d0/4/vmata*rtaw-35d0
     & /16/qs*mw**2/rwz+3/qs*mw**2-3/rwz)
     & +b0fqscc*(-1d0/stw**2*vpaup/qs**2*mw**4+1d0/2/stw**2*vpaup/qs*mw*
     & *2+3d0/2/stw**2*vpaup+1d0/2/stw**2*vpaup**2/qs**2*mw**4-1d0/4/stw
     & **2*vpaup**2/qs*mw**2-3d0/4/stw**2*vpaup**2+1d0/2/stw**2/qs**2*mw
     & **4-1d0/4/stw**2/qs*mw**2-3d0/4/stw**2-vpaup/qs**2*mw**4/rwz**2-v
     & paup/qs**2*mw**4/rwz-vpaup/qs*mw**2/rwz**2+1d0/2*vpaup/qs*mw**2/r
     & wz+3d0/2*vpaup/rwz+1d0/2*vpaup**2/qs**2*mw**4/rwz**2+1d0/2*vpaup*
     & *2/qs**2*mw**4/rwz+1d0/2*vpaup**2/qs*mw**2/rwz**2-1d0/4*vpaup**2/
     & qs*mw**2/rwz-3d0/4*vpaup**2/rwz+1d0/4/vmata*rtaw+1d0/2/qs**2*mw**
     & 4/rwz**2+1d0/2/qs**2*mw**4/rwz+1d0/2/qs*mw**2/rwz**2-1d0/4/qs*mw*
     & *2/rwz-3d0/4/rwz)
     & +dreal(propzqs)*(mw**2/rwz**3/rhw-1d0/18*mw**2/rwz**2+2*mw**2/rwz
     & /rhw-1d0/6*mw**2/rwz*rhw-mw**2/rwz*zmzzzbos-5d0/9*mw**2/rwz-4*mw*
     & *2*rwz-8d0/3*mw**2)
     & +dreal(b0ptazta)*(1d0/4/stw**2/qs*mw**4*rtaw-1d0/4/stw**2/qs*mw**
     & 4+1d0/4/stw**2*mw**2*rtaw-1d0/4/stw**2*mw**2-7d0/4/qs*mw**4*rtaw/
     & rwz+4/qs*mw**4*rtaw-5d0/4/qs*mw**4/rwz**2+7d0/4/qs*mw**4/rwz-7d0/
     & 4*mw**2*rtaw/rwz+4*mw**2*rtaw-5d0/4*mw**2/rwz**2+7d0/4*mw**2/rwz)
     & 
     & +dreal(b0ptahta)*(-1d0/4/stw**2/qs*mw**4*rtaw*rhw+1d0/stw**2/qs*m
     & w**4*rtaw**2-1d0/4/stw**2*mw**2*rtaw*rhw+1d0/stw**2*mw**2*rtaw**2
     & )
     & +dreal(b0ptacw)*(1d0/4/stw**2/qs*mw**4*rtaw+1d0/4/stw**2/qs*mw**4
     & *rtaw**2-1d0/2/stw**2/qs*mw**4+1d0/4/stw**2*mw**2*rtaw+1d0/4/stw*
     & *2*mw**2*rtaw**2-1d0/2/stw**2*mw**2)
     & +b0dwtacw*(-1d0/2/stw**2/qs*mw**2-1d0/2/stw**2)
     & +b0d1tataz*(1-1d0/4/stw**2/qs*mw**2-1d0/4/stw**2-1d0/4/qs*mw**2/r
     & wz+1d0/qs*mw**2-1d0/4/rwz)
     & +1+1d0/4/stw**2*vpaup/qs*mw**2+1d0/4/stw**2*vpaup-1d0/8/stw**2*vp
     & aup**2/qs*mw**2-1d0/8/stw**2*vpaup**2-1d0/4/stw**2/qs*mw**2*rtaw-
     & 1d0/stw**2/qs*mw**2*za1bos-1d0/8/stw**2/qs*mw**2-1d0/4/stw**2*rta
     & w-1d0/stw**2*za1bos-1d0/stw**2*deltarhobos-1d0/stw**2*deltarhofer
     & -1d0/8/stw**2+1d0/4*vpaup/qs*mw**2/rwz+1d0/4*vpaup/rwz-1d0/8*vpau
     & p**2/qs*mw**2/rwz-1d0/8*vpaup**2/rwz+1d0/2/vmata/qs*mw**2*rtaw+1d
     & 0/2/vmata*rtaw-4/qs**2*mw**4-9d0/8/qs*mw**2/rwz+4/qs*mw**2*rwz+11
     & d0/3/qs*mw**2-89d0/72/rwz-za1fer+caldzfer-2*pizgfer

      ff_ew_ld =
     & +det3itataqs*sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(
     & -1d0/8/ctw**2*vpaup**2*vpata**2*qs*ts+1d0/8/ctw**2*vpaup**2*vpata
     & **2*qs*mta**2+1d0/8/ctw**2*vpaup**2*vmata**2*qs*us-1d0/8/ctw**2*v
     & paup**2*vmata**2*qs*mta**2-1d0/8/ctw**2*vmaup**2*vpata**2*qs*us+1
     & d0/8/ctw**2*vmaup**2*vpata**2*qs*mta**2+1d0/8/ctw**2*vmaup**2*vma
     & ta**2*qs*ts-1d0/8/ctw**2*vmaup**2*vmata**2*qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/4/ctw**2*
     & vpaup**2*vpata**2*qs*ts-1d0/4/ctw**2*vpaup**2*vpata**2*qs*mta**2-
     & 1d0/4/ctw**2*vpaup**2*vmata**2*qs*us+1d0/4/ctw**2*vpaup**2*vmata*
     & *2*qs*mta**2+1d0/4/ctw**2*vmaup**2*vpata**2*qs*us-1d0/4/ctw**2*vm
     & aup**2*vpata**2*qs*mta**2-1d0/4/ctw**2*vmaup**2*vmata**2*qs*ts+1d
     & 0/4/ctw**2*vmaup**2*vmata**2*qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0fqszz*dreal(propizqs)*(-1d0/4/ctw**2*
     & vpaup**2*vpata**2*qs*ts+1d0/4/ctw**2*vpaup**2*vpata**2*qs*mta**2+
     & 1d0/4/ctw**2*vpaup**2*vmata**2*qs*us-1d0/4/ctw**2*vpaup**2*vmata*
     & *2*qs*mta**2-1d0/4/ctw**2*vmaup**2*vpata**2*qs*us+1d0/4/ctw**2*vm
     & aup**2*vpata**2*qs*mta**2+1d0/4/ctw**2*vmaup**2*vmata**2*qs*ts-1d
     & 0/4/ctw**2*vmaup**2*vmata**2*qs*mta**2)
     & +sdet3itataqs**2*c0tataqswcw*dreal(propizqs)*(-3*mw**2*rtaw*rwz+6
     & *mw**2*rtaw**2*rwz-3*mw**2*rtaw**3*rwz)
     & +sdet3itataqs**2*c0tataqswcw*(-18*mw**4*rtaw*rwz-12*mw**4*rtaw**2
     & *rwz+30*mw**4*rtaw**3*rwz-12*mw**4*rtaw**4*rwz+12*mw**4*rwz)
     & +sdet3itataqs**2*c0tataqstazta*(9d0/2*mw**4*rtaw/rwz**2-6*mw**4*r
     & taw/rwz+27*mw**4/rwz**3-90*mw**4/rwz**2+108*mw**4/rwz-48*mw**4)
     & +sdet3itataqs**2*c0tataqstahta*(-6*mw**4*rtaw*rwz*rhw**2+9d0/2*mw
     & **4*rtaw*rhw**2)
     & +sdet3itataqs**2*c0tataqscwc*(15*mw**4*rtaw+12*mw**4*rtaw**2+3*mw
     & **4*rtaw**3+6*mw**4)
     & +sdet3itataqs**2*b0ftawc*(6*mw**2*rtaw*rwz+12*mw**2*rtaw+6*mw**2*
     & rtaw**2*rwz-12*mw**2*rwz+6*mw**2)
     & +sdet3itataqs**2*b0ftazta*(9d0/2*mw**2*rtaw/rwz-6*mw**2*rtaw+27*m
     & w**2/rwz**2-90*mw**2/rwz-48*mw**2*rwz+108*mw**2)
     & +sdet3itataqs**2*b0ftahta*(-6*mw**2*rtaw*rwz*rhw+9d0/2*mw**2*rtaw
     & *rhw)
     & +sdet3itataqs**2*b0fqsww*dreal(propizqs)*(-3*rtaw*rwz+3*rtaw**2*r
     & wz)
     & +sdet3itataqs**2*b0fqsww*(-6*mw**2*rtaw*rwz-18*mw**2*rtaw**2*rwz+
     & 12*mw**2*rtaw**3*rwz+12*mw**2*rwz)
     & +sdet3itataqs**2*b0fqstata*(-9d0/2*mw**2*rtaw/rwz+6*mw**2*rtaw*rw
     & z*rhw-9d0/2*mw**2*rtaw*rhw+6*mw**2*rtaw-27*mw**2/rwz**2+90*mw**2/
     & rwz+48*mw**2*rwz-108*mw**2)
     & +sdet3itataqs**2*b0fqscc*(-9*mw**2*rtaw-3*mw**2*rtaw**2-6*mw**2)
     & +sdet3itataqs*c0tataqswcw*dreal(propizqs)*(-3*rtaw*rwz+rtaw**2*rw
     & z+2*rwz)
     & +sdet3itataqs*c0tataqswcw*(17*mw**2*rtaw*rwz-20*mw**2*rtaw**2*rwz
     & +7*mw**2*rtaw**3*rwz-4*mw**2*rwz)
     & +sdet3itataqs*c0tataqsztah*(6*mw**2*rtaw/rwz-8*mw**2*rtaw-3d0/2*m
     & w**2/rwz**2-3d0/2*mw**2/rwz*rhw+2*mw**2/rwz+2*mw**2*rhw)
     & +sdet3itataqs*c0tataqstazta*(-3d0/2*mw**2*rtaw/rwz+2*mw**2*rtaw-2
     & 4*mw**2/rwz**2+68*mw**2/rwz+32*mw**2*rwz-72*mw**2)
     & +sdet3itataqs*c0tataqstahta*(6*mw**2*rtaw*rwz*rhw-9d0/2*mw**2*rta
     & w*rhw)
     & +sdet3itataqs*c0tataqscwc*(-8*mw**2*rtaw-mw**2*rtaw**2-8*mw**2)
     & +sdet3itataqs*a0fw*(1+8/qs*mw**2*rwz-4/qs*mw**2-rwz)
     & +sdet3itataqs*a0fz*(-1-18/qs*mw**2/rwz**2+60/qs*mw**2/rwz+32/qs*m
     & w**2*rwz-72/qs*mw**2+3d0/4/rwz)
     & +sdet3itataqs*a0fh*(-rwz*rhw+3d0/4*rhw)
     & +sdet3itataqs*a0fta*(15+2*rtaw*rwz-3d0/2*rtaw-9d0/2/rwz-18*rwz+8*
     & rwz**2)
     & +sdet3itataqs*b0ftawc*dreal(propizqs)*(-1d0/mw**2*rwz)
     & +sdet3itataqs*b0ftawc*(-5+8/qs*mw**2*rwz-4/qs*mw**2-5*rtaw*rwz+5*
     & rwz)
     & +sdet3itataqs*b0ftazta*(35-18/qs*mw**2/rwz**2+60/qs*mw**2/rwz+32/
     & qs*mw**2*rwz-72/qs*mw**2-51d0/4/rwz-36*rwz+16*rwz**2)
     & +sdet3itataqs*b0ftahta*(-2+4*rtaw*rwz-3*rtaw+3d0/2/rwz-rwz*rhw+3d
     & 0/4*rhw)
     & +sdet3itataqs*b0fqsww*dreal(propizqs)*(-1d0/2/mw**2*rtaw*rwz+2/mw
     & **2*rwz)
     & +sdet3itataqs*b0fqsww*(12*rtaw*rwz-5*rtaw**2*rwz-6*rwz)
     & +sdet3itataqs*b0fqszh*(4-3/rwz)
     & +sdet3itataqs*b0fqstata*(-23-2*rtaw*rwz+3d0/2*rtaw+21d0/2/rwz+18*
     & rwz-8*rwz**2)
     & +sdet3itataqs*b0fqscc*(5+1d0/2*rtaw)
     & +sdet3itataqs*(-14-rtaw*rwz+3d0/2*rtaw+9d0/2/rwz+20*rwz-8*rwz**2)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(-
     & 1d0/2/ctw**2*vpaup**2*vpata**2*ts+1d0/2/ctw**2*vmaup**2*vmata**2*
     & ts)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/ctw**2*v
     & paup**2*vpata**2*ts+1d0/ctw**2*vmaup**2*vmata**2*ts)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*(1d0/ctw**2*vp
     & aup**2*vpata**2*ts-1d0/ctw**2*vmaup**2*vmata**2*ts)
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*
     & vpata**2+1d0/2/ctw**2*vmaup**2*vmata**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*pxx2zqsc*(1
     & d0/2/ctw**2*vpaup**2*vmata**2*us-1d0/2/ctw**2*vmaup**2*vpata**2*u
     & s)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/ctw**2*vp
     & aup**2*vmata**2*us-1d0/ctw**2*vmaup**2*vpata**2*us)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*(-1d0/ctw**2*v
     & paup**2*vmata**2*us+1d0/ctw**2*vmaup**2*vpata**2*us)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*v
     & mata**2-1d0/2/ctw**2*vmaup**2*vpata**2)
     & +sdet4itatsus**2*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/2*sdet3ctats/ctw**2*vpaup**2*vpata**2*ts+1d0/2*sdet3ctats/ctw
     & **2*vmaup**2*vmata**2*ts)
     & +sdet4itatsus**2*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(1
     & d0/2*sdet3ctaus/ctw**2*vpaup**2*vmata**2*us-1d0/2*sdet3ctaus/ctw*
     & *2*vmaup**2*vpata**2*us)
     & +sdet4itatsus**2*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/2*sd
     & et3ctats/ctw**2*vpaup**2*vpata**2*ts+1d0/2*sdet3ctats/ctw**2*vpau
     & p**2*vpata**2*mta**2+1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata**2*ts
     & -1d0/2*sdet3ctats/ctw**2*vmaup**2*vmata**2*mta**2+1d0/2*sdet3ctau
     & s/ctw**2*vpaup**2*vmata**2*us-1d0/2*sdet3ctaus/ctw**2*vpaup**2*vm
     & ata**2*mta**2-1d0/2*sdet3ctaus/ctw**2*vmaup**2*vpata**2*us+1d0/2*
     & sdet3ctaus/ctw**2*vmaup**2*vpata**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(sdet3ctats
     & /ctw**2*vpaup**2*vpata**2*ts-sdet3ctats/ctw**2*vmaup**2*vmata**2*
     & ts)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*pxx2zqsc*(-sdet3ctau
     & s/ctw**2*vpaup**2*vmata**2*us+sdet3ctaus/ctw**2*vmaup**2*vpata**2
     & *us)
     & +sdet4itatsus**2*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(1d0/2/ctw**2
     & *vpaup**2*vpata**2*qs*ts-1d0/2/ctw**2*vpaup**2*vmata**2*qs*us+1d0
     & /2/ctw**2*vmaup**2*vpata**2*qs*us-1d0/2/ctw**2*vmaup**2*vmata**2*
     & qs*ts)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc*(1d0/2/c
     & tw**2*vpaup**2*vpata*vmata*ts+1d0/2/ctw**2*vpaup**2*vpata**2*mta*
     & *2-1d0/2/ctw**2*vmaup**2*vpata*vmata*ts-1d0/2/ctw**2*vmaup**2*vma
     & ta**2*mta**2-5d0/4*sdet3ctats/ctw**2*vpaup**2*vpata**2+5d0/4*sdet
     & 3ctats/ctw**2*vmaup**2*vmata**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*(1d0/4*sdet3ctats
     & /ctw**2*vpaup**2*vpata**2*qs-1d0/4*sdet3ctats/ctw**2*vmaup**2*vma
     & ta**2*qs)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(-1d0/2/
     & ctw**2*vpaup**2*vpata*vmata*us-1d0/2/ctw**2*vpaup**2*vmata**2*mta
     & **2+1d0/2/ctw**2*vmaup**2*vpata*vmata*us+1d0/2/ctw**2*vmaup**2*vp
     & ata**2*mta**2+5d0/4*sdet3ctaus/ctw**2*vpaup**2*vmata**2-5d0/4*sde
     & t3ctaus/ctw**2*vmaup**2*vpata**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*(-1d0/4*sdet3ctau
     & s/ctw**2*vpaup**2*vmata**2*qs+1d0/4*sdet3ctaus/ctw**2*vmaup**2*vp
     & ata**2*qs)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2
     & *vpaup**2*vpata**2-1d0/4/ctw**2*vpaup**2*vmata**2+1d0/4/ctw**2*vm
     & aup**2*vpata**2-1d0/4/ctw**2*vmaup**2*vmata**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2
     & *vpata*vmata*ts-1d0/2/ctw**2*vpaup**2*vpata*vmata*us-1d0/4/ctw**2
     & *vpaup**2*vpata**2*qs-1d0/ctw**2*vpaup**2*vpata**2*ts+1d0/4/ctw**
     & 2*vpaup**2*vmata**2*qs+1d0/ctw**2*vpaup**2*vmata**2*us-1d0/2/ctw*
     & *2*vmaup**2*vpata*vmata*ts+1d0/2/ctw**2*vmaup**2*vpata*vmata*us-1
     & d0/4/ctw**2*vmaup**2*vpata**2*qs-1d0/ctw**2*vmaup**2*vpata**2*us+
     & 1d0/4/ctw**2*vmaup**2*vmata**2*qs+1d0/ctw**2*vmaup**2*vmata**2*ts
     & )
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*(-1d0/ctw**2*vpaup**2*v
     & pata*vmata*ts+3d0/2/ctw**2*vpaup**2*vpata**2*ts+1d0/2/ctw**2*vpau
     & p**2*vpata**2*mta**2+1d0/ctw**2*vmaup**2*vpata*vmata*ts-3d0/2/ctw
     & **2*vmaup**2*vmata**2*ts-1d0/2/ctw**2*vmaup**2*vmata**2*mta**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*(1d0/ctw**2*vpaup**2*vp
     & ata*vmata*us-3d0/2/ctw**2*vpaup**2*vmata**2*us-1d0/2/ctw**2*vpaup
     & **2*vmata**2*mta**2-1d0/ctw**2*vmaup**2*vpata*vmata*us+3d0/2/ctw*
     & *2*vmaup**2*vpata**2*us+1d0/2/ctw**2*vmaup**2*vpata**2*mta**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(1d0/4/ctw**2*vp
     & aup**2*vpata**2-1d0/4/ctw**2*vpaup**2*vmata**2+1d0/4/ctw**2*vmaup
     & **2*vpata**2-1d0/4/ctw**2*vmaup**2*vmata**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vp
     & ata*vmata*ts-1d0/2/ctw**2*vpaup**2*vpata*vmata*us+1d0/4/ctw**2*vp
     & aup**2*vpata**2*qs-1d0/4/ctw**2*vpaup**2*vmata**2*qs-1d0/2/ctw**2
     & *vmaup**2*vpata*vmata*ts+1d0/2/ctw**2*vmaup**2*vpata*vmata*us+1d0
     & /4/ctw**2*vmaup**2*vpata**2*qs-1d0/4/ctw**2*vmaup**2*vmata**2*qs-
     & 1d0/2*sdet3ctats/ctw**2*vpaup**2*vpata**2+1d0/2*sdet3ctats/ctw**2
     & *vmaup**2*vmata**2+1d0/2*sdet3ctaus/ctw**2*vpaup**2*vmata**2-1d0/
     & 2*sdet3ctaus/ctw**2*vmaup**2*vpata**2)
     & +d0cctataqstszczta*dreal(propizqs)*(1d0/2/ctw**2*vpaup**2*vpata*v
     & mata-1d0/2/ctw**2*vpaup**2*vpata**2-1d0/2/ctw**2*vmaup**2*vpata*v
     & mata+1d0/2/ctw**2*vmaup**2*vmata**2)
     & +d0cctataqsuszczta*dreal(propizqs)*(-1d0/2/ctw**2*vpaup**2*vpata*
     & vmata+1d0/2/ctw**2*vpaup**2*vmata**2+1d0/2/ctw**2*vmaup**2*vpata*
     & vmata-1d0/2/ctw**2*vmaup**2*vpata**2)
     & +c0tataqswcw*(3*rtaw*rwz-rtaw**2*rwz-2*rwz)
     & +c0tataqsztah*(3d0/2/qs*mw**2/rwz**2-3d0/2/qs*mw**2/rwz*rhw-2/qs*
     & mw**2/rwz+2/qs*mw**2*rhw)
     & +c0tataqstazta*(-4+3/rwz)
     & +c0tataqscwc*(2)
     & +b0ftawc*(1d0/mw**2*rwz)
     & +b0ftazta*(3d0/2/qs/rwz-2/qs)
     & +b0ftahta*(-3d0/2/qs/rwz+2/qs)
     & +b0fqsww*(1d0/2/mw**2*rtaw*rwz-2/mw**2*rwz)
     & +b0dwtacw*(-2/qs*rwz+1d0/qs)
     & +b0d1tataz*(9d0/2/qs/rwz+18/qs*rwz-8/qs*rwz**2-15/qs)

      ff_ew_qd =
     & +det3itataqs*sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(
     & 1d0/8/ctw**2*vmaup*vpata**2*qs*us-1d0/8/ctw**2*vmaup*vpata**2*qs*
     & mta**2-1d0/8/ctw**2*vmaup*vmata**2*qs*ts+1d0/8/ctw**2*vmaup*vmata
     & **2*qs*mta**2)
     & +det3itataqs*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/4/ctw**2
     & *vmaup*vpata**2*qs*us+1d0/4/ctw**2*vmaup*vpata**2*qs*mta**2+1d0/4
     & /ctw**2*vmaup*vmata**2*qs*ts-1d0/4/ctw**2*vmaup*vmata**2*qs*mta**
     & 2)
     & +det3itataqs*sdet4itatsus*b0fqszz*dreal(propizqs)*(1d0/4/ctw**2*v
     & maup*vpata**2*qs*us-1d0/4/ctw**2*vmaup*vpata**2*qs*mta**2-1d0/4/c
     & tw**2*vmaup*vmata**2*qs*ts+1d0/4/ctw**2*vmaup*vmata**2*qs*mta**2)
     & 
     & +sdet3itataqs**2*c0tataqswcw*(-12/qs*mw**6-3*mw**4*rtaw+15d0/2*mw
     & **4*rtaw**2-3*mw**4*rtaw**3-9d0/2*mw**4)
     & +sdet3itataqs**2*c0tataqstazta*(30/qs*mw**6/rwz**3-72/qs*mw**6/rw
     & z**2+48/qs*mw**6/rwz+9d0/2*mw**4*rtaw/rwz**2+27*mw**4/rwz**3-123d
     & 0/2*mw**4/rwz**2+36*mw**4/rwz)
     & +sdet3itataqs**2*c0tataqstahta*(9d0/2*mw**4*rtaw*rhw**2-3d0/2*mw*
     & *4*rhw**2)
     & +sdet3itataqs**2*c0tataqscwc*(15*mw**4*rtaw+12*mw**4*rtaw**2+3*mw
     & **4*rtaw**3+6*mw**4)
     & +sdet3itataqs**2*b0ftawc*(12/qs*mw**4+27d0/2*mw**2*rtaw+15d0/2*mw
     & **2)
     & +sdet3itataqs**2*b0ftazta*(30/qs*mw**4/rwz**2-72/qs*mw**4/rwz+48/
     & qs*mw**4+9d0/2*mw**2*rtaw/rwz+27*mw**2/rwz**2-123d0/2*mw**2/rwz+3
     & 6*mw**2)
     & +sdet3itataqs**2*b0ftahta*(9d0/2*mw**2*rtaw*rhw-3d0/2*mw**2*rhw)
     & +sdet3itataqs**2*b0fqsww*(-12/qs*mw**4-9d0/2*mw**2*rtaw+3*mw**2*r
     & taw**2-3d0/2*mw**2)
     & +sdet3itataqs**2*b0fqstata*(-30/qs*mw**4/rwz**2+72/qs*mw**4/rwz-4
     & 8/qs*mw**4-9d0/2*mw**2*rtaw/rwz-9d0/2*mw**2*rtaw*rhw-27*mw**2/rwz
     & **2+123d0/2*mw**2/rwz+3d0/2*mw**2*rhw-36*mw**2)
     & +sdet3itataqs**2*b0fqscc*(-9*mw**2*rtaw-3*mw**2*rtaw**2-6*mw**2)
     & +sdet3itataqs*c0tataqswcw*(17d0/2/qs*mw**4-25d0/8*mw**2*rtaw+mw**
     & 2*rtaw**2+7d0/2*mw**2)
     & +sdet3itataqs*c0tataqsztah*(6*mw**2*rtaw/rwz-8*mw**2*rtaw-3d0/2*m
     & w**2/rwz**2-3d0/2*mw**2/rwz*rhw+2*mw**2/rwz+2*mw**2*rhw)
     & +sdet3itataqs*c0tataqstazta*(-45d0/2/qs*mw**4/rwz**2+48/qs*mw**4/
     & rwz-32/qs*mw**4-3d0/2*mw**2*rtaw/rwz-24*mw**2/rwz**2+89d0/2*mw**2
     & /rwz-24*mw**2)
     & +sdet3itataqs*c0tataqstahta*(3d0/2/qs*mw**4*rhw**2-9d0/2*mw**2*rt
     & aw*rhw+3d0/2*mw**2*rhw)
     & +sdet3itataqs*c0tataqscwc*(-8*mw**2*rtaw-mw**2*rtaw**2-8*mw**2)
     & +sdet3itataqs*a0fw*(1-8/qs**2*mw**4-3/qs*mw**2)
     & +sdet3itataqs*a0fz*(-20/qs**2*mw**4/rwz**2+48/qs**2*mw**4/rwz-32/
     & qs**2*mw**4-18/qs*mw**2/rwz**2+41/qs*mw**2/rwz-24/qs*mw**2+3d0/4/
     & rwz)
     & +sdet3itataqs*a0fh*(1d0/qs*mw**2*rhw+3d0/4*rhw)
     & +sdet3itataqs*a0fta*(21d0/2-5/qs*mw**2/rwz-8/qs*mw**2*rwz+12/qs*m
     & w**2-3d0/2*rtaw-9d0/2/rwz-6*rwz)
     & +sdet3itataqs*b0ftawc*(-47d0/8-8/qs**2*mw**4-21d0/2/qs*mw**2)
     & +sdet3itataqs*b0ftazta*(22-20/qs**2*mw**4/rwz**2+48/qs**2*mw**4/r
     & wz-32/qs**2*mw**4-18/qs*mw**2/rwz**2+57d0/2/qs*mw**2/rwz-16/qs*mw
     & **2*rwz-51d0/4/rwz-12*rwz)
     & +sdet3itataqs*b0ftahta*(-1+5d0/2/qs*mw**2*rhw-3*rtaw+3d0/2/rwz+3d
     & 0/4*rhw)
     & +sdet3itataqs*b0fqsww*(15d0/8+15d0/2/qs*mw**2-1d0/2*rtaw)
     & +sdet3itataqs*b0fqszh*(4-3/rwz)
     & +sdet3itataqs*b0fqstata*(-29d0/2+15d0/2/qs*mw**2/rwz+8/qs*mw**2*r
     & wz-3d0/2/qs*mw**2*rhw-12/qs*mw**2+3d0/2*rtaw+21d0/2/rwz+6*rwz)
     & +sdet3itataqs*b0fqscc*(5+1d0/2*rtaw)
     & +sdet3itataqs*(-37d0/4+5/qs*mw**2/rwz+8/qs*mw**2*rwz-14/qs*mw**2+
     & 3d0/2*rtaw+9d0/2/rwz+6*rwz)
     & +sdet3ictats*sdet4itatsus*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(-
     & 1d0/2/ctw**2*vmaup*vmata**2*ts)
     & +sdet3ictats*sdet4itatsus*b0ftazta*dreal(propizqs)*(-1d0/ctw**2*v
     & maup*vmata**2*ts)
     & +sdet3ictats*sdet4itatsus*b0ftstac*dreal(propizqs)*(1d0/ctw**2*vm
     & aup*vmata**2*ts)
     & +sdet3ictats*c0ctatsczta*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vma
     & ta**2)
     & +sdet3ictaus*sdet4itatsus*c0ctausczta*dreal(propizqs)*pxx2zqsc*(1
     & d0/2/ctw**2*vmaup*vpata**2*us)
     & +sdet3ictaus*sdet4itatsus*b0ftazta*dreal(propizqs)*(1d0/ctw**2*vm
     & aup*vpata**2*us)
     & +sdet3ictaus*sdet4itatsus*b0fustac*dreal(propizqs)*(-1d0/ctw**2*v
     & maup*vpata**2*us)
     & +sdet3ictaus*c0ctausczta*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vpat
     & a**2)
     & +sdet4itatsus**2*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc**2*(-
     & 1d0/2*sdet3ctats/ctw**2*vmaup*vmata**2*ts)
     & +sdet4itatsus**2*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc**2*(1
     & d0/2*sdet3ctaus/ctw**2*vmaup*vpata**2*us)
     & +sdet4itatsus**2*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/2*sd
     & et3ctats/ctw**2*vmaup*vmata**2*ts+1d0/2*sdet3ctats/ctw**2*vmaup*v
     & mata**2*mta**2+1d0/2*sdet3ctaus/ctw**2*vmaup*vpata**2*us-1d0/2*sd
     & et3ctaus/ctw**2*vmaup*vpata**2*mta**2)
     & +sdet4itatsus**2*c0ctatsczta*dreal(propizqs)*pxx2zqsc*(sdet3ctats
     & /ctw**2*vmaup*vmata**2*ts)
     & +sdet4itatsus**2*c0ctausczta*dreal(propizqs)*pxx2zqsc*(-sdet3ctau
     & s/ctw**2*vmaup*vpata**2*us)
     & +sdet4itatsus**2*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(-1d0/2/ctw**
     & 2*vmaup*vpata**2*qs*us+1d0/2/ctw**2*vmaup*vmata**2*qs*ts)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*pxx2zqsc*(1d0/2/c
     & tw**2*vmaup*vpata*vmata*ts+1d0/2/ctw**2*vmaup*vmata**2*mta**2-5d0
     & /4*sdet3ctats/ctw**2*vmaup*vmata**2)
     & +sdet4itatsus*d0cctataqstszczta*dreal(propizqs)*(1d0/4*sdet3ctats
     & /ctw**2*vmaup*vmata**2*qs)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*pxx2zqsc*(-1d0/2/
     & ctw**2*vmaup*vpata*vmata*us-1d0/2/ctw**2*vmaup*vpata**2*mta**2+5d
     & 0/4*sdet3ctaus/ctw**2*vmaup*vpata**2)
     & +sdet4itatsus*d0cctataqsuszczta*dreal(propizqs)*(-1d0/4*sdet3ctau
     & s/ctw**2*vmaup*vpata**2*qs)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**
     & 2*vmaup*vpata**2+1d0/4/ctw**2*vmaup*vmata**2)
     & +sdet4itatsus*c0tataqsztaz*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vp
     & ata*vmata*ts-1d0/2/ctw**2*vmaup*vpata*vmata*us+1d0/4/ctw**2*vmaup
     & *vpata**2*qs+1d0/ctw**2*vmaup*vpata**2*us-1d0/4/ctw**2*vmaup*vmat
     & a**2*qs-1d0/ctw**2*vmaup*vmata**2*ts)
     & +sdet4itatsus*c0ctatsczta*dreal(propizqs)*(-1d0/ctw**2*vmaup*vpat
     & a*vmata*ts+3d0/2/ctw**2*vmaup*vmata**2*ts+1d0/2/ctw**2*vmaup*vmat
     & a**2*mta**2)
     & +sdet4itatsus*c0ctausczta*dreal(propizqs)*(1d0/ctw**2*vmaup*vpata
     & *vmata*us-3d0/2/ctw**2*vmaup*vpata**2*us-1d0/2/ctw**2*vmaup*vpata
     & **2*mta**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*pxx2zqsc*(-1d0/4/ctw**2*v
     & maup*vpata**2+1d0/4/ctw**2*vmaup*vmata**2)
     & +sdet4itatsus*c0ccqszcz*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vpata
     & *vmata*ts-1d0/2/ctw**2*vmaup*vpata*vmata*us-1d0/4/ctw**2*vmaup*vp
     & ata**2*qs+1d0/4/ctw**2*vmaup*vmata**2*qs-1d0/2*sdet3ctats/ctw**2*
     & vmaup*vmata**2+1d0/2*sdet3ctaus/ctw**2*vmaup*vpata**2)
     & +d0cctataqstszczta*dreal(propizqs)*(1d0/2/ctw**2*vmaup*vpata*vmat
     & a-1d0/2/ctw**2*vmaup*vmata**2)
     & +d0cctataqsuszczta*dreal(propizqs)*(-1d0/2/ctw**2*vmaup*vpata*vma
     & ta+1d0/2/ctw**2*vmaup*vpata**2)
     & +c0tataqswcw*(1d0/8/qs*mw**2*rtaw-3d0/2/qs*mw**2)
     & +c0tataqsztah*(3d0/2/qs*mw**2/rwz**2-3d0/2/qs*mw**2/rwz*rhw-2/qs*
     & mw**2/rwz+2/qs*mw**2*rhw)
     & +c0tataqstazta*(-2+3d0/2/qs*mw**2/rwz+3/rwz)
     & +c0tataqstahta*(-3d0/2/qs*mw**2*rhw)
     & +c0tataqscwc*(2)
     & +a0fta*(-1d0/2/qs)
     & +b0ftawc*(-1d0/8/qs)
     & +b0ftazta*(3d0/2/qs/rwz-2/qs)
     & +b0ftahta*(-3d0/2/qs/rwz+1d0/qs)
     & +b0fqsww*(1d0/8/qs)
     & +b0fqstata*(1d0/2/qs)
     & +b0dwtacw*(2/qs**2*mw**2+1d0/qs)
     & +b0d1tataz*(5/qs**2*mw**2/rwz+8/qs**2*mw**2*rwz-12/qs**2*mw**2+9d
     & 0/2/qs/rwz+6/qs*rwz-10/qs)
     & +1d0/4/qs

      ffarray(1,1) = ff_qed_ll
      ffarray(1,2) = ff_ew_ll
      ffarray(1,3) = ff_qed_lq
      ffarray(1,4) = ff_ew_lq
      ffarray(1,5) = ff_qed_ql
      ffarray(1,6) = ff_ew_ql
      ffarray(1,7) = ff_qed_qq
      ffarray(1,8) = ff_ew_qq
      ffarray(1,9) = ff_qed_ld
      ffarray(1,10) = ff_ew_ld
      ffarray(1,11) = ff_qed_qd
      ffarray(1,12) = ff_ew_qd
      ffarray(1,13) = ff_qed_gg

      return
      end
