\ProvidesClass{my_report}
\LoadClass[11pt, titlepage]{article}
\usepackage[paperwidth=21cm,paperheight=29.7cm,includehead,headheight=2.0cm,pdftex,hmargin={3cm,2.5cm},vmargin={0cm,2cm},]{geometry}
\usepackage{datetime}
\setlength{\parindent}{0cm} 
\renewcommand{\baselinestretch}{1.2}
\parskip=1em

\newdateformat{monthyeardate}{\monthname[\THEMONTH] \THEYEAR}

\renewcommand{\contentsname}{Table of Contents}

\renewcommand{\normalsize}{\fontsize{11pt}{11pt}\selectfont}
\renewcommand{\title}[1]{\textsf{\Huge{#1}}}
\renewcommand{\author}[1]{\textsf{\Huge{#1}}}
\newcommand{\subtitle}[1]{\textsf{\textbf{\Large{#1}}}}
\newcommand{\abstractheading}[1]{\textsf{\textbf{\LARGE{#1}}}}
\newcommand{\code}[1]{\texttt{\footnotesize{#1}}}

\renewcommand{\section}{\@startsection
{section}%                    % the name
{1}%                          % the level
{0mm}%                        % the indent
{10.6mm}%             % the beforeskip
{4.2mm}%           % the afterskip
{\LARGE\bfseries\sffamily}}  % the style

\renewcommand{\subsection}{\@startsection
{subsection}%                    % the name
{2}%                          % the level
{0mm}%                        % the indent
{6.4mm}%             % the beforeskip
{1.1mm}%           % the afterskip
{\Large\bfseries\sffamily}}  % the style

\renewcommand{\subsubsection}{\@startsection
{subsubsection}%                    % the name
{3}%                          % the level
{0mm}%                        % the indent
{4.2mm}%             % the beforeskip
{1.1mm}%           % the afterskip
{\normalsize\bfseries\sffamily}}  % the style

%% Chapter headings should be centered, uppercase, and at the top of the page.
\def\@makechapterhead#1{%
  { \parindent \z@ \raggedright \normalfont
    %\centering
    \ifnum \c@secnumdepth >\m@ne
        \huge\textsf{\@chapapp\space \thechapter:}
        % \par\nobreak
        %\vskip 20\p@
    \fi
    \interlinepenalty\@M
    \huge \bfseries \textsf{#1}\par\nobreak
    \rule{5cm}{0.5pt}
    \vskip 20\p@
  } }
  
\def\@makeschapterhead#1{%
  %\vspace*{50\p@}%
  { \parindent \z@ \raggedright
    %\centering
    \normalfont
    \interlinepenalty\@M
    \huge \bfseries  \textsf{#1}\par\nobreak
    \rule{5cm}{0.5pt}
    \vskip 20\p@

  }}
  
 \renewenvironment{abstract}{%
      \chapter*{\abstractname}%
      \addcontentsline{toc}{chapter}{\abstractname}
 }
     
     
\makeatletter
\renewcommand{\l@section}{\bfseries\@dottedtocline{1}{0em}{2.3em}}
\renewcommand{\l@subsection}{\normalfont\@dottedtocline{2}{2em}{2.3em}}
\renewcommand{\l@subsubsection}{\normalfont\@dottedtocline{3}{2em}{2.3em}}
%\renewcommand{\l@subsubsection}{\normalfont\@dottedtocline{4}{2em}{2.3em}}
\makeatother

\def\maketitle{\begin{titlepage}
\thispagestyle{empty}
\let\footnotesize\small \let\footnoterule\relax \setcounter{page}{0}
\null
\vfil

\hskip 11.2 cm IFJPAN-IV-2009-10

\hskip 12 cm January 2010, updated \monthyeardate\today

\begin{center}
\title{Universal Interface of TAUOLA \\[0.5cm]
\textbf{\large Technical and Physics Documentation\\[0.5cm]\rule{4cm}{1pt}\\[0.7cm]}
}

\author{\Large N. Davidson$^{a,b}$, G. Nanava$^{e}$, T. Przedzinski$^c$, E. Richter-Was$^{d}$, Z. Was$^a$}\\[0.5cm]
\textsf{\large 
{\em $^a$ Institute of Nuclear Physics, 
Polish Academy of Sciences,\\
         ul. Radzikowskiego 152, 31-342 Cracow, Poland}\\
{\em $^b$ University of Melbourne, Department of Physics \\ Australia.  }\\
{\em $^c $ The Faculty of Physics, Astronomy and Applied Computer
Science,\\
Jagellonian University, Reymonta 4, 30-059 Cracow, Poland.} \\
{\em $^d $ Institute of Physics, The Faculty of Physics, Astronomy and Applied Computer
Science,\\
Jagellonian University, Reymonta 4, 30-059 Cracow, Poland.}\\
{\em $^e$ Physikalisches Institut
 Bonn University, Nussallee 12, D-53115 Bonn, Germany }
}\\
[0.1cm]

%\includegraphics[height=3cm]{logo.eps}\\[1cm]

\end{center}
\vskip 4 mm
%\includegraphics[height=3cm]{logo.eps}\\[1cm]
\centerline{\bf \Large Abstract} \vskip 2 mm {Because of their narrow
  width, $\tau$ decays can be well separated from their production
  process. Only spin degrees of freedom connect these two parts of the
  physics process of interest for high energy collision experiments. In
  the following, we present a Monte Carlo algorithm which is based on
  that property.  The interface 
  supplements events generated by other programs, with $\tau$
  decays.  Effects of spin, including transverse degrees of freedom, genuine weak
  corrections or of new physics may be taken into account at the
time when a $\tau$ decay is generated and written into an event record. The physics content
of the C++ interface is already now richer than its {\tt FORTRAN} predecessor.
}  \centerline{\normalsize August 26, 2017} \vfil
Later extentions of {\tt TAUOLA} and {\tt TauSpinner} projects,
are not explained in this document, but in later publications.
\null \footnoterule
\noindent
{\footnotesize
\begin{itemize}
\item[${\dag}$]

This work is partially supported by  EU Marie Curie Research Training Network 
grant under the contract No. MRTN-CT-2006-0355505 and by  
Polish Government grant N202 06434 (2008-2011).

\end{itemize}
}

\end{titlepage}}

\pagestyle{plain}

