#include "tauola_hepevt_parser.h"
#include "Tauola/TauolaHEPEVTParticle.h"
#include "Tauola/TauolaHEPEVTEvent.h"
#include <iostream>
using namespace Tauolapp;


TauolaHepevtParser::TauolaHepevtParser(const char *filename)
    : in(filename)
{
    if (!in.is_open())
    {
        std::cout << "ERROR: TauolaHepevtParser - File " << filename << " not opened!" << std::endl;
    }
}

bool TauolaHepevtParser::has_next()
{
    return in.is_open() && !in.eof();
}

TauolaHEPEVTEvent* TauolaHepevtParser::next()
{
    int eventNo = 0;
    int partCount = 0;
    in >> eventNo >> partCount;

    if (!in.good() || partCount == 0)
    {
        return NULL;
    }

    TauolaHEPEVTEvent *evt = new TauolaHEPEVTEvent();

    while (partCount--)
    {
        int status = 0;
        int pdgid = 0;
        int jmohep1 = 0;
        int jmohep2 = 0;
        int jdahep1 = 0;
        int jdahep2 = 0;
        double phep[4] = {0.0};
        double m = 0.0;
        double dummy;

        in >> status >> pdgid >> jmohep1 >> jmohep2 >> jdahep1 >> jdahep2 //
            >> phep[0] >> phep[1] >> phep[2] >> phep[3] >> m              //
            >> dummy >> dummy >> dummy >> dummy;

        // Mothers should not be treated as a range
        if (jmohep2 == jmohep1) {
           jmohep2 = 0;
        }

        TauolaHEPEVTParticle *particle = new TauolaHEPEVTParticle(pdgid, status, phep[0], phep[1], phep[2], phep[3], m, jmohep1 - 1, jmohep2 - 1, jdahep1 - 1, jdahep2 - 1);
        evt->addParticle(particle);
    }

    return evt;
}
