      COMPLEX*16 FUNCTION B0F(Q2,MU2,M12,M22)
*     ---------------------------------------
* general B0F;
*
      IMPLICIT NONE
      REAL*8 MU2,Q2,ABQ2,DRM12,DRM22,RU,RD,B0FEXP,DREAL,DABS,DLOG
      COMPLEX*16 M12,M22,SQR,SQS,ILQ,LOG,SQRT
*
      ABQ2=DABS(Q2)
      SQR=SQRT(Q2**2+2D0*Q2*(M12+M22)+(M12-M22)**2)
      SQS=Q2+M12+M22
      DRM12=DREAL(M12)
      DRM22=DREAL(M22)
*
* B0F(-M12;MU2,M12,0)
      IF(ABQ2.EQ.DRM12.AND.DRM22.EQ.0D0) THEN
        B0F=2D0-DLOG(DRM12/MU2)
        RETURN
      ENDIF
* B0F(-M22;MU2,0,M22)
      IF(ABQ2.EQ.DRM22.AND.DRM12.EQ.0D0) THEN
        B0F=2D0-DLOG(DRM22/MU2)
        RETURN
      ENDIF
*
      IF(ABQ2.NE.0D0) THEN
*
* B0F(Q2;MU2,M12,0)
       IF(DRM22.LT.1D-14) THEN
        B0F=2D0-LOG(M12/MU2)-(1D0+M12/Q2)*LOG(1D0+Q2/M12)
        RETURN
       ENDIF
*
* B0F(Q2;MU2,0,M22)
       IF(DRM12.LT.1D-14) THEN
        B0F=2D0-LOG(M22/MU2)-(1D0+M22/Q2)*LOG(1D0+Q2/M22)
        RETURN
       ENDIF
*
* TAYLOR EXPANSIONS: TO STABILIZE B0F(-SMALL,MU2,SMALL,M22)
       IF((ABQ2/DRM12.LT.1D-2).AND.(DRM22/DRM12.LT.1D-2)) THEN
        RU=(-Q2)/DRM12
        RD=DRM22/DRM12
        B0F=B0FEXP(RU,RD)-DLOG(DRM12/MU2)
        RETURN
       ELSEIF((ABQ2/DRM22.LT.1D-2).AND.(DRM12/DRM22.LT.1D-2)) THEN
        RU=(-Q2)/DRM22
        RD=DRM12/DRM22
        B0F=B0FEXP(RU,RD)-DLOG(DRM22/MU2)
        RETURN
       ENDIF
*
* B0F(Q2;MU2,M12,M22)
       IF(DREAL((SQS+SQR)/SQR).LT.1D-7) THEN
         ILQ=-SQR/Q2*LOG((SQS-SQR)/(2D0*SQRT(M12*M22)))
       ELSE
         ILQ=+SQR/Q2*LOG((SQS+SQR)/(2D0*SQRT(M12*M22)))
       ENDIF
       IF(DRM12.GT.1D-14.AND.DRM22.GT.1D-14) THEN
        B0F=2D0-LOG(SQRT(M12*M22)/MU2)+(M12-M22)/2D0/Q2*LOG(M12/M22)-ILQ
       ELSEIF(DRM12.LE.1D-14.AND.DRM22.GT.1D-14) THEN
        B0F=2D0-LOG(M22/MU2)-(1D0+M22/Q2)*LOG(1D0+Q2/M22)
       ELSEIF(DRM12.GT.1D-14.AND.DRM22.LE.1D-14) THEN
        B0F=2D0-LOG(M12/MU2)-(1D0+M12/Q2)*LOG(1D0+Q2/M12)
       ELSEIF(DRM12.LE.1D-14.AND.DRM22.LE.1D-14) THEN
        B0F=2D0-LOG(DCMPLX(Q2,-1D-20)/MU2)
       ELSE
        PRINT*,'NOT FORESEEN SET OF MASSES IN B0F: M12,M22=',M12,M22
        STOP
       ENDIF
*
      ELSEIF(ABQ2.EQ.0D0) THEN
*
* B0F(0;MU2,M12,M22)
       IF((DRM12.NE.DRM22).AND.DRM22.NE.0D0.AND.DRM12.NE.0D0) THEN
        B0F=1D0-LOG(M22/MU2)-M12/(M12-M22)*LOG(M12/M22)
       ELSEIF(DRM12.EQ.0D0.AND.DRM22.NE.0D0) THEN
        B0F=1D0-LOG(M22/MU2)
       ELSEIF(DRM12.NE.0D0.AND.DRM22.EQ.0D0) THEN
        B0F=1D0-LOG(M12/MU2)
       ELSEIF(DRM12.EQ.DRM22) THEN
        B0F=-LOG(M12/MU2)
       ELSE
        PRINT*,'B0F(0;...) NOT FORESEEN SET OF MASSES: M12,M22=',M12,M22
        STOP        
       ENDIF
      ELSE
       PRINT*,'B0F(Q2;...) NOT FORESEEN SET OF MASSES: M12,M22=',M12,M22
      ENDIF
*
      RETURN    
      END

      REAL*8 FUNCTION B0FEXP(RU,RD)
*
      IMPLICIT NONE
      REAL*8 RU,RD,LNRD
*
      LNRD=DLOG(RD)
      B0FEXP=1D0
     &     +LNRD*RD*(1D0+    RD       +RD**2+       RD**3+      RD**4)
     &+RU   *(1D0/2   +3D0/2*RD+ 5D0/2*RD**2+7D0/2 *RD**3+9D0/2*RD**4 
     &     +LNRD*RD*(1D0+3D0*RD+   6D0*RD**2+10D0  *RD**3))
     &+RU**2*(1D0/6   +7D0/3*RD+17D0/2*RD**2+62D0/3*RD**3 
     &     +LNRD*RD*(1D0+6D0*RD+20D0  *RD**2))
     &+RU**3*(1D0/12+35D0/12*RD+56D0/3*RD**2+LNRD*RD*(1D0+10D0*RD))
     &+RU**4*(1D0/20+101D0/30*RD+LNRD*RD)
     &+RU**5*(1D0/30)
*
      RETURN
      END
