#ifndef _TAUOLA_WRAPPER_
#define _TAUOLA_WRAPPER_
/** 
  Wrapper for tauola routines calculating tau polarimetric vector HH.
  Note that order of input 4-vectors matters and must be prepared
  accordingly to choice in FORTRAN version of TAUOLA.
  For details see documentation of old TAUOLA fortran.

  Methods available for some decay modes only.
*/

#include "Tauola/f_Variables.h"

namespace TauSpinner {

extern "C" {
  void dam2pi_(int *MNUM, float *PT, float *PN, float *PIM1, float *PIM2, float *AMPLIT, float *HH);

  void dam4pi_(int *MNUM, float *PT, float *PN, float *PIM1, float *PIM2, float *PIZ, float *PIPL,
               float *AMPLIT, float *HH);

  void damppk_(int *MNUM, float *PT, float *PN, float *PIM1, float *PIM2, float *PIPL,
               float *AMPLIT, float *HH);

  void dampry_(int *ITDKRC, double *XK0DEC, double *XK, double *XA, double *QP, double *XN,
               double *AMPLIT, double *HV);

  void initwk_(int *IDE, int *IDF, double *SVAR);

  //  void initwkswdelt_(int *IDE, int *IDF, double *SVAR, double *SWSQ, double *DeltSQ, double *DeltV, double *GMU, double *ALFINV, int *KEYGSW,
  //		 double *ReGSW1, double *ImGSW1, double *ReGSW2, double *ImGSW2,
  //		 double *ReGSW3, double *ImGSW3, double *ReGSW4, double *ImGSW4,  double *ReGSW6, double *ImGSW6);

  void initwksw_(int *IDE, int *IDF, double *SVAR, double *SWSQ, double *ALFINV, int *KEYGSW,
		 double *ReGSW1, double *ImGSW1, double *ReGSW2, double *ImGSW2,
		 double *ReGSW3, double *ImGSW3, double *ReGSW4, double *ImGSW4,  double *ReGSW6, double *ImGSW6);

  double t_born_(int *MODE, double *SVAR, double *COSTHE, double *TA, double *TB);
  double t_bornz_(int *MODE, double *SVAR, double *COSTHE, double *TA, double *TB);
  double t_bornpho_(int *MODE, double *SVAR, double *COSTHE, double *TA, double *TB);

  void dipolgammarij_(int *iqed, double *E, double *theta, double *A, double *B, double R[4][4]);
  void dipolgamma_(int *iqed, double *E, double *theta, double *A, double *B, double R[4][4]);
  
  // void dipolqq_(int *iqed, double *E, double *theta, int *channel, double *Amz0, double *Gamz0, double *sin2W0, double GSWr[7], double GSWi[7], double R[4][4]);
  void dipolqq_(int *iqed, double *E, double *theta, int *channel, double *Amz0, double *Gamz0, double *sin2W0, double *alphaQED, double *ReA0, double *ImA0,  double *ReB, double *ImB,  double *ReX, double *ImX, double *ReY, double *ImY, double GSWr[7], double GSWi[7], double R[4][4]);  

  // COMMON /CHANOPT/ used to switch between pi- pi- pi+ and pi0 pi0 pi-
  //                  in RChL currents
  extern "C" struct CHANOPT {
    int JJ;
  } chanopt_;

}

} // namespace TauSpinner
#endif
