
      SUBROUTINE INITWKSWDELT(mode,IDEX,IDFX,SVAR,SWSQEFF, DELTSQ,  DeltV, GMU, ALPHAINV,  AMZi, GAMMZi, KEYGSW,
     &ReGSW1,CImGSW1,ReGSW2,CImGSW2,ReGSW3,CImGSW3,ReGSW4,CImGSW4,ReGSW6,CImGSW6 )
      

! initialization routine coupling masses etc., explicitly varying SWSQ
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON / T_BEAMPM / ENE ,AMIN,AMFIN,IDE,IDF
      REAL*8              ENE ,AMIN,AMFIN
      COMMON / T_GAUSPM /SS,POLN,T3E,QE,T3F,QF
     &                  ,XUPGI0  ,XUPZI0  ,XUPGF0  ,XUPZF0  
     &                  ,NDIAG0,NDIAGA,KEYA,KEYZ
     &                  ,ITCE,JTCE,ITCF,JTCF,KOLOR
      REAL*8            SS,POLN,T3E,QE,T3F,QF
     &                  ,XUPGI0(2),XUPZI0(2),XUPGF0(2),XUPZF0(2)
      COMMON / T_GAUSPM1/VVcor, ZetVPi, GamVPi
     &                  ,XUPGI   ,XUPZI   ,XUPGF   ,XUPZF
      COMPLEX*16         VVcor, ZetVPi, GamVPi
      COMPLEX*16         XUPGI(2),XUPZI(2),XUPGF(2),XUPZF(2)
      
      COMMON / T_GSWPRMn /SWSQ,AMW,AMZ,AMH,AMTOP,GAMMZ
      REAL*8             SWSQ,AMW,AMZ,AMH,AMTOP,GAMMZ
      COMMON / T_EWn    / GMUn, ALPHAINVn
      REAL*8              GMUn, ALPHAINVn
      COMPLEX *16 GSW(10)
      REAL*8 PI     
      DATA PI /3.141592653589793238462643D0/
      GSW(1) = DCMPLX(ReGSW1,CImGSW1)
      GSW(2) = DCMPLX(ReGSW2,CImGSW2)
      GSW(3) = DCMPLX(ReGSW3,CImGSW3)
      GSW(4) = DCMPLX(ReGSW4,CImGSW4)
      ! GSW(5) out
      GSW(6) = DCMPLX(ReGSW6,CImGSW6)
   
C      PRINT *, ' initwksw GSW = ', SWSQEFF,  ReGSW1, CImGSW1, ReGSW2, CImGSW2, ReGSW6, CImGSW6
      
C     SWSQ        = sin2 (theta Weinberg)
C     AMW,AMZ     = W & Z boson masses respectively
C     AMH         = the Higgs mass
C     AMTOP       = the top mass
C     GAMMZ       = Z0 width
C
      ENE=SQRT(SVAR)/2
      AMIN=0.511D-3
      SWSQ=SWSQEFF
      AMZ=AMZi !91.1887
      GAMMZ=GAMMZi              !2.4952
      GMUn=GMU
      ALPHAINVn=ALPHAINV
       
      
C      Gfermi=1.16639d-5
      Gfermi=GMU

                ZetVPi =  Gfermi *AMZ**2 *ALPHAINV /(DSQRT(2.d0)*8.d0*PI)
     $          *(SWSQ*(1d0-SWSQ)) *16d0 
     $     * GSW(1)
C     updated following KK2f_defaults
C      IF( KEYGSW.NE.0) THEN
C         GAMMZ=2.50072032     
C      ENDIF



      
      GamVPi = 1d0   /(2d0-GSW(6))

C      PRINT *, ' initwksw ZetVPi, GamVPi = ', GSW(1), ZetVPi, GamVPi 
      
     
      IF  (IDFX.EQ. 11) then       
        IDF=2  ! denotes tau +2 tau-
        AMFIN=0.511D-3 !this mass is irrelevant if small, used in ME only
      ELSEIF (IDFX.EQ.-11) then
        IDF=-2  ! denotes tau -2 tau-
        AMFIN=0.511D-3 !this mass is irrelevant if small, used in ME only
      ELSEIF  (IDFX.EQ. 15) then       
        IDF=2  ! denotes tau +2 tau-
        AMFIN=1.77703 !this mass is irrelevant if small, used in ME only
      ELSEIF (IDFX.EQ.-15) then
        IDF=-2  ! denotes tau -2 tau-
        AMFIN=1.77703 !this mass is irrelevant if small, used in ME only
      ELSE
        WRITE(*,*) 'INITWKSW: WRONG IDFX'
        STOP
      ENDIF

      IF     (IDEX.EQ. 11) then      !electron
        IDE= 2
        AMIN=0.511D-3
      ELSEIF (IDEX.EQ.-11) then      !positron
        IDE=-2
        AMIN=0.511D-3
      ELSEIF (IDEX.EQ. 13) then      !mu+
        IDE= 2
        AMIN=0.105659
      ELSEIF (IDEX.EQ.-13) then      !mu-
        IDE=-2
        AMIN=0.105659
      ELSEIF (IDEX.EQ.  1) then      !d
        IDE= 4
        AMIN=0.05
      ELSEIF (IDEX.EQ.- 1) then      !d~
        IDE=-4
        AMIN=0.05
      ELSEIF (IDEX.EQ.  2) then      !u
        IDE= 3
        AMIN=0.02
      ELSEIF (IDEX.EQ.- 2) then      !u~
        IDE=-3
        AMIN=0.02
      ELSEIF (IDEX.EQ.  3) then      !s
        IDE= 4
        AMIN=0.3
      ELSEIF (IDEX.EQ.- 3) then      !s~
        IDE=-4
        AMIN=0.3
      ELSEIF (IDEX.EQ.  4) then      !c
        IDE= 3
        AMIN=1.3
      ELSEIF (IDEX.EQ.- 4) then      !c~
        IDE=-3
        AMIN=1.3
      ELSEIF (IDEX.EQ.  5) then      !b
        IDE= 4
        AMIN=4.5
      ELSEIF (IDEX.EQ.- 5) then      !b~
        IDE=-4
        AMIN=4.5
      ELSEIF (IDEX.EQ.  12) then     !nu_e
        IDE= 1
        AMIN=0.1D-3
      ELSEIF (IDEX.EQ.- 12) then     !nu_e~
        IDE=-1
        AMIN=0.1D-3
      ELSEIF (IDEX.EQ.  14) then     !nu_mu
        IDE= 1
        AMIN=0.1D-3
      ELSEIF (IDEX.EQ.- 14) then     !nu_mu~
        IDE=-1
        AMIN=0.1D-3
      ELSEIF (IDEX.EQ.  16) then     !nu_tau
        IDE= 1
        AMIN=0.1D-3
      ELSEIF (IDEX.EQ.- 16) then     !nu_tau~
        IDE=-1
        AMIN=0.1D-3

      ELSE
        WRITE(*,*) 'INITWKSW: WRONG IDEX'
        STOP
      ENDIF

C ----------------------------------------------------------------------
C
C     INITIALISATION OF COUPLING CONSTANTS AND FERMION-GAMMA / Z0 VERTEX
C
C     called by : KORALZ
C ----------------------------------------------------------------------
      ITCE=IDE/IABS(IDE)
      JTCE=(1-ITCE)/2
      ITCF=IDF/IABS(IDF)
      JTCF=(1-ITCF)/2
      CALL T_GIVIZO( IDE, 1,AIZOR,QE,KDUMM)
      CALL T_GIVIZO( IDE,-1,AIZOL,QE,KDUMM)
      XUPGI(1)=QE
      XUPGI(2)=QE
      T3E    = (AIZOL+AIZOR)/2.
      XUPZI(1)=(AIZOR-QE*(SWSQ+DeltSQ)*GSW(3)-QE*DeltV)/SQRT(SWSQ*(1-SWSQ))
      XUPZI(2)=(AIZOL-QE*(SWSQ+DeltSQ)*GSW(3)-QE*DeltV)/SQRT(SWSQ*(1-SWSQ))
      Ve      =(XUPZI(1)+XUPZI(2))/2.
      CALL T_GIVIZO( IDF, 1,AIZOR,QF,KOLOR)
      CALL T_GIVIZO( IDF,-1,AIZOL,QF,KOLOR)
      XUPGF(1)=QF
      XUPGF(2)=QF
      T3F    =  (AIZOL+AIZOR)/2.
      XUPZF(1)=(AIZOR-QF*(SWSQ+DeltSQ)*GSW(2)-QF*DeltV)/SQRT(SWSQ*(1-SWSQ))
      XUPZF(2)=(AIZOL-QF*(SWSQ+DeltSQ)*GSW(2)-QF*DeltV)/SQRT(SWSQ*(1-SWSQ))
      Vf      =(XUPZF(1)+XUPZF(2))/2.

* Coupling costants times EW form-factors
      Deno   = DSQRT(SWSQ*(1d0-SWSQ))
  !       Ve     = (2*T3e -4*Qe*m_Sw2*CorEle)/Deno
  !       Vf     = (2*T3f -4*Qf*m_Sw2*CorFin)/Deno
  !       Ae     =  2*T3e             /Deno
  !       Af     =  2*T3f             /Deno
* Angle dependent double-vector extra-correction
      VVCef  = ( (T3e) *(T3f) 
     $     -(QE*SWSQ+DeltSQ) *(T3f) *GSW(3) -QE*(T3f)*DeltV
     $     -(QF*SWSQ+DeltSQ) *(T3e) *GSW(2) -QF*(T3e)*DeltV
     $     + (QE*SWSQ) *(QF*SWSQ)  *GSW(4)
     $     + 2*QE*QF*DeltSQ*SWSQ + 2*QE*QF*DeltV*SWSQ )/Deno**2

      VVCor = 1D0
      IF(KEYGSW.EQ.1)  THEN
         VVCor  = VVCef/(Ve*Vf)
      ENDIF
C
C     PRINT *,' initwksw VVCor = ', VVCor
      NDIAG0=2
      NDIAGA=11
      KEYA  = 1
      KEYZ  = 1
C
C
      RETURN
      END
      FUNCTION T_BORNEW(MODE,KEYGSW,SVAR,COSTHE,TA,TB)
C ----------------------------------------------------------------------
C THIS ROUTINE PROVIDES BORN CROSS SECTION. IT HAS THE SAME         
C STRUCTURE AS FUNTIS AND FUNTIH, THUS CAN BE USED AS SIMPLER       
C EXAMPLE OF THE METHOD APPLIED THERE                               
C INPUT PARAMETERS ARE: SVAR    -- transfer
C                       COSTHE  -- cosine of angle between tau+ and 1st beam
C                       TA,TB   -- helicity states of tau+ tau-
C                       mode    -- parameter for mass terms; 1 means mass terms are on.
C                       keyGSW  -- keyGSW=0 gamma propagator is off 
C                                  keyGSW=10 running Z width 
C
C     called by : BORNY, BORAS, BORNV, WAGA, WEIGHT
C ----------------------------------------------------------------------
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON / T_BEAMPM / ENE ,AMIN,AMFIN,IDE,IDF
      REAL*8              ENE ,AMIN,AMFIN
      COMMON / T_GAUSPM /SS,POLN,T3E,QE,T3F,QF
     &                  ,XUPGI0   ,XUPZI0   ,XUPGF0   ,XUPZF0  
     &                  ,NDIAG0,NDIAGA,KEYA,KEYZ
     &                  ,ITCE,JTCE,ITCF,JTCF,KOLOR
      REAL*8            SS,POLN,T3E,QE,T3F,QF
     &                  ,XUPGI0(2),XUPZI0(2),XUPGF0(2),XUPZF0(2)
      COMMON / T_GAUSPM1/VVcor, ZetVPi, GamVPi
     &                  ,XUPGI   ,XUPZI   ,XUPGF   ,XUPZF
      COMPLEX*16         VVcor, ZetVPi, GamVPi
      COMPLEX*16         XUPGI(2),XUPZI(2),XUPGF(2),XUPZF(2)
      COMMON / T_EWn    / GMUn, ALPHAINVn
      REAL*8              GMUn, ALPHAINVn

      
      REAL*8            SEPS1,SEPS2
C=====================================================================
      COMMON / T_GSWPRMn /SWSQ,AMW,AMZ,AMH,AMTOP,GAMMZ
      REAL*8             SWSQ,AMW,AMZ,AMH,AMTOP,GAMMZ
C     SWSQ        = sin2 (theta Weinberg)
C     AMW,AMZ     = W & Z boson masses respectively
C     AMH         = the Higgs mass
C     AMTOP       = the top mass
C     GAMMZ       = Z0 width
      COMPLEX*16 ABORN(2,2),APHOT(2,2),AZETT(2,2)
      COMPLEX*16 XUPZFP(2),XUPZIP(2),XUPZIF(2,2)
      COMPLEX*16 ABORNM(2,2),APHOTM(2,2),AZETTM(2,2)
      COMPLEX*16 PROPA,PROPZ
      COMPLEX*16 XR,XI
      COMPLEX*16 XUPF,XUPI
      COMPLEX*16 XTHING
      DATA XI/(0.D0,1.D0)/,XR/(1.D0,0.D0)/
      DATA MODE0 /-5/
      DATA IDE0 /-55/
      DATA SVAR0,COST0 /-5.D0,-6.D0/
      DATA PI /3.141592653589793238462643D0/
      DATA SEPS1,SEPS2 /0D0,0D0/
 
C
C MEMORIZATION =========================================================
      IF ( MODE.NE.MODE0.OR.SVAR.NE.SVAR0.OR.COSTHE.NE.COST0
     $    .OR.IDE0.NE.IDE)THEN
C

   !      PRINT *,' T_BORN EW loop ( ',sqrt(svar),XUPGI(1),')= ', VVcor, ZetVPi!, GamVPi
   !      PRINT *,' T_BORN new( ',mode,')= ',SWSQ,AMW,AMZ,AMH,AMTOP,GAMMZ
C ** SWITCH OF MEMORISATION
C        IDE0=IDE
C        MODE0=MODE
C        SVAR0=SVAR
C        COST0=COSTHE
C ** PROPAGATORS
        SINTHE=SQRT(1.D0-COSTHE**2)
        BETA=SQRT(MAX(0D0,1D0-4D0*AMFIN**2/SVAR))
!        BETA=1.D0! Dec 10, 2019 mass term may need to be killed for EW tests 
C I MULTIPLY AXIAL COUPLING BY BETA FACTOR.
        XUPZFP(1)=0.5D0*(XUPZF(1)+XUPZF(2))+0.5D0*BETA*(XUPZF(1)-XUPZF(2))
        XUPZFP(2)=0.5D0*(XUPZF(1)+XUPZF(2))-0.5D0*BETA*(XUPZF(1)-XUPZF(2))
        XUPZIP(1)=0.5D0*(XUPZI(1)+XUPZI(2))+0.5D0*(XUPZI(1)-XUPZI(2))
        XUPZIP(2)=0.5D0*(XUPZI(1)+XUPZI(2))-0.5D0*(XUPZI(1)-XUPZI(2))
        XUPZIF(1,1)=(0.5D0*(XUPZI(1)+XUPZI(2))+0.5D0*(XUPZI(1)-XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2))+0.5D0*BETA*(XUPZF(1)-XUPZF(2)))
     $             +(0.5D0*(XUPZI(1)+XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2)))*(VVcor-1)
        XUPZIF(1,2)=(0.5D0*(XUPZI(1)+XUPZI(2))+0.5D0*(XUPZI(1)-XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2))-0.5D0*BETA*(XUPZF(1)-XUPZF(2)))
     $             +(0.5D0*(XUPZI(1)+XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2)))*(VVcor-1)
        XUPZIF(2,1)=(0.5D0*(XUPZI(1)+XUPZI(2))-0.5D0*(XUPZI(1)-XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2))+0.5D0*BETA*(XUPZF(1)-XUPZF(2)))
     $             +(0.5D0*(XUPZI(1)+XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2)))*(VVcor-1)
        XUPZIF(2,2)=(0.5D0*(XUPZI(1)+XUPZI(2))-0.5D0*(XUPZI(1)-XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2))-0.5D0*BETA*(XUPZF(1)-XUPZF(2)))
     $             +(0.5D0*(XUPZI(1)+XUPZI(2)))*(0.5D0*(XUPZF(1)+XUPZF(2)))*(VVcor-1)
        
C FINAL STATE VECTOR COUPLING
        XUPF     =0.5D0*(XUPZF(1)+XUPZF(2))
        XUPI     =0.5D0*(XUPZI(1)+XUPZI(2))
        XTHING   =0D0
        

        PROPA =1D0/SVAR*GamVPi
C       use running width
        PROPZ =1D0/DCMPLX(SVAR-AMZ**2,SVAR/AMZ*GAMMZ)*ZetVPi
        ALPHAINV=ALPHAINVn

        IF( KEYGSW. EQ. 2.OR.KEYGSW.EQ.0) THEN
          PROPZ =1D0/DCMPLX(SVAR-AMZ**2,AMZ*GAMMZ)*ZetVPi
        ELSEIF( KEYGSW. EQ. 10) THEN
!         PROPZ =1D0/DCMPLX(SVAR-AMZ**2,AMZ*GAMMZ)*ZetV ! this form need
!         redefined M_Z and G_Z.
!         Below variant with this rescaling implemented
          PROPZ =1D0/DCMPLX(SVAR-AMZ**2/(1+GAMMZ**2/AMZ**2), ! alternative to
     $                      AMZ*GAMMZ  /(1+GAMMZ**2/AMZ**2)) ! running width
     $                     *ZetVPi
          PROPZ =PROPZ*DCMPLX(1,-GAMMZ/AMZ/(1+GAMMZ**2/AMZ**2))        
        ENDIF

C     needed for variants v1 and v2 of effective Born. Factors  change normalization of
C     t_born by (alpha(M_Z)/alpha(0))^2  

         PROPZ =PROPZ/ALPHAINV
         PROPA =PROPA/ALPHAINV
C        to achieve in QED point-like low energy limit
C        q_i^2q_f^2 (1+cos_theta^2) for Born
         PROPZ =PROPZ*137.03604
         PROPA =PROPA*137.03604


        IF (KEYGSW.EQ.0) PROPA=0.D0
        DO 50 I=1,2
         DO 50 J=1,2
          REGULA= (3-2*I)*(3-2*J) + COSTHE
          REGULM=-(3-2*I)*(3-2*J) * SINTHE *2.D0*AMFIN/SQRT(SVAR)
          APHOT(I,J)=PROPA*(XUPGI(I)*XUPGF(J)*REGULA)
          AZETT(I,J)=PROPZ*(XUPZIP(I)*XUPZFP(J)+XTHING)*REGULA
          AZETT(I,J)=PROPZ*(XUPZIF(I,J)+XTHING)*REGULA         ! with electroweak effects in.          
          ABORN(I,J)=APHOT(I,J)+AZETT(I,J)
          APHOTM(I,J)=PROPA*DCMPLX(0D0,1D0)*XUPGI(I)*XUPGF(J)*REGULM
          AZETTM(I,J)=PROPZ*DCMPLX(0D0,1D0)*(XUPZIP(I)*XUPF+XTHING)*REGULM
          ABORNM(I,J)=APHOTM(I,J)+AZETTM(I,J)
   50   CONTINUE
      ENDIF
C
C******************
C* IN CALCULATING CROSS SECTION ONLY DIAGONAL ELEMENTS
C* OF THE SPIN DENSITY MATRICES ENTER (LONGITUD. POL. ONLY.)
C* HELICITY CONSERVATION EXPLICITLY OBEYED
      POLAR1=  (SEPS1)
      POLAR2= (-SEPS2)
      BORN=0D0
      DO 150 I=1,2
       HELIC= 3-2*I
       DO 150 J=1,2
        HELIT=3-2*J
        FACTOR=KOLOR*(1D0+HELIC*POLAR1)*(1D0-HELIC*POLAR2)/4D0
        FACTOM=FACTOR*(1+HELIT*TA)*(1-HELIT*TB)
        FACTOR=FACTOR*(1+HELIT*TA)*(1+HELIT*TB)

        BORN=BORN+CDABS(ABORN(I,J))**2*FACTOR
C      MASS TERM IN BORN
        IF (MODE.GE.1) THEN
         BORN=BORN+CDABS(ABORNM(I,J))**2*FACTOM
        ENDIF

  150 CONTINUE
C************
      FUNT=BORN
      IF(FUNT.LT.0.D0)  FUNT=BORN

C
      IF (SVAR.GT.4D0*AMFIN**2) THEN
C     PHASE SPACE THRESHOLD FACTOR and SVAR**2     
        THRESH=SQRT(1-4D0*AMFIN**2/SVAR)
        T_BORNEW= FUNT*THRESH  *SVAR**2
      ELSE
        THRESH=0.D0
        T_BORNEW=0.D0
      ENDIF
      END
      
      FUNCTION T_gamm(MODE,SVAR,COSTHE,TA,TB) 
      IMPLICIT REAL*8(A-H,O-Z)
      real*8 R(1:4, 1:4)
      COMMON / T_BEAMPM / ENE ,AMIN,AMFIN,IDE,IDF
      REAL*8              ENE ,AMIN,AMFIN
      common /dipolegam/ Adip,Bdip,iqedDip,IFgammOLD
      IFgammOLD=1
      A=0.0
      B=0.0
      iqed=iqedDip ! on/off for  SM dipole in gamma gamma to tau tau
      theta=acos(costhe)
      E=sqrt(SVAR)/2.
      IF (IFgammOLD.eq.0) then
       T_gamm=0.D0
       return
      endif
      
      call DipolGammaRij (iqed, E, theta, A, B, R)
      funt=R(4,4)+ TA*R(4,3)+ TB*R(3,4)+ TA*TB*R(3,3)
        IF (SVAR.GT.4D0*AMFIN**2) THEN
C     PHASE SPACE THRESHOLD FACTOR and SVAR**2     
        THRESH=SQRT(1-4D0*AMFIN**2/SVAR)
        T_gamm= FUNT*THRESH  *SVAR**2
      ELSE
        THRESH=0.D0
        T_gamm=0.D0
      ENDIF    
      write(*,*) 't_gamm stary',R(4,4), TA,R(1,1),TB,R(2,2),R(3,3)
      END
      FUNCTION T_gammNEW(MODE,SVAR,COSTHE,TA,TB)
      IMPLICIT REAL*8(A-H,O-Z)
      real*8 R(1:4, 1:4)
      COMMON / T_BEAMPM / ENE ,AMIN,AMFIN,IDE,IDF
      REAL*8              ENE ,AMIN,AMFIN
      common /dipolegam/ Adip,Bdip,iqedDip,IFgammOLD

      A=Adip
      B=Bdip
      iqed=1 ! SM dipole always on in  SM+NP  gamma gamma to tau tau
      theta=acos(costhe)
      E=sqrt(SVAR)/2.
      call DipolGammaRij (iqed, E, theta, A, B, R)
      funt=R(4,4)+ TA*R(4,3)+ TB*R(3,4)+ TA*TB*R(3,3)
        IF (SVAR.GT.4D0*AMFIN**2) THEN
C     PHASE SPACE THRESHOLD FACTOR and SVAR**2     
        THRESH=SQRT(1-4D0*AMFIN**2/SVAR)
        T_gammNEW= FUNT*THRESH  *SVAR**2
      ELSE
        THRESH=0.D0
        T_gammNEW=0.D0
      ENDIF
      T_gammNEW=0.D0
      write(*,*) 't_gamm nowy',T_gammNEW
      END
 
      Subroutine DipolGamma(iqed, E, theta, A, B, R)
!
!     This routine performs adjustment of frame orientation between conventions used by Korchin and the one of TauSpinner
!     which is inherited from conventions of KORALB-KKMC: that consist of  rotations
!     Also  index shift is performed from  xyzt (1234) to txyz  [in c++ that will be seen as (0123)]
     
	implicit none
        real*8 Amz0,Gamz0,sin2W0,alphaQED,GSWr(7),GSWi(7)
	integer iqed,channel,k,j,k0,j0
	real*8 E,theta,A,B,xnor,thet, buf
        real*8 R(1:4, 1:4),R0(1:4, 1:4),sign(4)
!	ReA0=0
!	ImA0=0
!	ReB=0
!	ImB=0
!	ReX=0
!	ImX=0
!	ReY=0
!	ImY=0
        sign(1)=-1.0
        sign(2)= 1.0
        sign(3)=-1.0
        sign(4)= 1.0
        thet=acos(cos(theta))
        
	call DipolGammaRij(iqed, E, theta, A, B, R0)


        
! rotation from q ~q --> tau- tau+  to  ~q q --> tau+ tau- frames.
!               WARNING: we normalize R0, but  x-section is set into R0(4,4).        
        xnor=R0(4,4)
        do k=1,4
          do j=1,4
              R0(k,j)=R0(k,j)/XNOR*sign(k)*sign(j)
           enddo
        enddo
        R0(4,4)=xnor

 ! rotation in second index by angle pi/2 around z-axis       
        do k=1,4
           do j=1,4
              if(j.eq.1) then
                 buf=R0(k,2)
                 R0(k,2)=R0(k,j)
                 R0(K,1)=-buf
              endif
              
           enddo
        enddo

! rotation in first index by angle pi/2  around z-axis 
        do j=1,4
           do k=1,4
             if(k.eq.1) then
                 buf=R0(2,j)
                 R0(2,j)=R0(k,j)
                 R0(1,j)=-buf
              endif

           enddo
        enddo


! shift order of entries  from x,y,z,t  to t,x,y,z  (necessary for C++ conventions). 
        do k0=1,4
           do j0=1,4
               k=k0+1
               j=j0+1
               if(j.eq.5) j=1
               if(k.eq.5) k=1
               R(k,j)=R0(k0,j0)
           enddo
        enddo
 !       if(R0(3,3)/R0(4,4).gt.1d0) then
  !         write(*,*) "z fortranu thet=", thet," energy= ",energy, " Rzz=", R0(3,3)/R0(4,4)," ", R0(3,3)," ",R0(4,4)
           
 !          write(*,*) "iqed,Energy, thet, channel ",iqed,Energy, thet, channel
        !   write(*,*)  "Amz0,Gamz0,sin2W0,alphaQED ",   Amz0,Gamz0,sin2W0,alphaQED
      !      write(*,*)  "ReA0, ImA0, ReB, ImB ",   ReA0, ImA0, ReB, ImB
      !      write(*,*)  "ReX, ImX, ReY, ImY ",    ReX, ImX, ReY, ImY
   !      write(*,*)  "GSWr ",   GSWr
   !      write(*,*)  "GSWi ",   GSWi
   !     endif
    !  IF(R(4,4)/R(1,1).gt.1.0) then
    !    write(*,*) "==============",R(4,4)/R(1,1)
    !    write(*,*) 'energuy,theta,channel= ',Energy,' ',cos(theta),' ',channel
    !    do k=1,4
    !       write(*,7) k, R(k,1)/R(1,1),R(k,2)/R(1,1),R(k,3)/R(1,1),R(k,4)/R(1,1)
    !   enddo
    !  endif
      

 7      format(1x,i4, 4(2x,f12.6))
        
      end
      Subroutine DipolGammaRijOld (iqed, E, theta, A, B, R)

c              For  gamma gamma -> tau- tau+  reaction
c
c  Calculates spin-correlation coefficients R(i,j) as functions of beam
c  energy E = sqrt(s)/2 (in GeV) and scattaring angle theta.
c  V is velocity of tau lepton, gam is Lorentz factor, alpha is
c  fine-structure constant.
c  Anomalous magnetic moment A1 = ASM + A and electric dipole moment B are
c  real constants.
c  Parameters A, B describe 'New Physics'.
c  ASM is anomalous magnetic moment of tau in Standard Model (SM):
c  S.Eidelman and M.Passera. Mod.Phys.Lett. A22, 159-179, 2007.
c
c  Order of coefficients:
c     i = 1,2,3 correspond to S_x, S_y, S_z for tau-,
c     j = 1,2,3 correspond to S'_x, S'_y, S'_z for tau+
c     i,j = 4 (equivalent to tt) corresponds to 1 (no spin dependence).

      Implicit none
      integer iqed
C      integer i, j                         ! not used here
      real*8 E, theta, A, B
      real*8 R(1:4, 1:4)
      real*8 ASM, A1, gam, e4, V,D2
      real*8 Fnorm
      real*8 PI/3.141592653589793238d0/,alpha/7.2973525693d-3/
      real*8 mtau               ! mass of tau in GeV
      COMMON / T_BEAMPM / ENE ,AMIN,AMFIN,IDE,IDF
      integer                             IDE,IDF    
      REAL*8              ENE ,AMIN,AMFIN
      integer k,l
      mtau=AMFIN
      V = dsqrt(1.d0 -(mtau/E)**2)         ! tau velocity 
      e4 = (4.0d0 *PI *alpha)**2           ! (electric charge)^4
      gam = E/mtau                         ! Lorentz factor for tau
      Fnorm= 2*(2*PI**2*ALPHA**2)          ! for normalization as in tauspinner. 
c  Cotribution to anomalous magnetic moment in Standard Model:
      ASM = 1.17721d-3
      ASM = ASM *iqed                     ! switch for dipole SM part
      A1 = ASM + A                        ! Standard Model + New Physics

      D2 = (V**2 *dcos(theta)**2 -1.d0)**2        ! factor in denominator

      R(1,1) = e4 *(-11.d0 *V**4 +28.d0 *A1 *V**2 +
     $ 4.d0 *(V**2 -2.d0) *dcos(2.d0*theta) *V**2 -
     $ (V**2 -4.d0 *A1 -2.d0) *dcos(4.d0*theta) *V**2 +
     $ 22.d0 *V**2 -32.d0 *A1 -8.d0) /(8.d0 *D2)

      R(1,2) = e4 *V *B *(dcos(4.d0*theta) *V**2 +15.d0 *V**2 +
     $ 4.d0 *cos(2.d0*theta) -20.d0) /(4.d0 *D2)

      R(1,3) = e4 *V**2 *gam *((A1 -1.d0) *V**2 +
     $ (V**2 +A1 *(V**2 -2.d0) -1.d0) *dcos(2.d0*theta) +1.d0) *
     $ dsin(2.d0*theta) /(2.d0 *D2)

      R(1,4) = 0.d0

      R(2,1) = -R(1,2)

      R(2,2) = e4 *(-dcos(4.d0*theta) *V**4 -11.d0 *V**4 +
     $ 16.d0 *A1 *V**2 +4.d0 *(V**2 +4.d0 *A1) *dcos(2.d0*theta) *V**2 +
     $ 16.d0 *V**2 -32.d0 *A1 -8.d0) /(8.d0 *D2)

      R(2,3) = e4 *V *gam *B *(dcos(2.d0*theta)*V**2 -3.d0*V**2 +2.d0) *
     $ dsin(2.d0*theta) /(2.d0 *D2)

      R(2,4) = 0.d0

      R(3,1) = R(1,3)

      R(3,2) = -R(2,3)

      R(3,3) = e4 *(-4.d0 *dcos(2.d0*theta) *V**4 +11.d0 *V**4 +
     $ 36.d0 *A1 *V**2 +(V**2 -4.d0 *A1 -2.d0) *dcos(4.d0*theta) *V**2 +
     $ 2.d0 *V**2 -32.d0 *A1 -8.d0) /(8.d0 *D2)

      R(3,4) = 0.d0

      R(4,1) = 0.d0

      R(4,2) = 0.d0

      R(4,3) = 0.d0

      R(4,4) = e4 *(-dcos(4.d0*theta) *V**4 -11.d0 *V**4 -16.d0 *A1 *V**2 +
     $ 4.d0 *(V**2 -4.d0 *A1 -2.d0) *dcos(2.d0*theta) *V**2 +
     $ 8.d0 * V**2 +32.d0 *A1 +8.d0) /(8.d0 *D2)

! to normalize as in tauspinner
   ! FNORM=1.0
      do k=1,4
         do l=1,4
            R(k,l)=R(k,l)/FNORM
         enddo
      enddo
      
      return
      end
  
      Subroutine DipolGammaRij (iqed, E, theta, A, B, R)

c              For  gamma gamma -> tau- tau+  reaction
c
c  14 March 2025: updated with exact calculation, in which 
c  all orders in dipole moments are included up to the 4th order.
c  earlier it was linearized part only. For discovery evaluation versions
c  should be equivalent.
c 
c  Calculates spin-correlation coefficients R(i,j) as functions of beam
c  energy E = sqrt(s)/2 (in GeV) and scattaring angle theta.
c  V is velocity of tau lepton, gam is Lorentz factor, alpha is
c  fine-structure constant.
c  Anomalous magnetic moment A1 = ASM + A and electric dipole moment B are
c  real constants.
c  Parameters A, B describe 'New Physics'.
c  ASM is anomalous magnetic moment of tau in Standard Model (SM):
c  S.Eidelman and M.Passera. Mod.Phys.Lett. A22, 159-179, 2007.
c
c  Order of coefficients:
c     i = 1,2,3 correspond to S_x, S_y, S_z for tau-,
c     j = 1,2,3 correspond to S'_x, S'_y, S'_z for tau+
c     i,j = 4 (equivalent to tt) corresponds to 1 (no spin dependence).

      Implicit none
      integer iqed
      integer i, j                         ! not used here
      real*8 E, theta, A, B
      real*8 R(1:4, 1:4)
      real*8 ASM, A1, gam, e4, V, D2
      real*8 Fnorm
      real*8 PI/3.141592653589793238d0/,alpha/7.2973525693d-3/
      real*8 mtau               ! mass of tau in GeV
      COMMON / T_BEAMPM / ENE ,AMIN,AMFIN,IDE,IDF
      integer                             IDE,IDF    
      REAL*8              ENE ,AMIN,AMFIN
      integer k,l

      mtau=AMFIN
      V = dsqrt(1.d0 -(mtau/E)**2)         ! tau velocity 
      e4 = (4.0d0 *PI *alpha)**2           ! (electric charge)^4
      gam = E/mtau                         ! Lorentz factor for tau
      Fnorm= 2*(2*PI**2*ALPHA**2)          ! for normalization as in tauspinner. 

c  Cotribution to anomalous magnetic moment in Standard Model:
      ASM = 1.17721d-3
      ASM = ASM *iqed                     ! switch for dipole SM part
      A1 = ASM + A                        ! Standard Model + New Physics

      D2 = (V**2 *dcos(theta)**2 -1.d0)**2     ! factor in denominator NOT used below


      R(1,1) = 
     $  (e4*(-8.d0 + 8.d0*gam**2 - 16.d0*B**2*gam**2 - 4.d0*gam**4 - 
     $ 16.d0*A1*gam**4 - 20.d0*A1**2*gam**4 - 8.d0*A1**3*gam**4 - 
     $ 2.d0*A1**4*gam**4 + 12.d0*B**2*gam**4 - 8.d0*A1*B**2*gam**4 - 
     $ 4.d0*A1**2*B**2*gam**4 - 2.d0*B**4*gam**4 + 
     $ 2.d0*A1**4*gam**6 - 8.d0*B**2*gam**6 + 
     $ 4.d0*A1**2*B**2*gam**6 + 2.d0*B**4*gam**6 - A1**4*gam**8 - 
     $ 2.d0*A1**2*B**2*gam**8 - B**4*gam**8 + 
     $      gam**2*(-8.d0 + 2.d0*
     $          (4.d0 + 4.d0*A1**3 + A1**4 - 6.d0*B**2 + B**4 + 
     $ 4.d0*A1*(2.d0 + B**2) + 2.d0*A1**2*(5.d0 + B**2))*gam**2 - 
     $ 4.d0*(A1**4 - 4.d0*B**2 + 2.d0*A1**2*B**2 + B**4)*gam**4 + 
     $ 3.d0*(A1**2 + B**2)**2*gam**6)*V**2*dcos(theta)**2 + 
     $      (A1**2 + B**2)**2*gam**8*V**6*dcos(theta)**6 - 
     $      gam**4*V**4*dcos(theta)**4*
     $  (4.d0 + 8.d0*B**2*gam**2 - B**4*gam**2 + 2.d0*B**4*gam**4 + 
     $         A1**4*gam**2*(-1.d0 + 2.d0*gam**2) + 
     $         2.d0*A1**2*B**2*gam**2*(-1.d0 + 2.d0*gam**2) + 
     $ (A1**2 + B**2)**2*gam**2*(-1.d0 + gam**2)*dcos(2.d0*theta)) +
     $          2.d0*gam**2*(-1.d0 + gam**2)*
     $       (2.d0 + 2.d0*A1 + A1**2*gam**2 + B**2*gam**2)**2*
     $      dsin(theta)**2 - 2.d0*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      4.d0*A1*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      4.d0*A1**2*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1**3*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      A1**4*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*B**2*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1*B**2*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1**2*B**2*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      B**4*gam**4*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1**2*gam**6*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1**3*gam**6*V**2*dsin(2.d0*theta)**2 + 
     $      A1**4*gam**6*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*B**2*gam**6*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1*B**2*gam**6*V**2*dsin(2.d0*theta)**2 + 
     $      2.d0*A1**2*B**2*gam**6*V**2*dsin(2.d0*theta)**2 + 
     $      B**4*gam**6*V**2*dsin(2.d0*theta)**2 - 
     $      A1**4*gam**8*V**2*dsin(2.d0*theta)**2 - 
     $      2.d0*A1**2*B**2*gam**8*V**2*dsin(2.d0*theta)**2 - 
     $      B**4*gam**8*V**2*dsin(2.d0*theta)**2))/
     $  (4.d0*gam**4*(-1.d0 + V**2*dcos(theta)**2)**2)
	 

      R(1,2) = 
     $ (B*e4*V*(-32.d0 + 32.d0*A1 - 48.d0*gam**2 - 192.d0*A1*gam**2 -   
     $ 52.d0*A1**2*gam**2 - 20.d0*B**2*gam**2 + 112.d0*A1*gam**4 + 
     $ 44.d0*A1**2*gam**4 + 12.d0*B**2*gam**4 + 28.d0*gam**2*V**2 + 
     $  120.d0*A1*gam**2*V**2 + 27.d0*A1**2*gam**2*V**2 + 
     $  3.d0*B**2*gam**2*V**2 - 172.d0*A1*gam**4*V**2 - 
     $  65.d0*A1**2*gam**4*V**2 - 9.d0*B**2*gam**4*V**2 + 
     $  72.d0*A1*gam**4*V**4 + 27.d0*A1**2*gam**4*V**4 + 
     $  3.d0*B**2*gam**4*V**4 + 
     $  4.d0*(8.d0 + B**2*gam**4*(-1.d0 - 2.d0*V**2 + V**4) + 
     $         A1**2*gam**2*
     $        (-5.d0 + 7.d0*gam**2 + (9.d0 - 18.d0*gam**2)*V**2 + 
     $            9.d0*gam**2*V**4) + 
     $         gam**2*(-4.d0 + 8.d0*V**2 + B**2*(3.d0 + V**2)) + 
     $         4.d0*A1*(2.d0 + gam**2*(-6.d0 + 9.d0*V**2) + 
     $  gam**4*(5.d0 - 12.d0*V**2 + 6.d0*V**4)))*dcos(2.d0*theta) + 
     $  gam**2*V**2*(4.d0 + B**2*(1.d0 + gam**2*(1.d0 + V**2)) + 
     $         4.d0*A1*(6.d0 + gam**2*(-5.d0 + 6.d0*V**2)) + 
     $ A1**2*(9.d0 + gam**2*(-7.d0 + 9.d0*V**2)))*dcos(4.d0*theta)))/ 
     $  (16.d0*gam**2*(-1.d0 + V**2*dcos(theta)**2)**2)
	 

      R(1,3) = 
     $  -(e4*dcos(theta)*(4.d0 - 4.d0*gam**2 + 4.d0*B**2*gam**2 - 
     $  4.d0*B**2*gam**4 + B**4*gam**4 - B**4*gam**6 - 4.d0*V**2 - 
     $  4.d0*B**2*V**2 + 4.d0*gam**2*V**2 - 6.d0*B**2*gam**2*V**2 - 
     $  2.d0*B**4*gam**2*V**2 + 4.d0*B**2*gam**4*V**2 + 
     $       B**4*gam**6*V**2 + 
     $  4.d0*A1**3*gam**2*(1.d0 - gam**2 + (-2.d0 + gam**2)*V**2) + 
     $       A1**4*(gam**4 - gam**6 + 
     $          gam**2*(-2.d0 + gam**4)*V**2) + 
     $       2.d0*A1**2*(-((-1.d0 + gam**2)*
     $             (2.d0 + 2.d0*gam**2 + B**2*gam**4)) + 
     $  gam**2*(-3.d0 + 2.d0*gam**2 + B**2*(-2.d0 + gam**4))*V**2) +
     $         4.d0*A1*(2.d0 + B**2*gam**4*(-1.d0 + V**2) + 
     $          gam**2*(-2.d0 + V**2 + B**2*(1.d0 - 2.d0*V**2))) - 
     $       2.d0*gam**2*V**2*
     $        (2.d0*(-1.d0 + V**2) + 
     $   B**2*(-2.d0*(1.d0 + gam**2) + (1.d0 + 2.d0*gam**2)*V**2) + 
     $          2.d0*A1**3*(-1.d0 + gam**2*(-1.d0 + V**2)) + 
     $          A1**4*(-1.d0 + gam**2 + gam**4*(-1.d0 + V**2)) + 
     $          B**4*(-1.d0 + gam**2 + gam**4*(-1.d0 + V**2)) + 
     $          2.d0*A1*(-2.d0 + V**2 + 
     $             B**2*(-1.d0 + gam**2*(-1.d0 + V**2))) + 
     $     A1**2*(-4.d0 - 2.d0*gam**2 + V**2 + 2.d0*gam**2*V**2 + 
     $      2.d0*B**2*(-1.d0 + gam**2 + gam**4*(-1.d0 + V**2))))*
     $        dcos(theta)**2 + 
     $       (A1**2 + B**2)**2*gam**4*V**4*
     $  (1.d0 + gam**2*(-1.d0 + V**2))*dcos(theta)**4)*dsin(theta))/
     $  (2.d0*gam*(-1.d0 + V**2*dcos(theta)**2)**2)
 

      R(1,4) = 0.d0

      R(2,1) = -R(1,2)


      R(2,2) = 
     $   (e4*(-8.d0 + (8.d0 - 16.d0*B**2)*gam**2 - 
     $  2.d0*(2.d0 + 4.d0*A1**3 + A1**4 - 6.d0*B**2 + B**4 + 
     $  4.d0*A1*(2.d0 + B**2) + 2.d0*A1**2*(5.d0 + B**2))*gam**4 + 
     $  2.d0*(A1**4 - 4.d0*B**2 + 2.d0*A1**2*B**2 + B**4)*gam**6 - 
     $      (A1**2 + B**2)**2*gam**8 + 
     $      gam**2*(-8.d0 + 2.d0*
     $          (4.d0 + 4.d0*A1**3 + A1**4 - 6.d0*B**2 + B**4 + 
     $  4.d0*A1*(2.d0 + B**2) + 2.d0*A1**2*(5.d0 + B**2))*gam**2 - 
     $  4.d0*(A1**4 - 4.d0*B**2 + 2.d0*A1**2*B**2 + B**4)*gam**4 + 
     $  3.d0*(A1**2 + B**2)**2*gam**6)*V**2*dcos(theta)**2 - 
     $      gam**4*(4.d0 + 8.d0*B**2*gam**2 + 
     $         A1**4*gam**2*(-2.d0 + 3.d0*gam**2) + 
     $      2.d0*A1**2*B**2*gam**2*(-2.d0 + 3.d0*gam**2) + 
     $    B**4*gam**2*(-2.d0 + 3.d0*gam**2))*V**4*dcos(theta)**4 + 
     $    (A1**2 + B**2)**2*gam**8*V**6*dcos(theta)**6))/
     $  (4.d0*gam**4*(-1.d0 + V**2*dcos(theta)**2)**2)
	 

      R(2,3) = 
     $     -(B*e4*V*(-16.d0 + 8.d0*gam**2 - 6.d0*B**2*gam**2 + 
     $       2.d0*B**2*gam**4 -
     $       4.d0*gam**2*V**2 + 7.d0*B**2*gam**2*V**2 - 
     $       3.d0*B**2*gam**4*V**2 + B**2*gam**4*V**4 - 
     $       A1**2*gam**2*(-10.d0 + 14.d0*gam**2 + V**2 - 
     $          21.d0*gam**2*V**2 + 7.d0*gam**2*V**4) - 
     $       4.d0*A1*(4.d0 + 6.d0*gam**2*(-2.d0 + V**2) + 
     $          5.d0*gam**4*(2.d0 - 3.d0*V**2 + V**4)) - 
     $    gam**2*V**2*(4.d0 + B**2*(1.d0 + gam**2 - gam**2*V**2) + 
     $          4.d0*A1*(6.d0 + 5.d0*gam**2*(-1.d0 + V**2)) + 
     $ A1**2*(9.d0 + 7.d0*gam**2*(-1.d0 + V**2)))*dcos(2.d0*theta))*
     $ dsin(2.d0*theta))/(8.d0*gam*(-1.d0 + V**2*dcos(theta)**2)**2)
	 

      R(2,4) = 0.d0

      R(3,1) = R(1,3)

      R(3,2) = -R(2,3)


      R(3,3) = 
     $   -(e4*(-8.d0 - 8.d0*(-3.d0 + 2.d0*B**2)*gam**2 - 
     $  2.d0*(A1**2 + B**2)**2*gam**10*(-1.d0 + V**2) - 
     $ 2.d0*gam**4*(10.d0 + 4.d0*A1**3 + A1**4 + B**4 - 4.d0*V**2 + 
     $  4.d0*A1*(2.d0 + B**2 + 2.d0*V**2) + 
     $  2.d0*A1**2*(5.d0 + B**2 + 2.d0*V**2) + 
     $        B**2*(-22.d0 + 8.d0*V**2)) +
     $  2.d0*gam**6*(4.d0 + 3.d0*A1**4 + 3.d0*B**4 - 4.d0*V**2 + 
     $  2.d0*A1**2*(10.d0 + 3.d0*B**2 - 8.d0*V**2) - 
     $  4.d0*A1**3*(-2.d0 + V**2) + 4.d0*B**2*(-4.d0 + 3.d0*V**2) - 
     $  4.d0*A1*(B**2*(-2.d0 + V**2) + 4.d0*(-1.d0 + V**2))) + 
     $       gam**8*(A1**4*(-5.d0 + 2.d0*V**2) + 
     $          2.d0*A1**2*B**2*(-5.d0 + 2.d0*V**2) + 
     $   B**2*(-16.d0*(-1.d0 + V**2) + B**2*(-5.d0 + 2.d0*V**2))) + 
     $       gam**2*(-2.d0*gam**2*(-1.d0 + gam**2)*
     $   (2.d0 + 2.d0*A1 + A1**2*gam**2 + B**2*gam**2)**2 + 
     $ (-8.d0 + 2.d0*(4.d0 + 4.d0*A1**3 + A1**4 - 
     $            14.d0*B**2 + B**4 +
     $   4.d0*A1*(2.d0 + B**2) + 2.d0*A1**2*(5.d0 + B**2))*gam**2 -
     $   16.d0*(A1 + 3.d0*A1**3 + A1**4 + 3.d0*A1*B**2 + 
     $                B**2*(-1.d0 + B**2) + 2*A1**2*(2.d0 + B**2))*
     $              gam**4 + 
     $             (16.d0*A1**3 + 11.d0*A1**4 + 16.d0*A1*B**2 + 
     $ B**2*(-16.d0 + 11.d0*B**2) + 2.d0*A1**2*(8.d0 + 11.d0*B**2))*
     $            gam**6 - 2.d0*(A1**2 + B**2)**2*gam**8)*V**2 +
     $            4.d0*gam**4*
     $           (2.d0 - 2.d0*A1**3*(-3.d0 + gam**2) + 
     $           B**2*(-2.d0 + 6.d0*gam**2) + 
     $           A1**4*(1.d0 - gam**2 + gam**4) + 
     $           B**4*(1.d0 - gam**2 + gam**4) + 
     $           A1*(8.d0 - 2.d0*B**2*(-3.d0 + gam**2)) + 
     $           2.d0*A1**2*
     $           (6.d0 - gam**2 + B**2*(1.d0 - gam**2 + gam**4)))*
     $           V**4)*dcos(theta)**2 - 
     $           gam**4*V**2*(-4.d0*gam**2*
     $           (2.d0 + 2.d0*A1**3*(1.d0 + gam**2) + 
     $            2.d0*B**2*(1.d0 + gam**2) + 
     $            A1**4*(1.d0 - gam**2 + gam**4) + 
     $            B**4*(1.d0 - gam**2 + gam**4) + 
     $            2.d0*A1*(2.d0 + B**2*(1.d0 + gam**2)) + 
     $            2.d0*A1**2*
     $     (2.d0 + gam**2 + B**2*(1.d0 - gam**2 + gam**4))) + 
     $   (4.d0 - 2.d0*(-4.d0 - 8.d0*A1 + A1**4 - 8.d0*B**2 + B**4 + 
     $      2.d0*A1**2*(-2.d0 + B**2))*gam**2 + 
     $     (16.d0*A1**3 + 7.d0*A1**4 + 16.d0*A1*B**2 + 7.d0*B**4 + 
     $      2.d0*A1**2*(8.d0 + 7.d0*B**2))*gam**4 + 
     $      2.d0*(A1**2 + B**2)**2*gam**6)*V**2 + 
     $      2.d0*gam**4*(-4.d0*A1**3 - 4.d0*A1*B**2 + 
     $             A1**4*(-1.d0 + gam**2) + 
     $             2.d0*A1**2*(-2.d0 + B**2*(-1.d0 + gam**2)) + 
     $             B**2*(4.d0 + B**2*(-1.d0 + gam**2)))*V**4)*
     $        dcos(theta)**4 + 
     $       (A1**2 + B**2)**2*gam**8*V**4*
     $       (2.d0 - 2.d0*gam**2 + 
     $       (1.d0 + 2.d0*gam**2)*V**2)*dcos(theta)**6))/
     $   (4.d0*gam**4*(-1.d0 + V**2*dcos(theta)**2)**2)
	

      R(3,4) = 0.d0

      R(4,1) = 0.d0

      R(4,2) = 0.d0

      R(4,3) = 0.d0


      R(4,4) =
     $    -(e4*(8.d0 - 8.d0*gam**2 + 
     $  2.d0*(-2.d0 + 4.d0*A1**3 + A1**4 + 2.d0*B**2 + B**4 + 
     $  4.d0*A1*(-2.d0 + B**2) + 2.d0*A1**2*(-1.d0 + B**2))*gam**4 - 
     $  2.d0*(8.d0*A1**3 + A1**4 + 8.d0*A1*B**2 + 
     $        2.d0*A1**2*(4.d0 + B**2) +
     $        B**2*(8.d0 + B**2))*gam**6 - 
     $       (A1**2 + B**2)**2*gam**8 + 
     $   gam**2*(8.d0 + 8.d0*A1**3*gam**2*(-1.d0 + 4.d0*gam**2) + 
     $         4.d0*B**2*gam**2*(-1.d0 + 8.d0*gam**2) + 
     $         A1**4*gam**2*(-2.d0 + 4.d0*gam**2 + 3.d0*gam**4) + 
     $         B**4*gam**2*(-2.d0 + 4.d0*gam**2 + 3.d0*gam**4) + 
     $         8.d0*A1*gam**2*(2.d0 + B**2*(-1.d0 + 4.d0*gam**2)) + 
     $         2.d0*A1**2*gam**2*
     $   (2.d0 + 16.d0*gam**2 + B**2*(-2.d0 + 4.d0*gam**2 + 
     $         3.d0*gam**4)))*
     $         V**2*dcos(theta)**2 - 
     $   gam**4*(-4.d0 + 16.d0*A1**3*gam**2 + 16.d0*B**2*gam**2 + 
     $   16.d0*A1*B**2*gam**2 + A1**4*gam**2*(2.d0 + 3.d0*gam**2) + 
     $          B**4*gam**2*(2.d0 + 3.d0*gam**2) + 
     $   2.d0*A1**2*gam**2*(8.d0 + B**2*(2.d0 + 3.d0*gam**2)))*V**4*
     $        dcos(theta)**4 + 
     $       (A1**2 + B**2)**2*gam**8*V**6*dcos(theta)**6))/
     $  (4.d0*gam**4*(-1.d0 + V**2*dcos(theta)**2)**2)

! to normalize as in tauspinner
   ! FNORM=1.0
      do k=1,4
         do l=1,4
            R(k,l)=R(k,l)/FNORM
         enddo
      enddo
	 
	 
      return
      end

      
      Subroutine DipolQQ(iqed,Energy,theta,channel,Amz0,Gamz0,sin2W0,alphaQED,ReA0,ImA0, ReB,ImB, ReX,ImX,ReY,ImY,GSWr,GSWi,R)
!
!     This routine performs adjustment of frame orientation between conventions used by Korchin and the one of TauSpinner
!     which is inherited from conventions of KORALB-KKMC: that consist of  rotations
!     Also  index shift is performed from  xyzt (1234) to txyz  [in c++ that will be seen as (0123)]
      
	implicit none
        real*8 Amz0,Gamz0,sin2W0,alphaQED,GSWr(7),GSWi(7)
	integer iqed,channel,k,j,k0,j0
	real*8 Energy,theta,ReA,ImA,ReA0,ImA0,ReB,ImB,ReX,ImX,ReY,ImY,xnor,thet, buf
        real*8 R(1:4, 1:4),R0(1:4, 1:4),sign(4)
!	ReA0=0
!	ImA0=0
!	ReB=0
!	ImB=0
!	ReX=0
!	ImX=0
!	ReY=0
!	ImY=0
        sign(1)=-1.0
        sign(2)= 1.0
        sign(3)=-1.0
        sign(4)= 1.0
        thet=acos(cos(theta))
        
	call DipolQQRijRadCor (iqed,Energy, thet,Amz0,Gamz0,sin2W0,alphaQED,
     #                GSWr,GSWi, ReA0, ImA0, ReB, ImB, ReX, ImX, ReY, ImY, R0, channel)


        
! rotation from q ~q --> tau- tau+  to  ~q q --> tau+ tau- frames.
!               WARNING: we normalize R0, but  x-section is set into R0(4,4).        
        xnor=R0(4,4)
        do k=1,4
          do j=1,4
              R0(k,j)=R0(k,j)/XNOR*sign(k)*sign(j)
           enddo
        enddo
        R0(4,4)=xnor

 ! rotation in second index by angle pi/2 around z-axis       
        do k=1,4
           do j=1,4
              if(j.eq.1) then
                 buf=R0(k,2)
                 R0(k,2)=R0(k,j)
                 R0(K,1)=-buf
              endif
              
           enddo
        enddo

! rotation in first index by angle pi/2  around z-axis 
        do j=1,4
           do k=1,4
             if(k.eq.1) then
                 buf=R0(2,j)
                 R0(2,j)=R0(k,j)
                 R0(1,j)=-buf
              endif

           enddo
        enddo


! shift order of entries  from x,y,z,t  to t,x,y,z  (necessary for C++ conventions). 
        do k0=1,4
           do j0=1,4
               k=k0+1
               j=j0+1
               if(j.eq.5) j=1
               if(k.eq.5) k=1
               R(k,j)=R0(k0,j0)
           enddo
        enddo
 !       if(R0(3,3)/R0(4,4).gt.1d0) then
  !         write(*,*) "z fortranu thet=", thet," energy= ",energy, " Rzz=", R0(3,3)/R0(4,4)," ", R0(3,3)," ",R0(4,4)
           
 !          write(*,*) "iqed,Energy, thet, channel ",iqed,Energy, thet, channel
        !   write(*,*)  "Amz0,Gamz0,sin2W0,alphaQED ",   Amz0,Gamz0,sin2W0,alphaQED
      !      write(*,*)  "ReA0, ImA0, ReB, ImB ",   ReA0, ImA0, ReB, ImB
      !      write(*,*)  "ReX, ImX, ReY, ImY ",    ReX, ImX, ReY, ImY
   !      write(*,*)  "GSWr ",   GSWr
   !      write(*,*)  "GSWi ",   GSWi
   !     endif
    !  IF(R(4,4)/R(1,1).gt.1.0) then
    !    write(*,*) "==============",R(4,4)/R(1,1)
    !    write(*,*) 'energuy,theta,channel= ',Energy,' ',cos(theta),' ',channel
    !    do k=1,4
    !       write(*,7) k, R(k,1)/R(1,1),R(k,2)/R(1,1),R(k,3)/R(1,1),R(k,4)/R(1,1)
    !   enddo
    !  endif
      

 7      format(1x,i4, 4(2x,f12.6))
        
      end

      Subroutine DipolQQRijRadCor (iqed,Energy,theta,Amz0,Gamz0,sin2W0,alphaQED,
     #                             GSWr,GSWi,ReA0,ImA0,ReB,ImB,ReX,ImX,ReY,ImY,R,channel)
C     version of dipole routine with electroweak form factors included, 
C     If ported to different applications, beware of electroweak schemes, constant
C     and form-factors initialization
C     qed anomalous magnetic moment coded, but commented out      
C     (comments)  #####################################
C     1) code is adopted to run  with KKMC
C     2) and EW for channel=1  (initial state e, final state tau or mu.
C     3) internal activation of electroweak KKMC libs with IfGSW=KeyElw, call BornV_GetKeyElw(KeyElw)
C     4) note distinct conventions, papers:  e-Print: 2307.03526 versus Eur.Phys.J.C 79 (2019) 6, 480     
C        that is  about  photon/Z normalization too
C     ########################################################
      
c             PROCESS   fermion_i + fermionbar_i -> fermion_f- + fermionbar_f   
c  
c           IMPROVED BORN APPROXIMATION (IBA) with radiative corrections
c  Integer parameter channel = 1 for LEPTONS, 2 -for UP QUARK, 3 - for DOWN QUARK
c 
c  Photon and Z-boson exchanges are included. 
c  Calculates spin-correlation coefficients R(i,j) as functions of beam
c  energy: Energy = sqrt(s)/2 (in GeV), and scattaring angle theta.
c
c  Anomalous magnetic formfactor A = ReA +i*ImA, 
c  and electric dipole formfactor B = ReB + i*ImB are complex.
c  Also weak anomalous magnetic formfactor X = ReX + i*ImX and 
c  weak electric dipole formfactor Y = ReY + i*ImY are complex. 
c  
c  V is velocity of tau, gam is Lorentz factor, alpha is fine-structure constant,
c  G_F is Fermi constant of weak interaction.
c  RSM(i,j) - spin-correlation matrix in IBA without anomalous moments.
c  RDM(i,j) - spin-correlation matrix, linear in anomalous dipole moments A, B, X, Y.
c  R(i,j) - total spin-correlation matrix. 
c  Order of coefficients R(ij):  i = 1,2,3 correspond to S_x, S_y, S_z for tau-,
c                                j = 1,2,3 correspond to S'_x, S'_y, S'_z for tau+,
c                                i = j = 4 corresponds to 1 (no spin dependence).
c 
c   Functions below and their notation are from the paper: 
c   E. Richter-Was, Z. Was Eur. Phys.J. C (2019) 79, 480
c
c  indices i = 1, 2, 3 correspond to lepton, up quark, down quark, respectively 
c          Gamma_vp - vacuum polarization factor (function of s)
c          Rho_11, Rho_12, Rho_13 =rho_{lepton,i}(s,t) for i= L,Up,Down 	
c          K_1,K_2,K_3 = K_i(s,t)  for i= L, Up, Down
c          K_11,K_12,K_13  = K_{lepton,i}(s,t) for i = L,Up,Down
                                                                       
      Implicit none
!       INCLUDE '../../basf2/KK2f/GPS.fi'
	real*8  m_sw2,m_MZ,m_GammZ,m_gmu,m_alfinv,m_swsq,m_pi
  !    INCLUDE '../../basf2/bornv/BornV.fi'
cc not needed     external function K_1, K_2, K_3, K_11, K_12, K_13 
cc not needed     external function Rho_11,Rho_12,Rho_13,Gamma_vp
	  complex*16 A,B,X,Y, Pg, Pz, Den, vi, vf 
	  complex*16 K1,K2,K3,K11,K12,K13,Gammavp,Rho11,Rho12,Rho13
          DOUBLE COMPLEX     GSW(100)
          real*8 Amz0,Gamz0,sin2W0,alphaQED,GSWr(7),GSWi(7)
          DOUBLE PRECISION Svar,CosThetD
       DOUBLE COMPLEX    RhoEW, VPgamma, CorEle, CorFin, CorEleFin, VVCef  	  
	  integer i, j, channel,iqed,KFf,IfGSW,KeyElw,IfPrint                  
      real*8 Energy,theta,ReA,ImA,ReA0,ImA0,ReB,ImB,ReX,ImX,ReY,ImY,gam,V
      real*8 ArQED, AiQED, Ar1, Ai1
	  real*8 e, f, m, Qi, Qf, ai, af, sw2, sw, cw2,cw, s, t, Fvivf  
      real*8 R(1:4, 1:4), RSM(1:4, 1:4), RDM(1:4, 1:4)
      real*8 PI/3.141592653589793238d0/,alpha/7.2973525693d-3/
	  real*8 Mz/91.1876d0/,Gz/2.4952d0/      ! Mass and width of Z in GeV
cc     real*8 v0/-0.03783d0/,a0/-0.50123d0/  ! vector and axial couplings of leptons
      real*8 mtau/1.77686d0/                 ! mass of tau in GeV

	  real*8 G_F/1.1663788d-5/                ! from PDG Fermi constant, GeV^{-2}
          real*8 G_mu/1.166389d-5/,Mw/80.353d0/ ! G_mu and M_W from Eur.Phys.J. C (2019) 79, 480
          
C     ==================================================================     
C     definition of form-factors as <in-line> functions. Complex form-factors
C     initialized from KKMC libraries will be used. Note that electroweak
C     scheme need to be reconsidered if function is used for other purposes.
      k3(s,t) = CorEle
      k1(s,t) = CorEle
      k13(s,t) = CorEleFin
      k2(s,t) = CorEle
      k12(s,t) = CorEleFin
      k11(s,t) = CorEleFin
      
      gammavp(s) = VPgamma
      rho11(s,t) = RhoEW
      rho12(s,t) = RhoEW
      rho13(s,t) = RhoEW
C     ===================================================================
    

      KFf=15                    ! 415-400
      Svar=4*Energy**2
      CosThetD=cos(theta)
!         RhoEW     = GSW(1)
!         VPgamma   = GSW(6)
!         CorEle    = GSW(2)
!         CorFin    = GSW(3)
!     CorEleFin = GSW(4)
      IfGSW=1                   ! switch to activate electroweak formfactor
!     call BornV_GetKeyElw(KeyElw)
	IfGSW=KeyElw
	IfGSW=1
	m_pi=pi
        m_Gmu=G_mu
      IfPrint=0  ! switch to activate prints
      If(IfGSW.eq.1) then
!        CALL BornV_InterpoGSW(KFf,Svar,CosThetD)
!        CALL BornV_GetGSW(GSW)
         RhoEW     = dcmplx(GSWr(1),GSWi(1))
         VPgamma   = dcmplx(GSWr(7),GSWi(7)) 
         VPgamma = 1.d0   /(2.d0-dcmplx(GSWr(7),GSWi(7)))
         CorEle    = dcmplx(GSWr(2),GSWi(2))
         CorFin    = dcmplx(GSWr(3),GSWi(3))
         CorEleFin = dcmplx(GSWr(4),GSWi(4))
         sw2 = sin2W0  ! m_Sw2            ! 0.22351946d0     ! sin(theta_w)^2 from  Eur.Phys.J. C (2019) 79, 480
         m_swsq=sw2
         m_sw2=sw2
!     alpha=1.d0/m_AlfInv
         alpha=alphaQED              
         m_AlfInv=1.d0/alpha
         Mz=Amz0                ! m_MZ
         m_MZ=Mz
         Gz=m_GammZ*Svar/Mz**2  ! running width
         m_GammZ=Gamz0
         Gz=Gamz0*Svar/Mz**2  ! running width
         if (ifPrint.eq.1) then
          write(*,*) ' m_KeyElw= ', KeyElw
          write(*,*) 'sw2,alpha,Mz,Gz,svar=',  sw2,alpha,Mz,Gz,svar
          write(*,*) 'G_mu, m_gmu= ', G_mu, m_gmu 
          write(*,*) 'RhoEW     = ',RhoEW!,   GSWr(1)
          write(*,*) 'VPgamma   = ',VPgamma!, GSWr(6)
          write(*,*) 'gsw(6) (7)= ', GSWr(6), GSWr(7)          
          write(*,*) 'CorEle    = ', CorEle!, GSWr(2)
          write(*,*) 'CorFin    = ',CorFin !, GSWr(3)
          write(*,*) 'CorEleFin = ',CorEleFin!, GSWr(5)
          write(*,*) 'CorEleFin -CorEle*CorFin = ',CorEleFin-CorEle*CorFin
!         stop
         endif
      else
         RhoEW     = 1.d0
         VPgamma   = 1.d0
         CorEle    = 1.d0
         CorFin    = 1.d0
         CorEleFin = 1.d0
         sw2 = 0.22351946d0     ! sin(theta_w)^2 from  Eur.Phys.J. C (2019) 79, 480
         m_swsq=sw2
      endif
	  
	  V= dsqrt(1.d0 -(mtau/Energy)**2)       ! tau velocity

c     Contributions to ReA(s) and ImA(s) from QED in one loop
      if(iqed.eq.10) then    ! Warning: temporarily this contribution is blocked
       ArQED = -alpha*mtau**2 /(PI*V*4.d0*Energy**2)*dlog((1.d0+V)/(1.d0-V))
       AiQED = alpha *mtau**2 /(V *4.d0 *Energy**2)
      else
       ArQED = 0.d0   !switch for dipole QED part  
       AiQED = 0.d0
      endif
       
	  

      ReA = ArQED + ReA0                   ! QED + new physics
      ImA = AiQED + ImA0  	               ! QED + new physics 

      
	  m= mtau   
	  gam= Energy/mtau    	                 ! Lorentz factor of tau
      e= dsqrt(4.0d0 *PI *alpha)    	     ! electric charge
c       Below coupling f=g_w/(2*cos(theta_w))=e/(2*cos(theta_w)*sin(theta_w)), 
c       which is expressed via Fermi constant:  
      f = Mz *dsqrt(G_mu *dsqrt(2.d0))  
	  

      sw = dsqrt(sw2)        ! sin(theta_w) 
      cw2 = 1.d0 - sw2
      cw = dsqrt(cw2)	
  	  
c       Mandelstam variables s and t (mass of tau is included in t) 	  
      s = 4.d0 *Energy**2                        
      t = m**2 -0.5d0 *s *(1.d0 -V*dcos(theta))  

c       Denominator of the Z propagator with running width
      Den = s - Mz**2 + (0.d0, 1.d0) *Gz *Mz
c       Constant for effective photon like couplings correction coming from Z boson	  
      Fvivf = 4.d0 *(f**2/e**2) *sw**4 ! WARNING: the *sw**4 factor come from vector couplings numerators Fvivf 
c       Note: Fvivf can also be written as Fvivf= sw**2/cw**2, or through the constant G_mu:
c       Fvivf= sqrt(2) *G_mu *Mz**2 *sw**4 /(pi*alpha)  This agrees with definition below.   
 	  
c       FINAL FERMION IS TAU LEPTON (f=lepton) with couplings: 	  
      Qf= -1.d0                 
      vf= -0.03783d0  ! from PDG, used in previous code (v0 coupling)
      af= -0.50123d0  ! from PDG, used in previous code (a0 coupling)
      if(IfGSW.eq.1) then
        vf= -0.5d0 - 2.d0 *Qf *sw2 * K1(s,t) ! is function for lepto
        af= -0.5d0
       endif
          
c	  
c        COUPLINGS FOR INITIAL FERMIONS e u or d             
      IF (channel.EQ.1) THEN    ! LEPTONS       
	  Qi= -1.d0                                        
      	  vi= -0.03783d0  ! from PDG, used in the previous code
	  ai= -0.50123d0  ! from PDG, used in the previous code	  
c	  
c           Effective Z propagator  (reduces to 1/Den without rad. corr.):	  
          Pz = Rho11(s,t) /Den           
          if(IfGSW.eq.1) then
            vi= -0.5d0 - 2.d0 *Qi *sw2 *K1(s,t)       
            ai= -0.5d0
            if (ifPrint.eq.1) write(*,*) 'no EW-corr  Fvivf=',Fvivf,' Fvivf is for (v_if-v_i*v_f) implemented as add-up to photon'
            Fvivf=
     $            m_Gmu *m_MZ**2 *m_AlfInv /(DSQRT(2.d0)*8.d0*m_pi)
     $             *(m_Sw2*(1.d0-m_Sw2)) *16.d0
            Fvivf=Fvivf              *m_Sw2/(1.d0-m_Sw2) ! why this factor? Because  vi ai couplings in KKMC
                 ! are divided by deno= 4 sqrt(m_swsq*(1d0-m_swsq)) in addition multiplied by 2 and we are not using it here
                 ! Ve = (2*T3e -4*Qe*m_swsq)/deno and Ae = 2*T3e/deno. 
            if (ifPrint.eq.1) then
             write(*,*) 'with EW-corr  Fvivf=',Fvivf,' Fvivf is for (v_if-v_i*v_f) implemented as add-up to photon'
             stop
            endif
         endif
         
C          Effective photon propagator with v_{if}-v_i*v_f correction to Z exchange  
C          (NOTE: Pz reduces to 1/s if  rad. corr. are off): 
	 Pg = 1.d0/s *(Gammavp(s) + Fvivf *s/Den*
     $                              Rho11(s,t)*(K11(s,t)-K1(s,t)*K1(s,t)))
          
c	 
       ELSE IF (channel.EQ.2) THEN 	  ! UP QUARK  	   
        Qi= +2.d0/3.d0                                   
        vi= +0.266d0   ! from PDG, used in the previous code
        ai= +0.519d0   ! from PDG, used in the previous code
        if(IfGSW.eq.1) then 
         vi= +0.5d0 - 2.d0 *Qi *sw2 *K2(s,t)     
         ai= +0.5d0
         if (ifPrint.eq.1) write(*,*) 'no   EW-corr  Fvivf=',Fvivf,' Fvivf is for (v_if-v_i*v_f) implemented as add-up to photon'
         Fvivf=
     $   m_Gmu *m_MZ**2 *m_AlfInv /(DSQRT(2.d0)*8.d0*m_pi)
     $         *(m_Sw2*(1.d0-m_Sw2)) *16.d0
         Fvivf=Fvivf              *m_Sw2/(1.d0-m_Sw2) ! why this factor? Because  vi ai couplings in KKMC
            ! are divided by deno= 4 sqrt(m_swsq*(1d0-m_swsq)) in addition multiplied by 2. 
            ! Ve = (2*T3e -4*Qe*m_swsq)/deno and Ae = 2*T3e/deno. Note that Fvivf is used only for calculation of
            ! (vv_if-v_i*v_f)
         if (ifPrint.eq.1) then
           write(*,*) 'with EW-corr  Fvivf=',Fvivf,' Fvivf is for (v_if-v_i*v_f) implemented as add-up to photon'
           stop
          endif
        endif

c
c       Effective Z propagator (reduces to 1/Den without rad. corr.):
      Pz = Rho12(s,t) /Den 	  
c       Effective photon propagator with v_{if}-v_i*v_f correction to Z exchange  
C       (NOTE: Pz reduces to 1/s if  rad. corr. are off):
      Pg = 1.d0/s *(Gammavp(s) + Fvivf *s/Den*
     $                           Rho12(s,t)*(K12(s,t)-K1(s,t)*K2(s,t))) 
c	 
       ELSE IF (channel.EQ.3) THEN    ! DOWN QUARK 
        Qi= -1.d0/3.d0                                      
        vi= -0.38d0       ! from PDG, used in the previous code
        ai= -0.527d0      ! from PDG, used in the previous code
        if(IfGSW.eq.1) then
          vi= -0.5d0 - 2.d0 *Qi *sw2 *K3(s,t)      
          ai= -0.5d0
          if (ifPrint.eq.1) write(*,*) 'no   EW-corr  Fvivf=',Fvivf,' Fvivf is for (v_if-v_i*v_f) implemented as add-up to photon'
          Fvivf=
     $          m_Gmu *m_MZ**2 *m_AlfInv /(DSQRT(2.d0)*8.d0*m_pi)
     $                *(m_Sw2*(1.d0-m_Sw2)) *16.d0
          Fvivf=Fvivf              *m_Sw2/(1.d0-m_Sw2) ! why this factor? Because  vi ai couplings in KKMC
              ! are divided by deno= 4 sqrt(m_swsq*(1d0-m_swsq)) in addition multiplied by 2. 
              ! Ve = (2*T3e -4*Qe*m_swsq)/deno and Ae = 2*T3e/deno. Note that Fvivf is used only for calculation of
              ! (vv_if-v_i*v_f)
          if (ifPrint.eq.1) then
           write(*,*) 'with EW-corr  Fvivf=',Fvivf,' Fvivf is for (v_if-v_i*v_f) implemented as add-up to photon'
           stop
          endif
        endif
        
c		 
c         Effective Z propagator  (reduces to 1/Den without rad. corr.): 
	Pz = Rho13(s,t) /Den 
c         Effective photon propagator  (reduces to 1/s without rad. corr.): 
        Pg = 1.d0/s *(Gammavp(s) + Fvivf *s/Den*
     $                             Rho13(s,t) *(K13(s,t)-K1(s,t)*K3(s,t))) 
c
      ELSE                           ! OUTPUT WILL BE ZERO     
        Qi= 0.d0                                                
        vi= (0.d0, 0.d0) 
        ai= 0.d0 
        Pz= (0.d0, 0.d0)
        Pg= (0.d0, 0.d0) 	  
      END IF 	   

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc 
c         Complex magnetic and electric form-factors 
      A = dcmplx(ReA, ImA)
      B = dcmplx(ReB, ImB)
      X = dcmplx(ReX, ImX)
      Y = dcmplx(ReY, ImY)

c  Contributions to A(s), X(s) from QED in one loop: NOT INCLUDED 
cc      ArQED = -alpha *mtau**2 /(PI *V *4.d0 *E**2) *dlog((1.d0+V)/(1.d0-V))
cc     AiQED = alpha *mtau**2 /(V *4.d0 *E**2)
cc      Ar1 = ArQED + Ar                     ! QED + new physics
cc      Ai1 = AiQED + Ai                     ! QED + new physics


 
c ----------------------------------------------------------------
c    CONTRIBUTIONS to R(i,j) IN STANDARD MODEL NO DIPOLE MOMENTS 
c ----------------------------------------------------------------
c 

      RSM(1,1)= 4.d0*gam**2*m**4*(e**2*(1.d0 + gam**2)*Qf*Qi*
     -     (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(Pg) + 
     -    f**2*dconjg(Pz)*
     -     (-(af**2*f**2*(-1.d0 + gam**2)*Pz*
     -          (ai**2 + vi*dconjg(vi))) + 
     -       (1.d0 + gam**2)*dconjg(vf)*
     -        (ai**2*f**2*Pz*vf + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))))*
     -  dsin(theta)**2

      RSM(1,2)=  (0.d0, -4.d0)*af*f**2*gam**4*m**4*V*
     -  (e**2*Pz*Qf*Qi*vi*dconjg(Pg) + 
     -    dconjg(Pz)*(-(ai**2*f**2*Pz*vf) - 
     -       (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi) + 
     -       f**2*Pz*dconjg(vf)*(ai**2 + vi*dconjg(vi))))*
     -  dsin(theta)**2

      RSM(2,1)= RSM(1,2)

      RSM(2,2)=  4.d0*gam**2*(-1.d0 + gam**2)*m**4*
     -  (-(e**2*Qf*Qi*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -       dconjg(Pg)) + 
     -    dconjg(Pz)*(af**2*f**4*Pz*
     -        (ai**2 + vi*dconjg(vi)) - 
     -       f**2*dconjg(vf)*
     -        (ai**2*f**2*Pz*vf + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))))*
     -  dsin(theta)**2

      RSM(1,3)=   4.d0*gam**3*m**4*(e**2*Qf*Qi*dconjg(Pg)*
     -     (af*ai*f**2*Pz*V - 
     -       2.d0*gam**2*(-1.d0 + V**2)*
     -        (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (af*(ai*V*(e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vf*(vi + dconjg(vi))) + 
     -          2.d0*af*f**2*Pz*(1.d0 + gam**2*(-1.d0 + V**2))*
     -           (ai**2 + vi*dconjg(vi))*dcos(theta)) + 
     -       dconjg(vf)*
     -        (ai*f**2*Pz*(af*V*vi - 
     -             2.d0*ai*gam**2*(-1.d0 + V**2)*vf*dcos(theta)) + 
     -          dconjg(vi)*
     -           (af*ai*f**2*Pz*V - 
     -             2.d0*gam**2*(-1.d0 + V**2)*
     -              (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dcos(theta))))
     -    )*dsin(theta)

      RSM(3,1)= RSM(1,3)

      RSM(2,3)=  (0.d0, -2.d0)*af*f**2*gam**3*m**4*V*
     -  (e**2*Pz*Qf*Qi*vi*dconjg(Pg) + 
     -    dconjg(Pz)*(-(ai**2*f**2*Pz*vf) - 
     -       (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi) + 
     -       f**2*Pz*dconjg(vf)*(ai**2 + vi*dconjg(vi))))*
     -  dsin(2.d0*theta)

      RSM(3,2)= RSM(2,3)
     
      RSM(3,3)=  2.d0*gam**2*m**4*(-(e**4*Pg*Qf**2*Qi**2*dconjg(Pg)*
     -       (1.d0 - 3.d0*gam**2 + 
     -         (-1.d0 + 3.d0*gam**2 + 4.d0*gam**4*(-1.d0 + V**2))*
     -          dcos(2.d0*theta))) - 
     -    e**2*f**2*Qf*Qi*(Pz*dconjg(Pg)*
     -        (-4.d0*af*ai*gam**2*V*dcos(theta) + 
     -          vf*vi*(1.d0 - 3.d0*gam**2 + 
     -          (-1.d0 + 3.d0*gam**2 + 4.d0*gam**4*(-1.d0 + V**2))*
     -              dcos(2.d0*theta))) + 
     -       Pg*dconjg(Pz)*
     -        (-4.d0*af*ai*gam**2*V*dcos(theta) + 
     -          dconjg(vf)*dconjg(vi)*
     -           (1.d0 - 3.d0*gam**2 + 
     -          (-1.d0 + 3.d0*gam**2 + 4.d0*gam**4*(-1.d0 + V**2))*
     -              dcos(2.d0*theta)))) + 
     -    f**4*Pz*dconjg(Pz)*
     -     (af*(4*ai*gam**2*V*vf*(vi + dconjg(vi))*
     -           dcos(theta) + 
     -          af*(ai**2 + vi*dconjg(vi))*
     -           (1.d0 + gam**2*(-1.d0 + 4.d0*V**2) + 
     -          (-1.d0 + 5.d0*gam**2 + 4.d0*gam**4*(-1.d0 + V**2))*
     -              dcos(2.d0*theta))) + 
     -       dconjg(vf)*
     -        (dconjg(vi)*
     -           (4.d0*af*ai*gam**2*V*dcos(theta) + 
     -             vf*vi*(-1.d0 + 3.d0*gam**2 + 
     -            (1.d0 - 3.d0*gam**2 - 4.d0*gam**4*(-1.d0 + V**2))*
     -                 dcos(2.d0*theta))) + 
     -          ai*(4.d0*af*gam**2*V*vi*dcos(theta) - 
     -             ai*vf*(1.d0 - 3.d0*gam**2 + 
     -            (-1.d0 + 3.d0*gam**2 + 4.d0*gam**4*(-1.d0 + V**2))*
     -                 dcos(2.d0*theta))))))    

      RSM(1,4)=  -4.d0*f**2*gam**3*m**4*
     -  (e**2*Pz*Qf*Qi*dconjg(Pg)*
     -     (2.d0*ai*vf + af*V*vi*dcos(theta)) + 
     -    dconjg(Pz)*(af*V*
     -        (ai**2*f**2*Pz*vf + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))*
     -        dcos(theta) + 
     -       dconjg(vf)*
     -        (2.d0*ai*(e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vf*(vi + dconjg(vi))) + 
     -          af*f**2*Pz*V*(ai**2 + vi*dconjg(vi))*
     -           dcos(theta))))*dsin(theta)

      RSM(4,1)= RSM(1,4)        

      RSM(2,4)=  (0.d0, 4.d0)*af*ai*f**2*gam**3*m**4*V*
     -  (e**2*Pz*Qf*Qi*dconjg(Pg) + 
     -    dconjg(Pz)*(-(e**2*Pg*Qf*Qi) - 
     -       f**2*Pz*vf*(vi + dconjg(vi)) + 
     -       f**2*Pz*dconjg(vf)*(vi + dconjg(vi))))*
     -  dsin(theta)

      RSM(4,2)= RSM(2,4)

      RSM(3,4)=  -4.d0*f**2*gam**2*m**4*
     -  (e**2*gam**2*Pz*Qf*Qi*dconjg(Pg)*
     -   (2.d0*ai*vf*dcos(theta) + af*V*vi*(1.d0 + dcos(theta)**2)) + 
     -    (dconjg(Pz)*(dconjg(vi)*
     -          (4.d0*af**2*ai*f**2*(-1.d0 + gam**2)*Pz*dcos(theta) + 
     -            4.d0*ai*f**2*gam**2*Pz*vf*dconjg(vf)*
     -             dcos(theta) + 
     -            af*gam**2*V*
     -             (e**2*Pg*Qf*Qi + 
     -               f**2*Pz*vi*(vf + dconjg(vf)))*
     -             (3.d0 + dcos(2.d0*theta))) + 
     -         ai*(gam**2*dconjg(vf)*
     -             (4.d0*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -                dcos(theta) + 
     -               af*ai*f**2*Pz*V*(3.d0 + dcos(2.d0*theta))) + 
     -            af*f**2*Pz*
     -             (4.d0*af*(-1.d0 + gam**2)*vi*dcos(theta) + 
     -             ai*gam**2*V*vf*(3.d0 + dcos(2.d0*theta))))))/2.d0)

      RSM(4,3)= RSM(3,4) 


      RSM(4,4)=  2.d0*gam**2*m**4*(e**4*Pg*Qf**2*Qi**2*dconjg(Pg)*
     -     (1.d0 + 3.d0*gam**2 + (-1.d0 + gam**2)*dcos(2.d0*theta)) + 
     -    e**2*f**2*Qf*Qi*(Pz*dconjg(Pg)*
     -        (4.d0*af*ai*gam**2*V*dcos(theta) + 
     -  vf*vi*(1.d0 + 3.d0*gam**2 + (-1.d0 + gam**2)*dcos(2.d0*theta))
     -          ) + Pg*dconjg(Pz)*
     -        (4.d0*af*ai*gam**2*V*dcos(theta) + 
     -          dconjg(vf)*dconjg(vi)*
     -    (1.d0 + 3.d0*gam**2 + (-1.d0 + gam**2)*dcos(2.d0*theta)))) - 
     -    f**4*Pz*dconjg(Pz)*
     -     (-(af*(4.d0*ai*gam**2*V*vf*(vi + dconjg(vi))*
     -             dcos(theta) + 
     -            af*(-1.d0 + gam**2)*(ai**2 + vi*dconjg(vi))*
     -             (3.d0 + dcos(2.d0*theta)))) - 
     -       dconjg(vf)*
     -        (ai*(4.d0*af*gam**2*V*vi*dcos(theta) + 
     -             ai*vf*(1.d0 + 3.d0*gam**2 + 
     -                (-1.d0 + gam**2)*dcos(2.d0*theta))) + 
     -          dconjg(vi)*
     -           (4.d0*af*ai*gam**2*V*dcos(theta) + 
     -             vf*vi*(1.d0 + 3.d0*gam**2 + 
     -                (-1.d0 + gam**2)*dcos(2.d0*theta))))))


c -------------------------------------------------------------
c CONTRIBUTION TO R(i,j), LINEAR IN DIPOLE MOMENTS A, B, X, Y 
c -------------------------------------------------------------

      RDM(1,1)= 8.d0*gam**4*m**4*(e**2*Qf*Qi*
     -     (e**2*Pg*Qf*Qi*(A + dconjg(A)) + 
     -       f**2*Pz*vi*(X + vf*dconjg(A)))*dconjg(Pg) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai**2*f**2*Pz*X + 
     -        (A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*dconjg(vi)) +
     -         (ai**2*f**2*Pz*vf + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))*
     -        dconjg(X)))*dsin(theta)**2

      RDM(1,2)=  4.d0*gam**4*m**4*V*(e**2*Qf*Qi*
     -     (e**2*Pg*Qf*Qi*(B + dconjg(B)) + 
     -       f**2*Pz*vi*(Y - (0.d0, 1.d0)*af*dconjg(A) + 
     -          vf*dconjg(B)))*dconjg(Pg) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai**2*f**2*Pz*Y + 
     -          (B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*dconjg(vi)) +
     -         (0.d0, 1.d0)*af*(dconjg(vi)*
     -           (A*e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vi*(X - dconjg(X))) + 
     -          ai**2*f**2*Pz*(X - dconjg(X))) + 
     -       (ai**2*f**2*Pz*vf + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))*
     -        dconjg(Y)))*dsin(theta)**2

      RDM(2,1)=  -4.d0*gam**4*m**4*V*(e**2*Qf*Qi*
     -     (e**2*Pg*Qf*Qi*(B + dconjg(B)) + 
     -       f**2*Pz*vi*(Y + (0,1)*af*dconjg(A) + 
     -          vf*dconjg(B)))*dconjg(Pg) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai**2*f**2*Pz*Y + 
     -          (B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*dconjg(vi)) -
     -         (0.d0 ,1.d0)*af*(dconjg(vi)*
     -           (A*e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vi*(X - dconjg(X))) + 
     -          ai**2*f**2*Pz*(X - dconjg(X))) + 
     -       (ai**2*f**2*Pz*vf + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))*
     -        dconjg(Y)))*dsin(theta)**2

      RDM(2,2)= 0.d0

      RDM(1,3)=  4.d0*gam**5*m**4*(-(e**2*Qf*Qi*dconjg(Pg)*
     -       ((0.d0, -1.d0)*ai*f**2*Pz*V*
     -          (Y - (0.d0, 1.d0)*af*dconjg(A) - vf*dconjg(B)) + 
     -         (e**2*Pg*Qf*Qi*(-2 + V**2)*(A + dconjg(A)) + 
     -            f**2*Pz*vi*
     -             ((-2.d0 + V**2)*(X + vf*dconjg(A)) + 
     -            (0.d0, 1.d0)*af*V**2*dconjg(B)))*dcos(theta))) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -           ((0.d0, 1.d0)*V*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y) - 
     -             ai*f**2*Pz*(-2.d0 + V**2)*X*dcos(theta)) + 
     -          dconjg(vi)*
     -           ((0.d0, 1.d0)*ai*f**2*Pz*V*Y - 
     -             (-2.d0 + V**2)*(A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*
     -              dcos(theta))) + 
     -       dconjg(vi)*
     -        ((0.d0,-1.d0)*ai*f**2*Pz*V*vf*dconjg(Y) - 
     -          (-2.d0 + V**2)*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(X)*dcos(theta) + 
     -          af*V*(ai*f**2*Pz*(X + dconjg(X)) + 
     -             (0.d0, 1.d0)*V*
     -              (B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y - dconjg(Y)))*dcos(theta)))
     -       + ai*((0.d0, -1.d0)*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(Y) + 
     -          ai*f**2*Pz*(2.d0 - V**2)*vf*dconjg(X)*
     -           dcos(theta) + 
     -          af*V*(A*e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vi*(X + dconjg(X)) + 
     -             (0.d0, 1.d0)*ai*f**2*Pz*V*(Y - dconjg(Y))*
     -              dcos(theta)))))*dsin(theta)

      RDM(3,1)=  4.d0*gam**5*m**4*(e**2*Qf*Qi*dconjg(Pg)*
     -     (ai*f**2*Pz*V*(af*dconjg(A) - 
     -          (0.d0, 1.d0)*(Y - vf*dconjg(B))) - 
     -       (e**2*Pg*Qf*Qi*(-2.d0 + V**2)*(A + dconjg(A)) + 
     -          f**2*Pz*vi*
     -           ((-2.d0 + V**2)*(X + vf*dconjg(A)) - 
     -             (0.d0, 1.d0)*af*V**2*dconjg(B)))*dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(-(ai*
     -          ((0.d0, 1.d0)*V*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y) + 
     -               ai*f**2*Pz*(-2.d0 + V**2)*X*dcos(theta))) + 
     -          dconjg(vi)*
     -           ((0.d0, -1.d0)*ai*f**2*Pz*V*Y - 
     -             (-2.d0 + V**2)*(A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*
     -              dcos(theta))) + 
     -       dconjg(vi)*
     -        ((0.d0, 1.d0)*ai*f**2*Pz*V*vf*dconjg(Y) - 
     -          (-2.d0 + V**2)*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(X)*dcos(theta) + 
     -          af*V*(ai*f**2*Pz*(X + dconjg(X)) - 
     -             (0.d0, 1.d0)*V*
     -              (B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y - dconjg(Y)))*dcos(theta)))
     -         + ai*((0.d0,1.d0)*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(Y) + 
     -          ai*f**2*Pz*(2.d0 - V**2)*vf*dconjg(X)*
     -           dcos(theta) + 
     -          af*V*(A*e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vi*(X + dconjg(X)) - 
     -             (0.d0, 1.d0)*ai*f**2*Pz*V*(Y - dconjg(Y))*
     -              dcos(theta)))))*dsin(theta)

      RDM(2,3)=  (0.d0, 4.d0)*gam**5*m**4*V*
     -  (e**2*Qf*Qi*dconjg(Pg)*
     -     (ai*f**2*Pz*V*(X - vf*dconjg(A) + 
     -          (0.d0, 1.d0)*af*dconjg(B)) + 
     -       (0.d0, 1.d0)*(e**2*Pg*Qf*Qi*(B + dconjg(B)) + 
     -          f**2*Pz*vi*
     -           (Y + (0.d0, 1.d0)*af*dconjg(A) + vf*dconjg(B)))*
     -        dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -           (A*e**2*Pg*Qf*Qi*V + f**2*Pz*V*vi*X + 
     -             (0.d0, 1.d0)*ai*f**2*Pz*Y*dcos(theta)) + 
     -          dconjg(vi)*
     -           (ai*f**2*Pz*V*X + 
     -             (0.d0, 1.d0)*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*
     -              dcos(theta))) + 
     -       (0.d0, 1.d0)*(dconjg(vi)*
     -           ((0.d0, 1.d0)*ai*f**2*Pz*V*vf*dconjg(X) + 
     -             (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(Y)*
     -              dcos(theta) + 
     -             af*(ai*f**2*Pz*V*(Y + dconjg(Y)) - 
     -                (0.d0, 1.d0)*
     -                 (A*e**2*Pg*Qf*Qi + 
     -                   f**2*Pz*vi*(X - dconjg(X)))*
     -                 dcos(theta))) + 
     -          ai*((0.d0, 1.d0)*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -              dconjg(X) + 
     -             ai*f**2*Pz*vf*dconjg(Y)*dcos(theta) + 
     -             af*(V*(B*e**2*Pg*Qf*Qi + 
     -                   f**2*Pz*vi*(Y + dconjg(Y))) - 
     -                (0.d0, 1.d0)*ai*f**2*Pz*(X - dconjg(X))*
     -                 dcos(theta))))))*dsin(theta)

      RDM(3,2)=  4.d0*gam**5*m**4*V*(e**2*Qf*Qi*dconjg(Pg)*
     -     (ai*f**2*Pz*V*((0.d0, 1.d0)*(X - vf*dconjg(A)) + 
     -          af*dconjg(B)) + 
     -       (e**2*Pg*Qf*Qi*(B + dconjg(B)) + 
     -          f**2*Pz*vi*
     -           (Y - (0.d0, 1.d0)*af*dconjg(A) + vf*dconjg(B)))*
     -        dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -         ((0.d0, 1.d0)*V*(A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X) + 
     -             ai*f**2*Pz*Y*dcos(theta)) + 
     -          dconjg(vi)*
     -           ((0.d0, 1.d0)*ai*f**2*Pz*V*X + 
     -           (B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*dcos(theta))) +
     -         dconjg(vi)*
     -        ((0.d0, -1.d0)*ai*f**2*Pz*V*vf*dconjg(X) + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(Y)*
     -           dcos(theta) + 
     -          af*(ai*f**2*Pz*V*(Y + dconjg(Y)) + 
     -             (0.d0, 1.d0)*(A*e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vi*(X - dconjg(X)))*dcos(theta)))
     -       + ai*((0.d0, -1.d0)*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(X) + 
     -          ai*f**2*Pz*vf*dconjg(Y)*dcos(theta) + 
     -          af*(V*(B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y + dconjg(Y))) + 
     -          (0.d0, 1.d0)*ai*f**2*Pz*(X - dconjg(X))*dcos(theta)
     -             ))))*dsin(theta)

      RDM(3,3)=  -8.d0*gam**6*m**4*(-1.d0 + V**2)*dcos(theta)*
     -  (e**2*Qf*Qi*dconjg(Pg)*
     -     ((A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*dcos(theta) + 
     -       dconjg(A)*(af*ai*f**2*Pz*V + 
     -          (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dcos(theta))) + 
     -    f**2*dconjg(Pz)*
     -     (ai*(af*V*(A*e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vi*(X + dconjg(X))) + 
     -          ai*f**2*Pz*X*dconjg(vf)*dcos(theta) + 
     -          ai*f**2*Pz*vf*dconjg(X)*dcos(theta)) + 
     -       dconjg(vi)*
     -        (af*ai*f**2*Pz*V*(X + dconjg(X)) + 
     -          ((A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*
     -              dconjg(vf) + 
     -             (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(X))*
     -           dcos(theta))))

      RDM(1,4)=  -4.d0*gam**3*m**4*(e**2*Qf*Qi*dconjg(Pg)*
     -     (ai*f**2*Pz*((1 + gam**2)*(X + vf*dconjg(A)) - 
     -          (0.d0, 1.d0)*af*(-1.d0 + gam**2)*dconjg(B)) + 
     -       (0.d0, 1.d0)*gam**2*V*
     -        (e**2*Pg*Qf*Qi*(B - dconjg(B)) + 
     -          f**2*Pz*vi*
     -         (Y - (0.d0, 1.d0)*af*dconjg(A) - vf*dconjg(B)))*
     -        dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -           ((1.d0 + gam**2)*
     -              (A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X) + 
     -           (0.d0, 1.d0)*ai*f**2*gam**2*Pz*V*Y*dcos(theta)) + 
     -          dconjg(vi)*
     -           (ai*f**2*(1.d0 + gam**2)*Pz*X + 
     -             (0.d0, 1.d0)*gam**2*V*
     -              (B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*dcos(theta)))
     -         + ai*((1.d0 + gam**2)*
     -           (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(X) - 
     -          (0.d0, 1.d0)*ai*f**2*gam**2*Pz*V*vf*dconjg(Y)*
     -           dcos(theta) + 
     -          af*((0.d0, 1.d0)*(-1.d0 + gam**2)*
     -              (B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y - dconjg(Y))) + 
     -             ai*f**2*gam**2*Pz*V*(X + dconjg(X))*
     -              dcos(theta))) + 
     -       dconjg(vi)*
     -        (ai*f**2*(1.d0 + gam**2)*Pz*vf*dconjg(X) - 
     -        (0.d0, 1.d0)*gam**2*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(Y)*dcos(theta) + 
     -          af*((0.d0, 1.d0)*ai*f**2*(-1.d0 + gam**2)*Pz*
     -              (Y - dconjg(Y)) + 
     -             gam**2*V*
     -              (A*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(X + dconjg(X)))*dcos(theta)))
     -       ))*dsin(theta)

      RDM(4,1)=  -4.d0*gam**3*m**4*(e**2*Qf*Qi*dconjg(Pg)*
     -     (ai*f**2*Pz*((1.d0 + gam**2)*(X + vf*dconjg(A)) + 
     -          (0.d0, 1.d0)*af*(-1.d0 + gam**2)*dconjg(B)) - 
     -       (0.d0, 1.d0)*gam**2*V*
     -        (e**2*Pg*Qf*Qi*(B - dconjg(B)) + 
     -          f**2*Pz*vi*
     -           (Y + (0.d0, 1.d0)*af*dconjg(A) - vf*dconjg(B)))*
     -        dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -           ((1.d0 + gam**2)*
     -              (A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X) - 
     -          (0.d0, 1.d0)*ai*f**2*gam**2*Pz*V*Y*dcos(theta)) + 
     -          dconjg(vi)*
     -           (ai*f**2*(1.d0 + gam**2)*Pz*X - 
     -             (0.d0, 1.d0)*gam**2*V*
     -              (B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*dcos(theta)))
     -         + ai*((1.d0 + gam**2)*
     -           (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(X) + 
     -          (0.d0, 1.d0)*ai*f**2*gam**2*Pz*V*vf*dconjg(Y)*
     -           dcos(theta) + 
     -          af*((0.d0, -1.d0)*(-1.d0 + gam**2)*
     -              (B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y - dconjg(Y))) + 
     -             ai*f**2*gam**2*Pz*V*(X + dconjg(X))*
     -              dcos(theta))) + 
     -       dconjg(vi)*
     -        (ai*f**2*(1.d0 + gam**2)*Pz*vf*dconjg(X) + 
     -        (0.d0, 1.d0)*gam**2*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(Y)*dcos(theta) + 
     -          af*((0.d0, -1.d0)*ai*f**2*(-1.d0 + gam**2)*Pz*
     -              (Y - dconjg(Y)) + 
     -             gam**2*V*
     -              (A*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(X + dconjg(X)))*dcos(theta)))
     -       ))*dsin(theta)

      RDM(2,4)=  4.d0*gam**3*m**4*(e**2*Qf*Qi*dconjg(Pg)*
     -     (ai*f**2*gam**2*Pz*V*
     -        (Y + (0.d0, 1.d0)*af*dconjg(A) + vf*dconjg(B)) - 
     -       (0.d0, 1.d0)*(-1.d0 + gam**2)*
     -        (e**2*Pg*Qf*Qi*(A - dconjg(A)) + 
     -          f**2*Pz*vi*
     -           (X - vf*dconjg(A) + (0.d0, 1.d0)*af*dconjg(B)))*
     -        dcos(theta)) + 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -           (gam**2*V*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y) - 
     -        (0.d0, 1.d0)*ai*f**2*(-1.d0 + gam**2)*Pz*X*dcos(theta)) +
     -            dconjg(vi)*
     -           (ai*f**2*gam**2*Pz*V*Y - 
     -             (0.d0, 1.d0)*(-1.d0 + gam**2)*
     -              (A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*dcos(theta)))
     -         + ai*(gam**2*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(Y) + 
     -          (0.d0, 1.d0)*ai*f**2*(-1.d0 + gam**2)*Pz*vf*dconjg(X)*
     -           dcos(theta) + 
     -          af*((0.d0, -1.d0)*gam**2*V*
     -              (A*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(X - dconjg(X))) + 
     -             ai*f**2*(-1.d0 + gam**2)*Pz*(Y + dconjg(Y))*
     -              dcos(theta))) + 
     -       dconjg(vi)*
     -        ((0.d0, 1.d0)*((0.d0, -1.d0)*ai*f**2*gam**2*Pz*V*vf*
     -              dconjg(Y) + 
     -             (-1.d0 + gam**2)*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -              dconjg(X)*dcos(theta)) + 
     -          af*((0.d0, -1.d0)*ai*f**2*gam**2*Pz*V*
     -              (X - dconjg(X)) + 
     -             (-1.d0 + gam**2)*
     -              (B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y + dconjg(Y)))*dcos(theta)))
     -       ))*dsin(theta)

      RDM(4,2)=   4.d0*gam**3*m**4*(e**2*Qf*Qi*dconjg(Pg)*
     -     (-(ai*f**2*gam**2*Pz*V*
     -          (Y - (0.d0, 1.d0)*af*dconjg(A) + vf*dconjg(B))) - 
     -       (0.d0, 1.d0)*(-1.d0 + gam**2)*
     -        (e**2*Pg*Qf*Qi*(A - dconjg(A)) + 
     -          f**2*Pz*vi*
     -           (X - vf*dconjg(A) - (0.d0, 1.d0)*af*dconjg(B)))*
     -        dcos(theta)) - 
     -    f**2*dconjg(Pz)*
     -     (dconjg(vf)*(ai*
     -           (gam**2*V*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y) + 
     -      (0.d0, 1.d0)*ai*f**2*(-1.d0 + gam**2)*Pz*X*dcos(theta)) +
     -            dconjg(vi)*
     -           (ai*f**2*gam**2*Pz*V*Y + 
     -             (0.d0, 1.d0)*(-1.d0 + gam**2)*
     -              (A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*dcos(theta)))
     -         + ai*(gam**2*V*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -           dconjg(Y) - 
     -          (0.d0, 1.d0)*ai*f**2*(-1.d0 + gam**2)*Pz*vf*dconjg(X)*
     -           dcos(theta) + 
     -          af*((0.d0, 1.d0)*gam**2*V*
     -              (A*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(X - dconjg(X))) + 
     -             ai*f**2*(-1.d0 + gam**2)*Pz*(Y + dconjg(Y))*
     -              dcos(theta))) + 
     -       dconjg(vi)*
     -        ((0.d0, -1.d0)*((0.d0, 1.d0)*ai*f**2*gam**2*Pz*V*vf*
     -              dconjg(Y) + 
     -             (-1.d0 + gam**2)*(e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*
     -              dconjg(X)*dcos(theta)) + 
     -          af*((0.d0, 1.d0)*ai*f**2*gam**2*Pz*V*
     -              (X - dconjg(X)) + 
     -             (-1.d0 + gam**2)*
     -              (B*e**2*Pg*Qf*Qi + 
     -                f**2*Pz*vi*(Y + dconjg(Y)))*dcos(theta)))
     -       ))*dsin(theta)

      RDM(3,4)=   -2.d0*gam**4*m**4*(f**2*dconjg(Pz)*
     -     (-(af*V*(ai**2*f**2*Pz*(X + dconjg(X)) + 
     -            dconjg(vi)*
     -             (A*e**2*Pg*Qf*Qi + 
     -               f**2*Pz*vi*(X + dconjg(X))))*
     -          (-2.d0 + gam**2*(-1.d0 + V**2) + 
     -            gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))) + 
     -       (0.d0, 1.d0)*((0.d0, -4.d0)*ai*
     -           (e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vf*(vi + dconjg(vi)))*dconjg(X)*
     -           dcos(theta) + 
     -          V*(ai**2*f**2*Pz*vf + 
     -             (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))
     -            *dconjg(Y)*
     -           (2.d0 + gam**2*(-1.d0 + V**2) + 
     -             gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))) + 
     -       dconjg(vf)*
     - ((0.d0, -1.d0)*ai*((0.d0, 4.d0)*(A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*
     -              dcos(theta) + 
     -             ai*f**2*Pz*V*Y*
     -              (2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))) + 
     -          dconjg(vi)*
     -           (4.d0*ai*f**2*Pz*X*dcos(theta) - 
     -             (0.d0, 1.d0)*V*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*
     -              (2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))))) + 
     -    e**2*Qf*Qi*dconjg(Pg)*
     -     (4.d0*ai*f**2*Pz*(X + vf*dconjg(A))*dcos(theta) - 
     -       (0.d0, 1.d0)*V*(e**2*Pg*Qf*Qi*(B - dconjg(B))*
     -           (2.d0 + gam**2*(-1.d0 + V**2) + 
     -             gam**2*(-1.d0 + V**2)*dcos(2.d0*theta)) + 
     -          f**2*Pz*vi*
     -           ((0.d0, -1.d0)*af*dconjg(A)*
     -              (-2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta)) + 
     -             (Y - vf*dconjg(B))*
     -              (2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))))))

      RDM(4,3)=  -2.d0*gam**4*m**4*(f**2*dconjg(Pz)*
     -     (-(af*V*(ai**2*f**2*Pz*(X + dconjg(X)) + 
     -            dconjg(vi)*
     -             (A*e**2*Pg*Qf*Qi + 
     -               f**2*Pz*vi*(X + dconjg(X))))*
     -          (-2.d0 + gam**2*(-1.d0 + V**2) + 
     -            gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))) - 
     -       (0.d0, 1.d0)*((0.d0, 4.d0)*ai*
     -           (e**2*Pg*Qf*Qi + 
     -             f**2*Pz*vf*(vi + dconjg(vi)))*dconjg(X)*
     -           dcos(theta) + 
     -          V*(ai**2*f**2*Pz*vf + 
     -             (e**2*Pg*Qf*Qi + f**2*Pz*vf*vi)*dconjg(vi))
     -            *dconjg(Y)*
     -           (2.d0 + gam**2*(-1.d0 + V**2) + 
     -             gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))) + 
     -       dconjg(vf)*
     - ((0.d0, 1.d0)*ai*((0.d0, -4.d0)*(A*e**2*Pg*Qf*Qi + f**2*Pz*vi*X)*
     -              dcos(theta) + 
     -             ai*f**2*Pz*V*Y*
     -              (2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))) + 
     -          dconjg(vi)*
     -           (4.d0*ai*f**2*Pz*X*dcos(theta) + 
     -             (0.d0, 1.d0)*V*(B*e**2*Pg*Qf*Qi + f**2*Pz*vi*Y)*
     -              (2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))))) + 
     -    e**2*Qf*Qi*dconjg(Pg)*
     -     (4.d0*ai*f**2*Pz*(X + vf*dconjg(A))*dcos(theta) + 
     -       (0.d0, 1.d0)*V*(e**2*Pg*Qf*Qi*(B - dconjg(B))*
     -           (2.d0 + gam**2*(-1.d0 + V**2) + 
     -             gam**2*(-1.d0 + V**2)*dcos(2.d0*theta)) + 
     -          f**2*Pz*vi*
     -           ((0.d0, 1.d0)*af*dconjg(A)*
     -              (-2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta)) + 
     -             (Y - vf*dconjg(B))*
     -              (2.d0 + gam**2*(-1.d0 + V**2) + 
     -                gam**2*(-1.d0 + V**2)*dcos(2.d0*theta))))))

      RDM(4,4)=  8.d0*gam**4*m**4*(e**4*Pg*Qf**2*Qi**2*(A + dconjg(A))*
     -     dconjg(Pg) + 
     -    e**2*f**2*Qf*Qi*(Pz*vi*X*dconjg(Pg) + 
     -       A*Pg*dconjg(Pz)*dconjg(vf)*dconjg(vi) + 
     -       Pg*dconjg(Pz)*dconjg(vi)*dconjg(X) + 
     -       A*af*ai*Pg*V*dconjg(Pz)*dcos(theta) + 
     -       Pz*dconjg(A)*dconjg(Pg)*
     -        (vf*vi + af*ai*V*dcos(theta))) + 
     -    f**4*Pz*dconjg(Pz)*
     -     (ai*(ai*X*dconjg(vf) + ai*vf*dconjg(X) + 
     -          af*V*vi*X*dcos(theta) + 
     -          af*V*vi*dconjg(X)*dcos(theta)) + 
     -       dconjg(vi)*
     -        (vi*(X*dconjg(vf) + vf*dconjg(X)) + 
     -          af*ai*V*(X + dconjg(X))*dcos(theta))))

c-------------------------------------------------------------
c   TOTAL SPIN-CORRELATION MATRIX: STANDARD MODEL + DIPOLE MOMENTS
c-------------------------------------------------------------
      do i=1,4
       do j=1,4
         R(i,j)= RSM(i,j) + RDM(i,j)
       enddo
      enddo	   

      return
      end	
